/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui.Monitor_4;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import nodes.devices.Monitor_4.Monitor4BaseItem;
import nodes.gui.Monitor_4.MonitorDialog_4;

public class ItemPopup
extends JPopupMenu
implements ActionListener {
    private JTree treeMenu;
    private DefaultMutableTreeNode treeItemSelected;
    public static final String ADD_MENU = "Add Menu";
    public static final String ADD_VARIABLE = "Add Variable";
    private static final String DELETE_NODE = "Delete Node";
    MonitorDialog_4 parent;

    public ItemPopup(JTree tree, MonitorDialog_4 pp) {
        this.parent = pp;
        this.treeMenu = tree;
    }

    public void setupMenu(DefaultMutableTreeNode treeItemSelected) {
        this.treeItemSelected = treeItemSelected;
        Monitor4BaseItem item = (Monitor4BaseItem)treeItemSelected.getUserObject();
        this.removeAll();
        JMenuItem mi = new JMenuItem("Delete");
        mi.setActionCommand(DELETE_NODE);
        mi.addActionListener(this);
        this.add(mi);
        this.add(new JSeparator());
        if (treeItemSelected.isRoot()) {
            this.createMenu();
        } else if (item.getType().equals((Object)Monitor4BaseItem.monitor4Types.Menu)) {
            this.createMenu();
        } else if (item.getType().equals((Object)Monitor4BaseItem.monitor4Types.Variable)) {
            this.createDeleteMenu();
        }
    }

    private void createMenu() {
        this.removeAll();
        JMenuItem mi = new JMenuItem(ADD_MENU);
        mi.addActionListener(this);
        mi.setActionCommand(ADD_MENU);
        this.add(mi);
        mi = new JMenuItem(ADD_VARIABLE);
        mi.addActionListener(this);
        mi.setActionCommand(ADD_VARIABLE);
        this.add(mi);
        this.add(new JSeparator());
        mi = new JMenuItem("Delete");
        mi.addActionListener(this);
        mi.setActionCommand(DELETE_NODE);
        this.add(mi);
    }

    private void createDeleteMenu() {
        this.removeAll();
        JMenuItem mi = new JMenuItem("Delete");
        mi.addActionListener(this);
        mi.setActionCommand(DELETE_NODE);
        this.add(mi);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Monitor4BaseItem newItem = new Monitor4BaseItem();
        DefaultTreeModel model = (DefaultTreeModel)this.treeMenu.getModel();
        if (e.getActionCommand().equals(DELETE_NODE)) {
            if (this.treeItemSelected.isRoot()) {
                return;
            }
            this.parent.removeNode(this.treeItemSelected);
        } else {
            this.parent.addNode(this.treeItemSelected, e.getActionCommand());
        }
    }
}

