/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import nodes.devices.GenericNode;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class NewMuxDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    Locale currentLocale;
    int returnStatus;
    private AppOptions options = new AppOptions();
    ResourceBundle message;
    public boolean fieldChanged = false;
    GenericNode parentNode;
    FieldChangeListener fcl = new FieldChangeListener();
    public JButton btnCancel;
    public JButton btnOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane2;
    public JLabel lblAddress;
    public JLabel lblField1;
    private JLabel lblWrongAddress;
    public JSpinner spnrNumIn;
    public JTable table;
    public JTextField txtAddress;

    public NewMuxDialog(Frame parent, boolean modal, GenericNode parentNode) {
        super(parent, modal);
        this.initComponents();
        this.clearTable();
        this.insertTableValue();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.parentNode = parentNode;
        this.addComponentListener(new ComponentAdapter());
        this.lblWrongAddress.setVisible(false);
        this.center();
    }

    private void initComponents() {
        this.lblAddress = new JLabel();
        this.txtAddress = new JTextField();
        this.lblField1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.spnrNumIn = new JSpinner();
        this.jLabel1 = new JLabel();
        this.lblWrongAddress = new JLabel();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.lblAddress.setName("lblAddress");
        this.txtAddress.setColumns(5);
        this.txtAddress.setName("txtAddress");
        this.lblField1.setName("lblField1");
        this.jScrollPane2.setName("jScrollPane2");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"IN NUMBER", "VALUE"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setName("table");
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewMuxDialog.this.tablePropertyChange(evt);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewMuxDialog.this.tableKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.table);
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(NewMuxDialog.class);
        this.btnOk.setIcon(resourceMap.getIcon("btnOk.icon"));
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewMuxDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setIcon(resourceMap.getIcon("btnCancel.icon"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewMuxDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.spnrNumIn.setModel(new SpinnerNumberModel(2, 2, 16, 1));
        this.spnrNumIn.setName("spnrNumIn");
        this.spnrNumIn.setValue(2);
        this.spnrNumIn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewMuxDialog.this.spnrNumInStateChanged(evt);
            }
        });
        this.spnrNumIn.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewMuxDialog.this.spnrNumInPropertyChange(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.lblWrongAddress.setFont(resourceMap.getFont("lblWrongAddress.font"));
        this.lblWrongAddress.setForeground(resourceMap.getColor("lblWrongAddress.foreground"));
        this.lblWrongAddress.setText(resourceMap.getString("lblWrongAddress.text", new Object[0]));
        this.lblWrongAddress.setName("lblWrongAddress");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.lblAddress)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.spnrNumIn, -2, 42, -2)).addComponent(this.jScrollPane2, -1, 176, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblField1)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtAddress, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblWrongAddress)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnOk).addGap(18, 18, 18).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtAddress, -2, -1, -2)).addGap(3, 3, 3).addComponent(this.lblWrongAddress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAddress).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.lblField1)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnrNumIn, -2, -1, -2).addComponent(this.jLabel2)).addGap(9, 9, 9).addComponent(this.jScrollPane2, -2, 126, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.lblWrongAddress.isVisible()) {
            JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
            return;
        }
        this.returnStatus = 1;
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    public void changeTableRows(int newNumRows) {
        if (newNumRows > this.table.getRowCount()) {
            for (int i = this.table.getRowCount(); i < newNumRows; ++i) {
                ((DefaultTableModel)this.table.getModel()).addRow(new Integer[]{this.table.getRowCount(), 0});
            }
        } else {
            while (this.table.getRowCount() > newNumRows) {
                ((DefaultTableModel)this.table.getModel()).removeRow(this.table.getRowCount() - 1);
            }
        }
        this.validate();
    }

    private void spnrNumInStateChanged(ChangeEvent evt) {
        int newNumIn = Integer.parseInt(this.spnrNumIn.getValue().toString());
        this.changeTableRows(newNumIn);
        this.fieldChanged = true;
    }

    private void spnrNumInPropertyChange(PropertyChangeEvent evt) {
        int newNumIn = Integer.parseInt(this.spnrNumIn.getValue().toString());
        this.changeTableRows(newNumIn);
        this.fieldChanged = true;
    }

    private void tablePropertyChange(PropertyChangeEvent evt) {
        this.fieldChanged = true;
    }

    private void tableKeyTyped(KeyEvent evt) {
        this.fieldChanged = true;
    }

    public void clearTable() {
        int nOfRows = this.table.getModel().getRowCount();
        if (nOfRows > 2) {
            for (int row = 0; row < nOfRows; ++row) {
                ((DefaultTableModel)this.table.getModel()).removeRow(0);
            }
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void insertTableValue() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.table.getModel().setValueAt(i, i, 0);
        }
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewMuxDialog dialog = new NewMuxDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class FieldChangeListener
    implements DocumentListener {
        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            NewMuxDialog.this.fieldChanged = true;
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NewMuxDialog.this.fieldChanged = true;
            this.control();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NewMuxDialog.this.fieldChanged = true;
            this.control();
        }

        public void control() {
            if (NewMuxDialog.this.txtAddress.getText().equals("")) {
                NewMuxDialog.this.lblWrongAddress.setVisible(true);
            }
            if (NewMuxDialog.this.parentNode.controlAddress(NewMuxDialog.this.txtAddress.getText(), false).booleanValue()) {
                NewMuxDialog.this.lblWrongAddress.setVisible(true);
            } else {
                NewMuxDialog.this.lblWrongAddress.setVisible(false);
            }
        }
    }

    class ComponentAdapter
    implements ComponentListener {
        ComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            NewMuxDialog.this.txtAddress.setEnabled(!NewMuxDialog.this.parentNode.kernelConnected);
            NewMuxDialog.this.txtAddress.getDocument().addDocumentListener(NewMuxDialog.this.fcl);
            NewMuxDialog.this.fieldChanged = false;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            NewMuxDialog.this.txtAddress.getDocument().removeDocumentListener(NewMuxDialog.this.fcl);
        }
    }
}

