/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import VisiProg.AppOptions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PanelDevice
extends JPanel {
    private static final long serialVersionUID = -262697958511920891L;
    private static Dimension boxdim = new Dimension(250, 450);
    private String title;
    private JComboBox comboTimerID;
    public JButton btnChangeTimer;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();

    public PanelDevice(String title, Dimension newboxdim, int nOfTimers) {
        this.setFont(new Font("sansserif", 1, 32));
        this.title = title;
        boxdim = newboxdim;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.setAlignmentX(0.5f);
        this.setPreferredSize(newboxdim);
        this.setLayout(new BoxLayout(this, 1));
        this.setAlarm(false);
        this.AddTimerCommands(nOfTimers);
    }

    public void EnableTimerCommands(boolean enable) {
        this.comboTimerID.setEnabled(enable);
        this.btnChangeTimer.setEnabled(enable);
    }

    private void AddTimerCommands(int nOfTimers) {
        JPanel commandPanel = new JPanel();
        JLabel labl = new JLabel("Timer:");
        this.comboTimerID = new JComboBox();
        this.comboTimerID.addItem("No Timer");
        for (int i = 0; i < nOfTimers; ++i) {
            this.comboTimerID.addItem("Timer " + (i + 1));
        }
        this.btnChangeTimer = new JButton();
        this.btnChangeTimer.setText(this.message.getString("imposta"));
        if (nOfTimers != 0) {
            commandPanel.add(labl);
            commandPanel.add(this.comboTimerID);
            commandPanel.add(this.btnChangeTimer);
            this.add(commandPanel);
        }
    }

    public void setComboTimerIndex(int index) {
        try {
            this.comboTimerID.setSelectedIndex(index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setAlarm(boolean b) {
        TitledBorder tb = b ? new TitledBorder(new EtchedBorder(1, Color.RED, Color.MAGENTA), this.title) : new TitledBorder(new EtchedBorder(1), this.title);
        tb.setTitleFont(new Font("sansserif", 1, 12));
        this.setBorder(tb);
    }

    public void AddTimerCommandsActionListener(ActionListener newAL) {
        this.btnChangeTimer.addActionListener(newAL);
    }

    public int getTimerID() {
        return this.comboTimerID.getSelectedIndex();
    }
}

