/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import VisiProg.AppOptions;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import nodes.CommonDefinitions;
import nodes.devices.CommentNode;
import nodes.devices.GenericNode;
import nodes.devices.ScopeNode;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveControlPointProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.ReconnectProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphElement;
import sceneManager.AFONode;
import sceneManager.AFOPin;
import sceneManager.AFOReconnectProvider;
import sceneManager.AFORouter;
import sceneManager.AfoConnectProvider;
import sceneManager.AfoSelectProvider;
import sceneManager.MultiMoveProvider;
import sceneManager.SceneEvent;
import sceneManager.SceneEventListener;
import sceneManager.TextEditorEvent;
import sceneManager.TextEditorEventListener;

public class AFOGraphPinScene
extends GraphPinScene<AFONode, AFOEdge, AFOPin>
implements KeyListener {
    private LayerWidget background;
    public LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private LayerWidget pinLayer;
    public LayerWidget interactionLayer;
    private WidgetAction selectAction;
    private WidgetAction connectAction;
    private WidgetAction reconnectAction;
    private WidgetAction moveAction;
    private AfoSelectProvider selectProvider;
    private AfoConnectProvider connectProvider;
    private AFOReconnectProvider reconnectProvider;
    private WidgetAction popupMenuAction;
    private WidgetAction editorAction;
    public long nodeIDcounter = 0L;
    public long edgeIDcounter = 0L;
    public long pinIDCounter = 0L;
    public Color drawEdgeColor = Color.BLUE;
    private PopupMenuProvider widgetPopupMenu;
    protected EventListenerList listenerList = new EventListenerList();
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();

    public AFOGraphPinScene() {
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.background = new LayerWidget((Scene)this);
        this.mainLayer = new LayerWidget((Scene)this);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.pinLayer = new LayerWidget((Scene)this);
        this.interactionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.background);
        this.addChild((Widget)this.mainLayer);
        this.addChild((Widget)this.connectionLayer);
        this.addChild((Widget)this.pinLayer);
        this.addChild((Widget)this.interactionLayer);
        this.selectProvider = new AfoSelectProvider(this);
        this.selectAction = ActionFactory.createSelectAction((SelectProvider)this.selectProvider);
        this.connectProvider = new AfoConnectProvider(this, this.connectionLayer);
        this.connectAction = ActionFactory.createExtendedConnectAction((LayerWidget)this.connectionLayer, (ConnectProvider)this.connectProvider);
        this.reconnectProvider = new AFOReconnectProvider(this, this.connectionLayer);
        this.reconnectAction = ActionFactory.createReconnectAction((ReconnectProvider)this.reconnectProvider);
        this.moveAction = ActionFactory.createMoveAction(null, (MoveProvider)new MultiMoveProvider(this));
        this.editorAction = ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new LabelTextFieldEditor());
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((ObjectScene)this, (LayerWidget)this.background));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createEditAction((EditProvider)new EditProvider(){

            public void edit(Widget widget) {
                Set blockList = AFOGraphPinScene.this.getSelectedObjects();
                Object[] blockArray = blockList.toArray();
                if (blockArray.length == 1 && blockArray[0] instanceof AFOGraphElement) {
                    try {
                        ((GenericNode)blockArray[0]).showPropertiesDialog();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }));
        this.setFont(this.getDefaultFont().deriveFont(8.0f));
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_CHILDREN);
        this.initGrids();
    }

    public void addSceneEventListener(SceneEventListener listener) {
        this.listenerList.add(SceneEventListener.class, listener);
    }

    public void removeSceneEventListener(SceneEventListener listener) {
        this.listenerList.remove(SceneEventListener.class, listener);
    }

    void fireEvent(SceneEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != SceneEventListener.class) continue;
            ((SceneEventListener)listeners[i + 1]).sceneEventOccurred(evt);
        }
    }

    public void enableConnectAndReconnect(boolean enable) {
        this.reconnectProvider.enableReconnect(enable);
        this.connectProvider.enableConnect(enable);
    }

    public void setWidgetPopupMenuActiom(PopupMenuProvider widgetPopup) {
        this.widgetPopupMenu = widgetPopup;
    }

    public void setScenePopupMenuAction(PopupMenuProvider newPopup) {
        this.popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)newPopup);
        this.getActions().addAction(this.popupMenuAction);
    }

    WidgetAction getEditorAction(LabelTextFieldEditor editor) {
        return ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)editor);
    }

    public AfoSelectProvider getSelectProvider() {
        return this.selectProvider;
    }

    LabelTextFieldEditor getEditor() {
        return new LabelTextFieldEditor();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        String keyString = KeyEvent.getKeyText(keyCode);
        String modifier = KeyEvent.getKeyModifiersText(e.getModifiers());
        if (keyString.equals("Z") && modifier.equals("Ctrl")) {
            System.out.println("Undo");
            this.fireEvent(new SceneEvent(this, "Scene Perform Undo"));
        } else if (keyString.equals("Y") && modifier.equals("Ctrl")) {
            System.out.println("Redo");
            this.fireEvent(new SceneEvent(this, "Scene Perform Redo"));
        } else if (keyString.equals("C") && modifier.equals("Ctrl")) {
            System.out.println("Copy");
            if (this.getSelectedObjects().size() > 0) {
                Widget wdg = ((AFOGraphElement)this.getSelectedObjects().toArray()[0]).getWidget();
                this.fireEvent(new SceneEvent((Object)this, "Scene Copy", wdg));
            }
        } else if (keyString.equals("V") && modifier.equals("Ctrl")) {
            System.out.println("Paste");
            this.fireEvent(new SceneEvent(this, "Scene Paste"));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected Widget attachNodeWidget(AFONode node) {
        Widget widget = node.getWidget();
        widget.setCheckClipping(true);
        this.mainLayer.addChild(widget);
        widget.getActions().addAction(this.selectAction);
        widget.getActions().addAction(this.moveAction);
        if (this.widgetPopupMenu != null) {
            widget.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this.widgetPopupMenu));
        } else {
            JOptionPane.showMessageDialog(null, this.message.getString("widget"), this.message.getString("er"), 0);
        }
        if (!(node instanceof CommentNode) && !(node instanceof ScopeNode)) {
            this.fireEvent(new SceneEvent(this, "Scene Changed"));
        }
        this.validate();
        return widget;
    }

    public void setEdgeColor(Color newColor) {
        this.drawEdgeColor = newColor;
    }

    public Color getEdgeColor() {
        return this.drawEdgeColor;
    }

    public void sceneChanged() {
        this.fireEvent(new SceneEvent(this, "Scene Changed"));
    }

    protected Widget attachEdgeWidget(AFOEdge edge) {
        ConnectionWidget connectionWidget = new ConnectionWidget((Scene)this);
        connectionWidget.setLineColor(this.drawEdgeColor);
        connectionWidget.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        connectionWidget.setEndPointShape(PointShape.SQUARE_FILLED_BIG);
        connectionWidget.setRouter((Router)new AFORouter(this, connectionWidget));
        connectionWidget.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
        connectionWidget.setPaintControlPoints(true);
        connectionWidget.setControlPointShape(PointShape.SQUARE_FILLED_BIG);
        connectionWidget.setControlPointsCursor(Cursor.getPredefinedCursor(13));
        connectionWidget.setControlPointCutDistance(5);
        connectionWidget.getActions().addAction(this.createSelectAction());
        connectionWidget.getActions().addAction(this.reconnectAction);
        connectionWidget.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this.widgetPopupMenu));
        connectionWidget.getActions().addAction(ActionFactory.createAddRemoveControlPointAction((double)1.0, (double)5.0, (ConnectionWidget.RoutingPolicy)ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED));
        connectionWidget.getActions().addAction(ActionFactory.createMoveControlPointAction((MoveControlPointProvider)ActionFactory.createOrthogonalMoveControlPointProvider(), (ConnectionWidget.RoutingPolicy)ConnectionWidget.RoutingPolicy.UPDATE_END_POINTS_ONLY));
        connectionWidget.getActions().addAction(this.selectAction);
        connectionWidget.setCheckClipping(true);
        this.connectionLayer.addChild((Widget)connectionWidget);
        this.fireEvent(new SceneEvent(this, "Scene Changed"));
        this.validate();
        return connectionWidget;
    }

    protected Widget attachPinWidget(AFONode node, AFOPin pin) {
        Widget pinWidget = pin.getWidget();
        pinWidget.getActions().addAction(this.connectAction);
        this.validate();
        return pinWidget;
    }

    public List<AFONode> getNodesConnectedAtPin(AFOPin pin) {
        ArrayList<AFONode> nodeList = new ArrayList<AFONode>();
        Collection pinEdges = this.findPinEdges(pin, true, false);
        Iterator edgeIt = pinEdges.iterator();
        while (edgeIt.hasNext()) {
            nodeList.add((AFONode)this.getPinNode(this.getEdgeTarget(edgeIt.next())));
        }
        return nodeList;
    }

    public void initGrids() {
    }

    protected void attachEdgeSourceAnchor(AFOEdge edge, AFOPin oldSourcePin, AFOPin sourcePin) {
        ((ConnectionWidget)this.findWidget(edge)).setSourceAnchor(AnchorFactory.createDirectionalAnchor((Widget)this.findWidget(sourcePin), (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL));
        this.fireEvent(new SceneEvent(this, "Scene Changed"));
    }

    protected void attachEdgeTargetAnchor(AFOEdge edge, AFOPin oldTargetPin, AFOPin targetPin) {
        ((ConnectionWidget)this.findWidget(edge)).setTargetAnchor(AnchorFactory.createDirectionalAnchor((Widget)this.findWidget(targetPin), (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL));
        this.fireEvent(new SceneEvent(this, "Scene Changed"));
    }

    public class LabelTextFieldEditor
    implements TextFieldInplaceEditor {
        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return ((LabelWidget)widget).getLabel();
        }

        public void setText(Widget widget, String text) {
            AFONode node = (AFONode)AFOGraphPinScene.this.findObject(widget);
            if (node.getBlockType() == CommonDefinitions.blockTypes.Subsystem) {
                Collection nodeCollection = AFOGraphPinScene.this.getNodes();
                Iterator nodeIt = nodeCollection.iterator();
                while (nodeIt.hasNext()) {
                    if (!((AFONode)nodeIt.next()).getComment().equals(text)) continue;
                    JOptionPane.showMessageDialog(null, AFOGraphPinScene.this.message.getString("duplicate"), AFOGraphPinScene.this.message.getString("er"), 0);
                    return;
                }
            }
            ((LabelWidget)widget).setLabel(text);
            node.setComment(text);
            this.fireEvent(new TextEditorEvent(this));
        }

        public void addEventListener(TextEditorEventListener listener) {
            AFOGraphPinScene.this.listenerList.add(TextEditorEventListener.class, listener);
        }

        public void removeEventListener(TextEditorEventListener listener) {
            AFOGraphPinScene.this.listenerList.remove(TextEditorEventListener.class, listener);
        }

        void fireEvent(TextEditorEvent evt) {
            Object[] listeners = AFOGraphPinScene.this.listenerList.getListenerList();
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != TextEditorEventListener.class) continue;
                ((TextEditorEventListener)listeners[i + 1]).textEditorEventOccurred(evt);
            }
        }
    }
}

