/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import VisiProg.AppOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphElement;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class AFONode
extends AFOGraphElement
implements Comparable {
    protected List<AFOPin> pinList;
    protected CommonDefinitions.blockTypes blockType;
    protected String comment = "Comment";
    protected JDialog propertiesDialog = null;
    protected WidgetAction editorAction;
    private AppOptions options = new AppOptions();
    protected CommonDefinitions.subBlockTypes subType;
    Locale currentLocale;
    ResourceBundle message;
    protected AFOGraphPinScene.LabelTextFieldEditor textEditor;
    protected int addressSpace;
    protected ArrayList<Integer> addressList;

    public AFONode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.pinList = new ArrayList<AFOPin>();
        try {
            this.textEditor = scene.getEditor();
            this.editorAction = scene.getEditorAction(this.textEditor);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.subType = CommonDefinitions.subBlockTypes.NONE;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
    }

    public JDialog getPropertiesDialog() {
        return this.propertiesDialog;
    }

    public List<AFOPin> getPinList() {
        return this.pinList;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        ((AFONodeWidget)this.widget).getModuleComment().setLabel(comment);
    }

    public CommonDefinitions.blockTypes getBlockType() {
        return this.blockType;
    }

    public void setBlockType(CommonDefinitions.blockTypes blockType) {
        this.blockType = blockType;
    }

    public int getNofInputPins() {
        int retVal = 0;
        for (int i = 0; i < this.pinList.size(); ++i) {
            if (this.pinList.get(i).getPinType() == AFOPin.E_PinType.PIN_OUTPUT) continue;
            ++retVal;
        }
        return retVal;
    }

    public int getNofOutputPins() {
        int retVal = 0;
        for (int i = 0; i < this.pinList.size(); ++i) {
            if (this.pinList.get(i).getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            ++retVal;
        }
        return retVal;
    }

    public void addPin(AFOPin newPin) {
        this.pinList.add(newPin);
    }

    public int getPinListSize() {
        return this.pinList.size();
    }

    public AFOPin getPinAt(int pinIndex) {
        try {
            return this.pinList.get(pinIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void RotateNode() {
        this.widget = ((AFONodeWidget)this.widget).IsRotated() ? ((AFONodeWidget)this.widget).GetDirectInstance() : ((AFONodeWidget)this.widget).GetRotatedInstance();
    }

    public int compareTo(Object arg0) {
        AFONode node = (AFONode)arg0;
        return this.id.compareTo(node.getId());
    }

    public void showPropertiesDialog() throws Exception {
    }

    public Element serializeNode(Document xml, Element nodeElement) throws Exception {
        return nodeElement;
    }

    public void deserializeNode(Node node) throws Exception {
    }

    public CommonDefinitions.subBlockTypes getSubType() {
        return this.subType;
    }

    public void setSubType(CommonDefinitions.subBlockTypes subType) {
        this.subType = subType;
    }

    public Widget getOverallWidget() {
        return ((AFONodeWidget)this.widget).GetModuleWidget();
    }

    public int getAddressSpace() {
        return this.addressSpace;
    }

    public List<Integer> getAddressList() {
        return this.addressList;
    }
}

