/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import org.netbeans.api.visual.widget.LabelWidget;
import sceneManager.AFOGraphElement;
import sceneManager.AFONode;

public class AFOPin
extends AFOGraphElement {
    private E_PinType pinType;
    private boolean isBusInput;
    private LabelWidget pinNameWidget;
    private AFONode parentNode;
    private String pinIDString = "ERROR";
    public int pinAddress = 0;

    public AFONode getParentNode() {
        return this.parentNode;
    }

    public String controlDecimal(String valore) {
        double val = Double.parseDouble(valore);
        double fattore = Math.pow(10.0, 1.0);
        double number = Math.ceil(val * fattore) / fattore;
        return Double.toString(number);
    }

    public void setValue(String value) {
        String pinLabel = this.getPinNameWidget().getLabel();
        String val = this.controlDecimal(value);
        if (this.getPinType() == E_PinType.PIN_INPUT) {
            int subStrIdx = pinLabel.indexOf("(");
            if (subStrIdx >= 0) {
                pinLabel = pinLabel.substring(0, subStrIdx);
            }
            this.getPinNameWidget().setLabel(pinLabel + "(" + val + ")");
        } else {
            int subStrIdx = pinLabel.indexOf(")");
            if (subStrIdx > 0) {
                pinLabel = pinLabel.substring(subStrIdx + 1);
            }
            this.getPinNameWidget().setLabel("(" + val + ")" + pinLabel);
        }
    }

    public String getValue() {
        String pinLabel = this.getPinNameWidget().getLabel();
        int subStrIdx_1 = pinLabel.indexOf("(");
        int subStrIdx_2 = pinLabel.indexOf(")");
        try {
            return pinLabel.substring(subStrIdx_1, subStrIdx_2);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void setParentNode(AFONode parentNode) {
        this.parentNode = parentNode;
    }

    public String getPinIDString() {
        return this.pinIDString;
    }

    public void setPinIDString(String pinIDString) {
        this.pinIDString = pinIDString;
    }

    public AFOPin(String ID, String label, E_PinType isInput) {
        super(ID, label, null);
        this.pinType = isInput;
        this.isBusInput = false;
    }

    public E_PinType getPinType() {
        return this.pinType;
    }

    public void setPinType(E_PinType pinType) {
        this.pinType = pinType;
    }

    public boolean isBusPin() {
        return this.isBusInput;
    }

    public void setAsBusPin(boolean isBusInput) {
        this.isBusInput = isBusInput;
    }

    public LabelWidget getPinNameWidget() {
        return this.pinNameWidget;
    }

    public void setPinNameWidget(LabelWidget pinLabelWidget) {
        this.pinNameWidget = pinLabelWidget;
    }

    public String toString() {
        return this.label;
    }

    public static enum E_PinType {
        PIN_OUTPUT,
        PIN_COMMAND,
        PIN_INPUT;

    }
}

