/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import java.awt.Point;
import nodes.CommonDefinitions;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.ReconnectProvider;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

class AFOReconnectProvider
implements ReconnectProvider {
    private AFOEdge edge;
    private AFOPin originalPin;
    private AFOPin replacementPin;
    private AFOGraphPinScene scene;
    private LayerWidget connectionLayer;
    private boolean reconnectEnabled = true;

    public AFOReconnectProvider(AFOGraphPinScene scene, LayerWidget connectionLayer) {
        this.scene = scene;
        this.connectionLayer = connectionLayer;
    }

    public boolean isSourceReconnectable(ConnectionWidget connectionWidget) {
        Object object = this.scene.findObject((Widget)connectionWidget);
        this.edge = this.scene.isEdge(object) ? (AFOEdge)object : null;
        this.originalPin = this.edge != null ? (AFOPin)this.scene.getEdgeSource(this.edge) : null;
        return this.originalPin != null;
    }

    public boolean isTargetReconnectable(ConnectionWidget connectionWidget) {
        Object object = this.scene.findObject((Widget)connectionWidget);
        this.edge = this.scene.isEdge(object) ? (AFOEdge)object : null;
        this.originalPin = this.edge != null ? (AFOPin)this.scene.getEdgeTarget(this.edge) : null;
        return this.originalPin != null;
    }

    public void reconnectingStarted(ConnectionWidget arg0, boolean arg1) {
    }

    public void reconnectingFinished(ConnectionWidget arg0, boolean arg1) {
    }

    public ConnectorState isReplacementWidget(ConnectionWidget connectionWidget, Widget replacementWidget, boolean reconnectingSource) {
        Object object = this.scene.findObject(replacementWidget);
        AFOPin aFOPin = this.replacementPin = this.scene.isPin(object) ? (AFOPin)object : null;
        if (this.replacementPin != null) {
            return ConnectorState.ACCEPT;
        }
        return object != null ? ConnectorState.REJECT_AND_STOP : ConnectorState.REJECT;
    }

    public boolean hasCustomReplacementWidgetResolver(Scene arg0) {
        return false;
    }

    public Widget resolveReplacementWidget(Scene arg0, Point arg1) {
        return null;
    }

    public void enableReconnect(boolean enable) {
        this.reconnectEnabled = enable;
    }

    public void reconnect(ConnectionWidget connectionWidget, Widget replacementWidget, boolean reconnectingSource) {
        boolean isReplacementDriver;
        boolean busPinOK;
        if (!this.reconnectEnabled) {
            return;
        }
        if (replacementWidget == null) {
            busPinOK = false;
        } else {
            boolean bl = busPinOK = this.originalPin.isBusPin() == this.replacementPin.isBusPin();
        }
        if (!busPinOK) {
            return;
        }
        int originalOrdinal = this.originalPin.getParentNode().getBlockType().ordinal();
        int replacementOrdinal = this.replacementPin.getParentNode().getBlockType().ordinal();
        boolean isOriginalDriver = originalOrdinal <= CommonDefinitions.blockTypes.ModbusOUT.ordinal();
        boolean bl = isReplacementDriver = replacementOrdinal <= CommonDefinitions.blockTypes.ModbusOUT.ordinal();
        if (reconnectingSource) {
            if (this.replacementPin.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) {
                return;
            }
            if (isOriginalDriver ^ isReplacementDriver) {
                return;
            }
            this.scene.setEdgeSource(this.edge, this.replacementPin);
        } else {
            if (this.replacementPin.getPinType() != AFOPin.E_PinType.PIN_INPUT || this.scene.findPinEdges(this.replacementPin, false, true).size() > 0) {
                return;
            }
            if (isOriginalDriver ^ isReplacementDriver) {
                return;
            }
            this.scene.setEdgeTarget(this.edge, this.replacementPin);
        }
    }
}

