/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import java.awt.Point;
import java.util.Collection;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;

public class AfoSelectProvider
implements SelectProvider {
    private AFOGraphPinScene scene;
    private WidgetAction keyAction;
    private boolean connectionReset = false;

    public AfoSelectProvider(AFOGraphPinScene scene) {
        this.scene = scene;
    }

    public boolean isAimingAllowed(Widget arg0, Point arg1, boolean arg2) {
        return false;
    }

    public boolean isSelectionAllowed(Widget arg0, Point arg1, boolean arg2) {
        return true;
    }

    public void select(Widget relatedWidget, Point localLocation, boolean arg2) {
        this.scene.validate();
        this.scene.setFocusedWidget(relatedWidget);
        if (this.keyAction != null) {
            Collection nodeList = this.scene.getNodes();
            for (AFONode node : nodeList) {
                node.getWidget().getActions().removeAction(this.keyAction);
            }
            if (relatedWidget != null) {
                relatedWidget.getActions().addAction(this.keyAction);
            }
        }
        if (!this.connectionReset) {
            Collection edgeList = this.scene.getEdges();
            Object[] sortedEdges = edgeList.toArray();
            for (int i = 0; i < sortedEdges.length; ++i) {
                ConnectionWidget conn = (ConnectionWidget)this.scene.findWidget(sortedEdges[i]);
                conn.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
            }
            this.connectionReset = true;
        }
    }

    public void setKeyAction(WidgetAction keyAction) {
        this.keyAction = keyAction;
    }
}

