/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;

class MultiMoveProvider
implements MoveProvider {
    private HashMap<Widget, Point> originals = new HashMap();
    private Point original;
    private AFOGraphPinScene scene;

    public MultiMoveProvider(AFOGraphPinScene scene) {
        this.scene = scene;
    }

    public void movementStarted(Widget widget) {
        Object object = this.scene.findObject(widget);
        if (this.scene.isNode(object)) {
            for (Object o : this.scene.getSelectedObjects()) {
                Widget w;
                if (!this.scene.isNode(o) || (w = this.scene.findWidget(o)) == null) continue;
                this.originals.put(w, w.getPreferredLocation());
            }
        } else {
            this.originals.put(widget, widget.getPreferredLocation());
        }
    }

    public void movementFinished(Widget widget) {
        this.originals.clear();
        this.original = null;
        this.scene.validate();
    }

    public Point getOriginalLocation(Widget widget) {
        this.original = widget.getPreferredLocation();
        return this.original;
    }

    public void setNewLocation(Widget widget, Point location) {
        try {
            int dx = location.x - this.original.x;
            int dy = location.y - this.original.y;
            for (Map.Entry<Widget, Point> entry : this.originals.entrySet()) {
                Point point = entry.getValue();
                entry.getKey().setPreferredLocation(new Point(point.x + dx, point.y + dy));
            }
        }
        catch (Exception ex) {
            System.out.println("Eccezione in MultiMoveProvider: \r\n");
            ex.printStackTrace();
        }
    }
}

