/*
 * Decompiled with CFR 0.152.
 */
package VisiProg;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import nodes.Project;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class AddressDialog
extends JDialog {
    private AppOptions options = new AppOptions();
    public Project project;
    Locale currentLocale;
    ResourceBundle message;
    public String separator;
    private static String virgola = ",";
    public JLabel addressLabel;
    public JButton btnCancel;
    public JButton btnOk;
    public JCheckBox cbMovicon;
    private JCheckBox chkViewFile;
    private JComboBox comboEn;
    private JComboBox comboIt;
    private JLabel separLabel;

    public AddressDialog(Frame parent, boolean modal, Project prj) {
        super(parent, modal);
        this.initComponents();
        this.center();
        this.project = prj;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.addressLabel.setText(this.message.getString("labeladdresscrea"));
        this.separLabel.setText(this.message.getString("separatore"));
        if (this.options.language.equals("en")) {
            this.comboEn.setVisible(true);
            this.comboIt.setVisible(false);
        } else {
            this.comboEn.setVisible(false);
            this.comboIt.setVisible(true);
        }
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private void initComponents() {
        this.addressLabel = new JLabel();
        this.comboEn = new JComboBox();
        this.separLabel = new JLabel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.comboIt = new JComboBox();
        this.cbMovicon = new JCheckBox();
        this.chkViewFile = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(AddressDialog.class);
        this.addressLabel.setFont(resourceMap.getFont("addressLabel.font"));
        this.addressLabel.setText(resourceMap.getString("addressLabel.text", new Object[0]));
        this.addressLabel.setName("addressLabel");
        this.comboEn.setFont(resourceMap.getFont("comboEn.font"));
        this.comboEn.setModel(new DefaultComboBoxModel<String>(new String[]{"semicolon", "comma"}));
        this.comboEn.setMaximumSize(new Dimension(200, 200));
        this.comboEn.setMinimumSize(new Dimension(100, 100));
        this.comboEn.setName("comboEn");
        this.comboEn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressDialog.this.comboEnActionPerformed(evt);
            }
        });
        this.separLabel.setFont(resourceMap.getFont("separLabel.font"));
        this.separLabel.setText(resourceMap.getString("separLabel.text", new Object[0]));
        this.separLabel.setName("separLabel");
        this.btnOk.setIcon(resourceMap.getIcon("btnOk.icon"));
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setIcon(resourceMap.getIcon("btnCancel.icon"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.comboIt.setFont(resourceMap.getFont("comboIt.font"));
        this.comboIt.setModel(new DefaultComboBoxModel<String>(new String[]{"punto e virgola", "virgola"}));
        this.comboIt.setMaximumSize(new Dimension(200, 200));
        this.comboIt.setMinimumSize(new Dimension(100, 100));
        this.comboIt.setName("comboIt");
        this.comboIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressDialog.this.comboItActionPerformed(evt);
            }
        });
        this.cbMovicon.setFont(resourceMap.getFont("cbMovicon.font"));
        this.cbMovicon.setText(resourceMap.getString("cbMovicon.text", new Object[0]));
        this.cbMovicon.setName("cbMovicon");
        this.cbMovicon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressDialog.this.cbMoviconActionPerformed(evt);
            }
        });
        this.chkViewFile.setText(resourceMap.getString("chkViewFile.text", new Object[0]));
        this.chkViewFile.setName("chkViewFile");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(106, Short.MAX_VALUE).addComponent(this.btnOk).addGap(26, 26, 26).addComponent(this.btnCancel).addGap(52, 52, 52)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.addressLabel).addContainerGap(191, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.chkViewFile).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbMovicon).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.separLabel).addGap(58, 58, 58).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboEn, 0, 107, Short.MAX_VALUE).addComponent(this.comboIt, 0, -1, Short.MAX_VALUE)).addGap(77, 77, 77))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addressLabel, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbMovicon).addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboEn, -2, -1, -2).addComponent(this.separLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboIt, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addComponent(this.chkViewFile).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addGap(32, 32, 32)));
        this.pack();
    }

    private void comboEnActionPerformed(ActionEvent evt) {
        if (this.comboEn.getSelectedItem().equals("semicolon")) {
            this.options.setSeparator(";");
            this.options.SaveOptions();
        } else {
            this.options.setSeparator(",");
            this.options.SaveOptions();
        }
    }

    private void comboItActionPerformed(ActionEvent evt) {
        if (this.comboIt.getSelectedItem().equals("punto e virgola")) {
            this.options.setSeparator(";");
            this.options.SaveOptions();
        } else {
            this.options.setSeparator(",");
            this.options.SaveOptions();
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (!this.cbMovicon.isSelected()) {
            this.project.createAddressFile(this.chkViewFile.isSelected());
            this.setVisible(false);
        } else {
            this.project.createMoviconFile(this.chkViewFile.isSelected());
            this.setVisible(false);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void cbMoviconActionPerformed(ActionEvent evt) {
        if (this.cbMovicon.isSelected()) {
            this.comboEn.setEnabled(false);
            this.comboIt.setEnabled(false);
        } else {
            this.comboEn.setEnabled(true);
            this.comboIt.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddressDialog dialog = new AddressDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

