/*
 * Decompiled with CFR 0.152.
 */
package VisiProg;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nodes.BoardsTypesAndDescription;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class NewProjectDialog
extends JDialog {
    private AppOptions options = new AppOptions();
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    private int returnStatus = 0;
    JFileChooser chooser;
    Locale currentLocale;
    ResourceBundle messages;
    public JButton btnBrowse;
    public JButton btnCancel;
    public JButton btnOk;
    public JComboBox comboBoard;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;
    public JLabel lblWarning;
    public JTextArea txtBoardDescription;
    public JTextField txtProjectLocation;
    public JTextField txtProjectName;
    public JTextField txtProjectPath;

    public NewProjectDialog(Frame parent, boolean modal, String lastOpenDir) {
        super(parent, modal);
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.messages = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.setTitle(this.messages.getString("titolonuovofile"));
        this.initComponents();
        this.center();
        this.comboBoard.removeAllItems();
        for (BoardsTypesAndDescription.BoardType board : BoardsTypesAndDescription.BoardType.values()) {
            this.comboBoard.addItem(board.toString());
        }
        this.comboBoard.setSelectedIndex(2);
        this.comboBoardActionPerformed(null);
        this.setResizable(false);
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File(lastOpenDir));
        this.lblWarning.setVisible(false);
        this.lblWarning.setFont(new Font("SansSerif", 1, 14));
        this.jLabel1.setText(this.messages.getString("nomeprogetto"));
        this.jLabel2.setText(this.messages.getString("locazione"));
        this.jLabel3.setText(this.messages.getString("path"));
        this.jLabel5.setText(this.messages.getString("boardtype"));
        this.txtProjectLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewProjectDialog.this.testProjectPath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewProjectDialog.this.testProjectPath();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewProjectDialog.this.testProjectPath();
            }
        });
        this.txtProjectName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewProjectDialog.this.testProjectPath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewProjectDialog.this.testProjectPath();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewProjectDialog.this.testProjectPath();
            }
        });
        this.testProjectPath();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtProjectName = new JTextField();
        this.txtProjectLocation = new JTextField();
        this.btnBrowse = new JButton();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblWarning = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtProjectPath = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.comboBoard = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.txtBoardDescription = new JTextArea();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(NewProjectDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jPanel1.setName("jPanel1");
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.txtProjectName.setColumns(12);
        this.txtProjectName.setFont(resourceMap.getFont("txtProjectPath.font"));
        this.txtProjectName.setHorizontalAlignment(11);
        this.txtProjectName.setText(resourceMap.getString("txtProjectName.text", new Object[0]));
        this.txtProjectName.setName("txtProjectName");
        this.txtProjectLocation.setFont(resourceMap.getFont("txtProjectPath.font"));
        this.txtProjectLocation.setHorizontalAlignment(11);
        this.txtProjectLocation.setText(resourceMap.getString("txtProjectLocation.text", new Object[0]));
        this.txtProjectLocation.setName("txtProjectLocation");
        this.btnBrowse.setFont(resourceMap.getFont("btnBrowse.font"));
        this.btnBrowse.setText(resourceMap.getString("btnBrowse.text", new Object[0]));
        this.btnBrowse.setName("btnBrowse");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.btnBrowseActionPerformed(evt);
            }
        });
        this.btnOk.setFont(resourceMap.getFont("btnBrowse.font"));
        this.btnOk.setIcon(resourceMap.getIcon("btnOk.icon"));
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setFont(resourceMap.getFont("btnBrowse.font"));
        this.btnCancel.setIcon(resourceMap.getIcon("btnCancel.icon"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jSeparator1.setName("jSeparator1");
        this.lblWarning.setFont(resourceMap.getFont("lblWarning.font"));
        this.lblWarning.setForeground(resourceMap.getColor("lblWarning.foreground"));
        this.lblWarning.setText(resourceMap.getString("lblWarning.text", new Object[0]));
        this.lblWarning.setName("lblWarning");
        this.jLabel3.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.txtProjectPath.setEditable(false);
        this.txtProjectPath.setFont(resourceMap.getFont("txtProjectPath.font"));
        this.txtProjectPath.setHorizontalAlignment(11);
        this.txtProjectPath.setText(resourceMap.getString("txtProjectPath.text", new Object[0]));
        this.txtProjectPath.setName("txtProjectPath");
        this.jPanel2.setName("jPanel2");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.comboBoard.setModel(new DefaultComboBoxModel<String>(new String[]{"mPID9 MX", "mPID9 ST", "mPID6 MX", "mPID6 MX"}));
        this.comboBoard.setName("comboBoard");
        this.comboBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.comboBoardActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoard, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboBoard, -2, -1, -2)).addContainerGap(51, Short.MAX_VALUE)));
        this.jScrollPane1.setName("jScrollPane1");
        this.txtBoardDescription.setBackground(resourceMap.getColor("txtBoardDescription.background"));
        this.txtBoardDescription.setColumns(20);
        this.txtBoardDescription.setEditable(false);
        this.txtBoardDescription.setFont(resourceMap.getFont("txtBoardDescription.font"));
        this.txtBoardDescription.setRows(5);
        this.txtBoardDescription.setName("txtBoardDescription");
        this.jScrollPane1.setViewportView(this.txtBoardDescription);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 269, -2))).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtProjectName, -1, 325, Short.MAX_VALUE).addComponent(this.txtProjectLocation, GroupLayout.Alignment.LEADING, -1, 325, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 366, -2).addComponent(this.btnBrowse)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtProjectPath, -1, 348, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(61, 61, 61).addComponent(this.lblWarning)).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 431, Short.MAX_VALUE)).addContainerGap())));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(185, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 82, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtProjectName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtProjectLocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowse).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtProjectPath, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lblWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addContainerGap(128, Short.MAX_VALUE))));
        this.jLabel4.setIcon(resourceMap.getIcon("jLabel4.icon"));
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, -2, 315, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.returnStatus = 1;
        if (this.comboBoard.getSelectedIndex() == 0 || this.comboBoard.getSelectedIndex() == 1) {
            return;
        }
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        this.chooser.setDialogTitle("Choose Directory");
        UIManager.put("FileChooser.openButtonText", this.messages.getString("openbutton"));
        UIManager.put("FileChooser.cancelButtonText", this.messages.getString("cancelbutton"));
        UIManager.put("FileChooser.saveButtonText", this.messages.getString("savebutton"));
        UIManager.put("FileChooser.filesOfTypeLabelText", this.messages.getString("tipobutton"));
        UIManager.put("FileChooser.fileNameLabelText", this.messages.getString("nomefilebutton"));
        UIManager.put("FileChooser.lookInLabelText", this.messages.getString("guardainbutton"));
        UIManager.put("FileChooser.cancelButtonToolTipText", this.messages.getString("cancelbuttontooltip"));
        SwingUtilities.updateComponentTreeUI(this.chooser);
        this.chooser.setFileSelectionMode(1);
        this.chooser.setAcceptAllFileFilterUsed(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            this.txtProjectLocation.setText(this.chooser.getSelectedFile().toString());
            this.validate();
        }
        this.testProjectPath();
    }

    private void comboBoardActionPerformed(ActionEvent evt) {
        this.options.LoadOptions();
        if (this.options.language.equals("en")) {
            try {
                this.txtBoardDescription.setText(BoardsTypesAndDescription.boardDescription_en[this.comboBoard.getSelectedIndex()]);
                this.txtBoardDescription.setCaretPosition(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.options.language.equals("it")) {
            try {
                this.txtBoardDescription.setText(BoardsTypesAndDescription.boardDescription_it[this.comboBoard.getSelectedIndex()]);
                this.txtBoardDescription.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewProjectDialog dialog = new NewProjectDialog((Frame)new JFrame(), true, "./");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void testProjectPath() {
        String path = this.txtProjectLocation.getText();
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        path = path + this.txtProjectName.getText();
        this.txtProjectPath.setText(path);
        File projDir = new File(this.txtProjectPath.getText());
        if (projDir.exists()) {
            if (projDir.listFiles().length > 0) {
                this.lblWarning.setVisible(true);
                this.btnOk.setEnabled(false);
            } else {
                this.lblWarning.setVisible(false);
                this.btnOk.setEnabled(true);
            }
        } else {
            this.lblWarning.setVisible(false);
            this.btnOk.setEnabled(true);
        }
    }
}

