/*
 * Decompiled with CFR 0.152.
 */
package connection;

import VisiProg.AppOptions;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.gui.TerminalDialog;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import nodes.AFOSystemManager;
import nodes.Project;
import nodes.devices.CommentNode;
import nodes.devices.GenericNode;
import nodes.devices.ScopeNode;
import org.openide.util.Exceptions;
import sceneManager.AFONode;

public class ProgramDownloader
extends Thread
implements IKernelEventListener {
    public boolean retVal = true;
    IKernel kernel;
    TerminalDialog terminal;
    Locale currentLocale;
    ResourceBundle messages;
    int progress = 0;
    int nOfBlocks = 0;
    ArrayList<AFONode> nodeList;
    boolean stop = false;
    boolean waiting = false;
    boolean nextMessage = false;
    protected EventListenerList listenerList = new EventListenerList();
    private AppOptions options = new AppOptions();
    private Project prj;
    int blockIndex = 0;
    int addressIndex = -1;

    public ProgramDownloader(Project project, IKernel ker) {
        this.kernel = ker;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.messages = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.kernel.addKernelEventListener(this);
        this.prj = project;
    }

    public void addKernelEventListener(IKernelEventListener listener) {
        this.listenerList.add(IKernelEventListener.class, listener);
    }

    public void removeKernelEventListener(IKernelEventListener listener) {
        this.listenerList.remove(IKernelEventListener.class, listener);
    }

    void fireEvent(KernelEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IKernelEventListener.class) continue;
            ((IKernelEventListener)listeners[i + 1]).kernelEventOccurred(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block27: {
            String command = null;
            this.fireEvent(new KernelEvent(this, "Download started"));
            this.kernel.collectPlantData(false);
            this.nodeList = this.prj.getNodeList();
            this.nOfBlocks = this.nodeList.size();
            command = this.getNextRequest();
            while (!this.stop) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!this.waiting) {
                    if (!this.kernel.sendCommand(command)) break;
                    float prog = (float)this.progress / (float)this.nOfBlocks;
                    this.fireEvent(new KernelEvent(this, "Upload Progress", (int)(prog * 100.0f)));
                    this.waiting = true;
                }
                if (!this.nextMessage) continue;
                command = this.getNextRequest();
                this.nextMessage = false;
                if (command != null) continue;
                this.stop = true;
            }
            this.kernel.removeKernelEventListener(this);
            Object[] options = new Object[]{"OK"};
            try {
                if (this.retVal) {
                    if (JOptionPane.showOptionDialog(null, this.messages.getString("download_success"), this.messages.getString("er"), 0, 2, null, options, options[0]) == 0) {
                        this.fireEvent(new KernelEvent(this, "Download Terminated"));
                        this.kernel.collectPlantData(true);
                    }
                } else if (JOptionPane.showOptionDialog(null, this.messages.getString("download_error"), this.messages.getString("er"), 0, 2, null, options, options[0]) == 0) {
                    this.kernel.collectPlantData(false);
                }
                break block27;
            }
            catch (Exception ex) {
                if (JOptionPane.showOptionDialog(null, this.messages.getString("download_error"), this.messages.getString("er"), 0, 2, null, options, options[0]) == 0) {
                    Logger.getLogger(ProgramDownloader.class.getName()).log(Level.SEVERE, null, ex);
                }
                break block27;
            }
            catch (Exception ex) {
                block28: {
                    try {
                        Logger.getLogger(ProgramDownloader.class.getName()).log(Level.SEVERE, null, ex);
                        this.retVal = false;
                        this.kernel.removeKernelEventListener(this);
                    }
                    catch (Throwable throwable) {
                        block29: {
                            this.kernel.removeKernelEventListener(this);
                            Object[] options2 = new Object[]{"OK"};
                            try {
                                if (this.retVal) {
                                    if (JOptionPane.showOptionDialog(null, this.messages.getString("download_success"), this.messages.getString("er"), 0, 2, null, options2, options2[0]) == 0) {
                                        this.fireEvent(new KernelEvent(this, "Download Terminated"));
                                        this.kernel.collectPlantData(true);
                                    }
                                } else if (JOptionPane.showOptionDialog(null, this.messages.getString("download_error"), this.messages.getString("er"), 0, 2, null, options2, options2[0]) == 0) {
                                    this.kernel.collectPlantData(false);
                                }
                            }
                            catch (Exception ex2) {
                                if (JOptionPane.showOptionDialog(null, this.messages.getString("download_error"), this.messages.getString("er"), 0, 2, null, options2, options2[0]) != 0) break block29;
                                Logger.getLogger(ProgramDownloader.class.getName()).log(Level.SEVERE, null, ex2);
                            }
                        }
                        throw throwable;
                    }
                    Object[] options3 = new Object[]{"OK"};
                    try {
                        if (this.retVal) {
                            if (JOptionPane.showOptionDialog(null, this.messages.getString("download_success"), this.messages.getString("er"), 0, 2, null, options3, options3[0]) == 0) {
                                this.fireEvent(new KernelEvent(this, "Download Terminated"));
                                this.kernel.collectPlantData(true);
                            }
                        } else if (JOptionPane.showOptionDialog(null, this.messages.getString("download_error"), this.messages.getString("er"), 0, 2, null, options3, options3[0]) == 0) {
                            this.kernel.collectPlantData(false);
                        }
                    }
                    catch (Exception ex3) {
                        if (JOptionPane.showOptionDialog(null, this.messages.getString("download_error"), this.messages.getString("er"), 0, 2, null, options3, options3[0]) != 0) break block28;
                        Logger.getLogger(ProgramDownloader.class.getName()).log(Level.SEVERE, null, ex3);
                    }
                }
                return;
            }
        }
    }

    String getNextRequest() {
        AFONode currentNode = null;
        while (this.blockIndex < this.nodeList.size()) {
            currentNode = this.nodeList.get(this.blockIndex);
            int nodeSpace = currentNode.getAddressSpace();
            ++this.addressIndex;
            if (this.addressIndex >= nodeSpace) {
                this.addressIndex = -1;
                ++this.blockIndex;
                continue;
            }
            while (currentNode instanceof CommentNode || currentNode instanceof AFOSystemManager || currentNode instanceof ScopeNode || !(currentNode instanceof GenericNode)) {
                ++this.blockIndex;
            }
            break block0;
        }
        if (this.blockIndex == this.nodeList.size() || currentNode == null) {
            return null;
        }
        Integer address = ((GenericNode)currentNode).getAddressList().get(0) + this.addressIndex;
        return "<BL get " + address.toString() + ">";
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Valid Reply Received")) {
            this.nextMessage = true;
            this.waiting = false;
            ++this.progress;
        } else if (evt.getEventType().equals("Command Not Executed")) {
            Object[] myOptions = new Object[]{this.messages.getString("ok")};
            if (JOptionPane.showOptionDialog(null, this.messages.getString("errtrasf"), this.messages.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 0) {
                this.retVal = false;
                this.stop = true;
            }
        } else if (evt.getEventType().equals("Timeout on command")) {
            Object[] myOptions = new Object[]{this.messages.getString("ok")};
            if (JOptionPane.showOptionDialog(null, this.messages.getString("erroretimeout"), this.messages.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 0) {
                this.retVal = false;
                this.stop = true;
            }
        }
    }
}

