/*
 * Decompiled with CFR 0.152.
 */
package connection;

import VisiProg.AppOptions;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.gui.TerminalDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.openide.util.Exceptions;

public class ProgramUploader
extends Thread
implements IKernelEventListener {
    public String filePath = "";
    public boolean retVal = true;
    IKernel kernel;
    TerminalDialog terminal;
    Locale currentLocale;
    ResourceBundle messages;
    int progress = 0;
    int nOfLines = 0;
    boolean stop = false;
    boolean waiting = false;
    boolean nextMessage = false;
    protected EventListenerList listenerList = new EventListenerList();
    private AppOptions options = new AppOptions();

    public ProgramUploader(String file, IKernel ker) {
        this.filePath = file;
        this.kernel = ker;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.messages = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.kernel.addKernelEventListener(this);
    }

    public void addKernelEventListener(IKernelEventListener listener) {
        this.listenerList.add(IKernelEventListener.class, listener);
    }

    public void removeKernelEventListener(IKernelEventListener listener) {
        this.listenerList.remove(IKernelEventListener.class, listener);
    }

    void fireEvent(KernelEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IKernelEventListener.class) continue;
            ((IKernelEventListener)listeners[i + 1]).kernelEventOccurred(evt);
        }
    }

    private int countLines(File file) {
        try {
            FileInputStream fi = new FileInputStream(file);
            InputStreamReader inRd = new InputStreamReader(fi);
            LineNumberReader lRdr = new LineNumberReader(inRd);
            int count = 0;
            while (lRdr.readLine() != null) {
                ++count;
            }
            return count;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block27: {
            FileInputStream fi = null;
            String command = null;
            this.fireEvent(new KernelEvent(this, "Upload started"));
            File f = new File(this.filePath);
            fi = new FileInputStream(f);
            InputStreamReader inRd = new InputStreamReader(fi);
            BufferedReader bRd = new BufferedReader(inRd);
            this.nOfLines = this.countLines(f);
            this.kernel.collectPlantData(false);
            command = bRd.readLine();
            while (command != null && !this.stop) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!this.waiting) {
                    if (!this.kernel.sendCommand(command)) break;
                    float prog = (float)this.progress / (float)this.nOfLines;
                    this.fireEvent(new KernelEvent(this, "Upload Progress", (int)(prog * 100.0f)));
                    this.waiting = true;
                }
                if (!this.nextMessage) continue;
                command = bRd.readLine();
                this.nextMessage = false;
            }
            this.kernel.removeKernelEventListener(this);
            Object[] options = new Object[]{"OK"};
            try {
                if (this.retVal) {
                    if (JOptionPane.showOptionDialog(null, this.messages.getString("upload"), this.messages.getString("er"), 0, 2, null, options, options[0]) == 0) {
                        this.fireEvent(new KernelEvent(this, "Upload Terminated"));
                        this.kernel.collectPlantData(true);
                    }
                } else if (JOptionPane.showOptionDialog(null, this.messages.getString("erroreinviofile"), this.messages.getString("er"), 0, 2, null, options, options[0]) == 0) {
                    this.kernel.collectPlantData(false);
                }
                fi.close();
            }
            catch (IOException ex) {
                if (JOptionPane.showOptionDialog(null, this.messages.getString("errorechiusfile"), this.messages.getString("er"), 0, 2, null, options, options[0]) == 0) {
                    ex.printStackTrace();
                }
                break block27;
            }
            catch (IOException ex) {
                block28: {
                    try {
                        ex.printStackTrace();
                        this.retVal = false;
                        this.kernel.removeKernelEventListener(this);
                    }
                    catch (Throwable throwable) {
                        block29: {
                            this.kernel.removeKernelEventListener(this);
                            Object[] options2 = new Object[]{"OK"};
                            try {
                                if (this.retVal) {
                                    if (JOptionPane.showOptionDialog(null, this.messages.getString("upload"), this.messages.getString("er"), 0, 2, null, options2, options2[0]) == 0) {
                                        this.fireEvent(new KernelEvent(this, "Upload Terminated"));
                                        this.kernel.collectPlantData(true);
                                    }
                                } else if (JOptionPane.showOptionDialog(null, this.messages.getString("erroreinviofile"), this.messages.getString("er"), 0, 2, null, options2, options2[0]) == 0) {
                                    this.kernel.collectPlantData(false);
                                }
                                fi.close();
                            }
                            catch (IOException ex2) {
                                if (JOptionPane.showOptionDialog(null, this.messages.getString("errorechiusfile"), this.messages.getString("er"), 0, 2, null, options2, options2[0]) != 0) break block29;
                                ex2.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    Object[] options3 = new Object[]{"OK"};
                    try {
                        if (this.retVal) {
                            if (JOptionPane.showOptionDialog(null, this.messages.getString("upload"), this.messages.getString("er"), 0, 2, null, options3, options3[0]) == 0) {
                                this.fireEvent(new KernelEvent(this, "Upload Terminated"));
                                this.kernel.collectPlantData(true);
                            }
                        } else if (JOptionPane.showOptionDialog(null, this.messages.getString("erroreinviofile"), this.messages.getString("er"), 0, 2, null, options3, options3[0]) == 0) {
                            this.kernel.collectPlantData(false);
                        }
                        fi.close();
                    }
                    catch (IOException ex3) {
                        if (JOptionPane.showOptionDialog(null, this.messages.getString("errorechiusfile"), this.messages.getString("er"), 0, 2, null, options3, options3[0]) != 0) break block28;
                        ex3.printStackTrace();
                    }
                }
                return;
            }
        }
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Command Executed")) {
            this.nextMessage = true;
            this.waiting = false;
            ++this.progress;
        } else if (evt.getEventType().equals("Command Not Executed")) {
            Object[] myOptions = new Object[]{this.messages.getString("ok")};
            if (JOptionPane.showOptionDialog(null, this.messages.getString("errtrasf"), this.messages.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 0) {
                this.retVal = false;
                this.stop = true;
            }
        } else if (evt.getEventType().equals("Timeout on command")) {
            Object[] myOptions = new Object[]{this.messages.getString("ok")};
            if (JOptionPane.showOptionDialog(null, this.messages.getString("erroretimeout"), this.messages.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 0) {
                this.retVal = false;
                this.stop = true;
            }
        }
    }
}

