/*
 * Decompiled with CFR 0.152.
 */
package connection;

import VisiProg.AppOptions;
import connection.CommandQueue;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.XMLCommands.Cmd;
import connection.gui.ConnectDialog;
import connection.gui.ErrorDialog;
import connection.gui.InfoDialog;
import connection.gui.TerminalDialog;
import connection.testProtocol.TestCmd;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import nodes.AFOSystemManager;
import nodes.AfoDBDao;
import nodes.Project;
import nodes.devices.AfoTimer;
import nodes.devices.GenericNode;
import org.openide.util.Exceptions;
import sceneManager.AFONode;

public class SerialKernel
extends Thread
implements IKernel {
    private boolean connect = false;
    Locale currentLocale;
    ResourceBundle messages;
    private AppOptions options = new AppOptions();
    boolean connectSilently = false;
    private boolean isKernelSerial = true;
    SerialPort serialPort;
    private DataInputStream in;
    private DataOutputStream out;
    private boolean connected;
    public AfoDBDao afoDatabase;
    private Project proj;
    private ErrorDialog dlgError;
    private TerminalDialog console;
    private boolean stopRunning = false;
    private volatile ArrayList<String> inMsgList;
    private CommandQueue outMsgList;
    private int MAX_IN_MSGLIST_SIZE = 100;
    private volatile boolean threadStopped = true;
    private ArrayList<Character> inDataArray;
    boolean waitingForAnswer = false;
    MessageTimeout msgTO;
    private String host;
    private int port;
    private Socket cs;
    private static final char START_CHAR = '<';
    private static final char STOP_CHAR = '\n';
    public boolean isEthernet = true;
    public static int MAX_DRIVER_ADDRESS = 999;
    InfoDialog infoDlg;
    protected EventListenerList listenerList = new EventListenerList();
    private static int MSG_TIMEOUT_MS = 5000;
    private static int SAVE_TIMEOUT_MS = 15000;
    private int lastBlockDataRetrieved = 0;
    private ArrayList<Integer> blockAddressList = new ArrayList();
    private volatile boolean collectPlantData = true;
    private boolean mobBoard = false;
    private String firmwareVersionString = "1.0.0";
    private Double firmwareVersionDouble = 10.0;

    public SerialKernel(Project p, AfoDBDao db) throws Exception {
        this.afoDatabase = db;
        this.proj = p;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.messages = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.connected = false;
        this.dlgError = new ErrorDialog(null, false);
        this.console = new TerminalDialog(null, false, p, this);
        this.console.setKernel(this);
        this.inDataArray = new ArrayList();
        this.inMsgList = new ArrayList();
        this.outMsgList = new CommandQueue();
        this.start();
    }

    @Override
    public void collectPlantData(boolean run) {
        this.collectPlantData = run;
        if (run) {
            this.fireEvent(new KernelEvent(this, "Data Retriever Running"));
        } else {
            this.inMsgList.clear();
            this.fireEvent(new KernelEvent(this, "Data Retriever Stopped"));
        }
    }

    @Override
    public void addKernelEventListener(IKernelEventListener listener) {
        this.listenerList.add(IKernelEventListener.class, listener);
    }

    @Override
    public void removeKernelEventListener(IKernelEventListener listener) {
        this.listenerList.remove(IKernelEventListener.class, listener);
    }

    public void removeAllKernelEventListener() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IKernelEventListener.class) continue;
            this.listenerList.remove(IKernelEventListener.class, (IKernelEventListener)listeners[i]);
        }
    }

    void fireEvent(KernelEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IKernelEventListener.class) continue;
            ((IKernelEventListener)listeners[i + 1]).kernelEventOccurred(evt);
        }
    }

    private boolean connectSerial() {
        try {
            String portName = this.proj.getMyDialog().comboPort.getSelectedItem().toString();
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
            if (portIdentifier.isCurrentlyOwned()) {
                this.dlgError.addError(this.messages.getString("errorport") + portName + this.messages.getString("inuso"));
                this.dlgError.setVisible(true);
                return false;
            }
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (!(commPort instanceof SerialPort)) {
                throw new Exception(this.messages.getString("errorserial"));
            }
            int portSpeed = Integer.parseInt(this.proj.getMyDialog().comboPortSpeed.getSelectedItem().toString());
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(portSpeed, 8, 1, 0);
            SerialPortEventListener dummy = new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent x) {
                }
            };
            this.serialPort.addEventListener(dummy);
            this.in = new DataInputStream(this.serialPort.getInputStream());
            this.out = new DataOutputStream(this.serialPort.getOutputStream());
            this.isKernelSerial = true;
        }
        catch (Exception ex) {
            this.dlgError.addError(ex.toString());
            this.dlgError.setVisible(true);
            return false;
        }
        return true;
    }

    private boolean connectEthernet() {
        try {
            this.host = this.proj.getMyDialog().txtIPAddress.getText();
            this.port = Integer.parseInt(this.proj.getMyDialog().txtIPPort.getText());
            if (this.host == null || this.port == 0) {
                throw new Exception(this.messages.getString("errorparam"));
            }
            this.cs = new Socket(this.host, this.port);
            this.console.addMsg(this.messages.getString("connok"), TerminalDialog.ALLMSG);
            this.in = new DataInputStream(this.cs.getInputStream());
            this.out = new DataOutputStream(this.cs.getOutputStream());
            this.console.addMsg(this.messages.getString("attenfinal"), TerminalDialog.ALLMSG);
            this.isKernelSerial = false;
        }
        catch (Exception exception) {
            this.dlgError.addError(exception.getMessage());
            this.dlgError.setVisible(true);
            return false;
        }
        return true;
    }

    @Override
    public void connect() {
        this.connect = true;
    }

    public void connectAndStop(boolean silentConnect) {
        this.collectPlantData = false;
        this.connect = true;
        this.connectSilently = silentConnect;
    }

    private void initAllNodes() {
        for (AFOSystemManager sm : this.proj.getSubSystemList()) {
            for (AFONode node : sm.getNodeList()) {
                ((GenericNode)node).setKernel(this);
            }
        }
        for (AFONode node : this.proj.getMainSystem().getNodeList()) {
            ((GenericNode)node).setKernel(this);
        }
    }

    private void initAllTimers() {
        for (AfoTimer tmr : this.proj.getTimerList()) {
            tmr.setKernel(this);
        }
    }

    @Override
    public void disconnect() {
        this.stopRunning = true;
        try {
            this.join(1000L);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setDisconnectStatus();
    }

    private void setDisconnectStatus() {
        this.collectPlantData = false;
        this.closeCOM();
        this.connected = false;
        this.dlgError.setVisible(false);
        this.console.setVisible(false);
        this.fireEvent(new KernelEvent(this, "Kernel Disconnected"));
    }

    public void closeCOM() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.serialPort != null) {
                this.serialPort.removeEventListener();
                this.serialPort.close();
            } else if (this.cs != null) {
                this.cs.close();
            }
            this.console.addMsg(this.messages.getString("connko"), TerminalDialog.ALLMSG);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static short CalcCrc(short crc, char[] msg, int msgLen) {
        for (int i = 0; i < msgLen; ++i) {
            crc = (short)(crc + msg[i]);
        }
        return crc;
    }

    private String encapsulateMessage(String message) {
        short crc = 1;
        String newCommand = message.substring(0, 1);
        newCommand = newCommand + String.format("%1$03d", Integer.parseInt(this.proj.getBoardAddress())) + " ";
        newCommand = newCommand + message.substring(1);
        crc = SerialKernel.CalcCrc(crc, newCommand.substring(1).toCharArray(), newCommand.substring(1).length() - 1);
        int index = newCommand.indexOf(62);
        newCommand = index == -1 ? newCommand + " >" : newCommand.substring(0, index + 1);
        newCommand = newCommand + String.format("%1$05d", crc);
        newCommand = newCommand + "\r\n";
        return newCommand;
    }

    @Override
    public boolean sendCommand(String command) {
        boolean crc = true;
        String newCommand = this.encapsulateMessage(command);
        if (!this.outMsgList.pushMessage(newCommand)) {
            Object[] myOptions = new Object[]{this.messages.getString("yes")};
            JOptionPane.showOptionDialog(null, this.messages.getString("sendcommand"), this.messages.getString("er"), 0, 0, null, myOptions, myOptions[0]);
            return false;
        }
        return true;
    }

    public String getHashCommand() {
        String newHash = "<BL set 0 " + this.proj.getHash() + " >";
        return newHash;
    }

    @Override
    public synchronized void run() {
        super.run();
        this.threadStopped = false;
        boolean lastConn = this.connected;
        while (!this.stopRunning()) {
            try {
                SerialKernel.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.isConnected()) {
                try {
                    if (lastConn != this.connected) {
                        lastConn = this.connected;
                        this.fireEvent(new KernelEvent(this, "Kernel Connected", 0, ""));
                    }
                    boolean dataRead = false;
                    while (this.in.available() > 0) {
                        char car = (char)this.in.read();
                        this.inDataArray.add(Character.valueOf(car));
                        dataRead = true;
                    }
                    if (dataRead) {
                        this.parseInDataArray();
                        if (this.inMsgList.size() > 0) {
                            this.waitingForAnswer = false;
                            this.parseMessages();
                        }
                    } else if (this.waitingForAnswer && this.msgTO != null && this.msgTO.timeOutExpired) {
                        this.waitingForAnswer = false;
                        String err = "-------- TIMEOUT On Message -----------";
                        System.out.println(err);
                        this.dlgError.addError(err);
                        this.fireEvent(new KernelEvent(this, "Timeout on command"));
                    }
                    if (this.outMsgList.size() > 0) {
                        if (this.waitingForAnswer) continue;
                        String command = this.outMsgList.popMessage();
                        this.inMsgList.clear();
                        this.writeOutMessage(command);
                        continue;
                    }
                    if (this.waitingForAnswer) continue;
                    this.getPlantData();
                    continue;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, this.messages.getString("connko") + e.getMessage(), this.messages.getString("err4"), 0);
                    this.connected = false;
                    this.stopRunning = true;
                    break;
                }
            }
            if (!this.connect) continue;
            this.createBlockAddressList();
            KernelConnecter conn = new KernelConnecter(this);
            if (!this.connectSilently) {
                ConnectDialog dlg = new ConnectDialog(null, false);
                this.addKernelEventListener(dlg);
                dlg.setVisible(true);
            }
            conn.start();
            this.connect = false;
        }
        this.threadStopped = true;
        System.out.println("Thread Uscito!!");
        this.setDisconnectStatus();
    }

    private void parseMessages() {
        block14: while (!this.inMsgList.isEmpty()) {
            int i;
            String msg = this.popInMsg();
            TestCmd cmd = new TestCmd("");
            cmd.parseCmd(msg);
            if (cmd.getValue("MESSAGE_TYPE").equals("ERROR")) {
                String error = "";
                for (i = 2; i <= cmd.getNofTokens(); ++i) {
                    error = error + cmd.getValue("TOKEN" + i) + " ";
                }
                this.dlgError.addError(error);
                this.dlgError.setVisible(true);
                this.fireEvent(new KernelEvent(this, "Command Not Executed"));
            } else if (cmd.getValue("MESSAGE_TYPE").equals("OK")) {
                this.fireEvent(new KernelEvent(this, "Command Executed"));
            } else {
                this.fireEvent(new KernelEvent(this, "Valid Reply Received"));
            }
            if (cmd.getValue("MESSAGE_TYPE").equals("RT")) {
                this.console.txtTime.setText(cmd.getValue("TOKEN2"));
                this.console.txtDate.setText(cmd.getValue("TOKEN3"));
                continue;
            }
            if (cmd.getValue("MESSAGE_TYPE").equals("BLK")) {
                if (cmd.getValue("TOKEN2").equals("fw")) {
                    this.console.txtSysinfo.append("Newtohm Freely Programmable Firmware\r\n");
                    this.console.txtSysinfo.append("Version: " + cmd.getValue("TOKEN3") + "\r\n");
                    this.fireEvent(new KernelEvent(this, "Firware Version", 0, cmd.getValue("TOKEN3")));
                    this.firmwareVersionString = cmd.getValue("TOKEN3");
                    String[] toks = this.firmwareVersionString.split("\\.");
                    try {
                        this.firmwareVersionDouble = Double.parseDouble(toks[0]) * 10.0 + Double.parseDouble(toks[1]) + Double.parseDouble(toks[2]) / 10.0;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(SerialKernel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                String info = "";
                for (i = 2; i <= cmd.getNofTokens(); ++i) {
                    info = info + cmd.getValue("TOKEN" + i) + " ";
                }
                info = info + "\r\n";
                this.console.txtSysinfo.append(info);
                continue;
            }
            if (cmd.getValue("MESSAGE_TYPE").equals("PT")) {
                this.console.execCommand(cmd);
                continue;
            }
            if (cmd.getValue("MESSAGE_TYPE").equals("WB")) {
                this.console.execCommand(cmd);
                continue;
            }
            if (!cmd.getValue("MESSAGE_TYPE").equals("BL")) continue;
            if (cmd.getValue("TOKEN2").equals("tmr")) {
                List<AfoTimer> tmrList = this.proj.getTimerList();
                for (AfoTimer tmr : tmrList) {
                    tmr.execCommand(cmd);
                }
                continue;
            }
            int address = -1;
            try {
                address = Integer.parseInt(cmd.getValue("ADDRESS"));
            }
            catch (NumberFormatException nEx) {
                nEx.printStackTrace();
                continue;
            }
            if (address == 0) {
                if (cmd.getValue("TOKEN3").equals("0")) {
                    this.fireEvent(new KernelEvent(this, "Program Stopped"));
                    this.collectPlantData(false);
                    this.console.btnStopDataAcquiring.setText("Run");
                } else if (cmd.getValue("TOKEN3").equals("1")) {
                    this.fireEvent(new KernelEvent(this, "Program Running"));
                    this.collectPlantData(true);
                    this.console.btnStopDataAcquiring.setText("Stop");
                }
                try {
                    int nOfBlocks = Integer.parseInt(cmd.getValue("TOKEN4"));
                    this.console.txtSysinfo.append("System Blocks:" + nOfBlocks + "\r\n");
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                boolean programOK = false;
                int recvProgramHash = 0;
                try {
                    recvProgramHash = Integer.parseInt(cmd.getValue("TOKEN5"));
                    this.console.txtSysinfo.append("Hash:" + recvProgramHash + "\r\n");
                    if (this.proj.getHash() == recvProgramHash) {
                        programOK = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                if (!programOK) {
                    if (JOptionPane.showConfirmDialog(null, this.messages.getString("programmadiverso") + this.messages.getString("hashin") + this.proj.getHash() + this.messages.getString("hashric") + recvProgramHash + this.messages.getString("cont"), this.messages.getString("avv"), 0) == 1) {
                        this.fireEvent(new KernelEvent(this, "Kernel force disconnect"));
                    } else {
                        this.collectPlantData(false);
                        JOptionPane.showMessageDialog(null, this.messages.getString("datastop"), this.messages.getString("avv"), 2);
                        this.fireEvent(new KernelEvent(this, "Command Executed"));
                    }
                }
                try {
                    if (Integer.parseInt(cmd.getValue("TOKEN6")) == 0) continue;
                    this.mobBoard = true;
                }
                catch (Exception ex) {}
                continue;
            }
            boolean messageParsed = false;
            AFOSystemManager mainManager = this.proj.getMainSystem();
            for (int i2 = 0; i2 < mainManager.getNodeList().size(); ++i2) {
                GenericNode node = (GenericNode)mainManager.getNodeList().get(i2);
                try {
                    if (!node.execCommand(cmd)) continue;
                    messageParsed = true;
                    break;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (messageParsed) continue;
            for (AFOSystemManager sm : this.proj.getSubSystemList()) {
                for (AFONode node : sm.getNodeList()) {
                    try {
                        if (!((GenericNode)node).execCommand(cmd)) continue;
                        messageParsed = true;
                        break;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (!messageParsed) continue;
                continue block14;
            }
        }
    }

    @Override
    public synchronized String popInMsg() {
        if (this.inMsgList.size() < 0) {
            return "";
        }
        String retVal = this.inMsgList.get(0);
        this.inMsgList.remove(0);
        return retVal;
    }

    @Override
    public synchronized void pushInMsg(String msg) {
        if (this.inMsgList.size() == this.MAX_IN_MSGLIST_SIZE) {
            this.inMsgList.remove(0);
        }
        this.inMsgList.add(msg);
    }

    private void addErrorToDB(Cmd com) {
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public ErrorDialog getDlgError() {
        return this.dlgError;
    }

    @Override
    public TerminalDialog getTerminalDialog() {
        return this.console;
    }

    private boolean stopRunning() {
        return this.stopRunning;
    }

    private void parseInDataArray() {
        boolean parsingFinished = false;
        while (!parsingFinished) {
            int startIdx;
            int endIdx = 0;
            for (startIdx = 0; startIdx < this.inDataArray.size() && !this.inDataArray.get(startIdx).equals(Character.valueOf('<')); ++startIdx) {
            }
            if (startIdx == this.inDataArray.size()) {
                this.inDataArray.clear();
                parsingFinished = true;
                continue;
            }
            for (endIdx = startIdx; endIdx < this.inDataArray.size() && !this.inDataArray.get(endIdx).equals(Character.valueOf('\n')); ++endIdx) {
            }
            if (endIdx == this.inDataArray.size()) {
                parsingFinished = true;
                break;
            }
            parsingFinished = false;
            StringBuilder sb = new StringBuilder();
            for (int i = startIdx; i <= endIdx; ++i) {
                sb.append(this.inDataArray.get(i));
            }
            this.removeDataFromInput(endIdx);
            this.pushInMsg(sb.toString());
            String msg = sb.toString();
            msg = msg.substring(0, msg.length() - 2);
            this.console.addMsg(msg, TerminalDialog.INMSG);
            this.fireEvent(new KernelEvent(this, "New Message Received", 0, msg));
        }
    }

    private void removeDataFromInput(int index) {
        for (int i = 0; i <= index; ++i) {
            this.inDataArray.remove(0);
        }
    }

    public boolean isKernelSerial() {
        return this.isKernelSerial;
    }

    public void writeOutBinaryMessge(byte[] array, int len) {
        try {
            this.out.write(array, 0, len);
            this.out.flush();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean writeOutMessage(String msg) {
        try {
            this.out.writeBytes(msg);
            this.out.flush();
            this.console.addMsg(msg.substring(0, msg.length() - 2), TerminalDialog.OUTMSG);
            this.waitingForAnswer = true;
            this.msgTO = msg.contains("save") ? new MessageTimeout(SAVE_TIMEOUT_MS) : new MessageTimeout(MSG_TIMEOUT_MS);
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, this.messages.getString("erroreinvio") + e.toString(), this.messages.getString("err3"), 0);
            System.out.println(msg);
            e.printStackTrace();
            this.stopRunning = true;
            return false;
        }
    }

    private void getPlantData() {
        if (!this.collectPlantData || this.outMsgList.size() > 0) {
            return;
        }
        if (this.lastBlockDataRetrieved >= this.blockAddressList.size()) {
            this.lastBlockDataRetrieved = 0;
        }
        String command = "<BL get " + this.blockAddressList.get(this.lastBlockDataRetrieved).toString() + " >";
        ++this.lastBlockDataRetrieved;
        command = this.encapsulateMessage(command);
        this.writeOutMessage(command);
    }

    private void createBlockAddressList() {
        this.blockAddressList = new ArrayList();
        for (AFOSystemManager sm : this.proj.getSubSystemList()) {
            for (AFONode node : sm.getNodeList()) {
                if (((GenericNode)node).getAddressList().size() <= 0) continue;
                Integer integ = ((GenericNode)node).getAddressList().get(0);
                this.blockAddressList.add(integ);
            }
        }
        for (AFONode node : this.proj.getMainSystem().getNodeList()) {
            if (((GenericNode)node).getAddressList().size() <= 0) continue;
            Integer integ = ((GenericNode)node).getAddressList().get(0);
            this.blockAddressList.add(integ);
        }
        this.lastBlockDataRetrieved = 0;
    }

    @Override
    public boolean getCollectStatus() {
        return this.collectPlantData;
    }

    public boolean isMobBoard() {
        return this.mobBoard;
    }

    public String getFirmwareVersionString() {
        return this.firmwareVersionString;
    }

    public Double getFirmwareVersionDouble() {
        return this.firmwareVersionDouble;
    }

    class KernelConnecter
    extends Thread {
        Thread parent;

        public KernelConnecter(Thread parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            try {
                SerialKernel.this.fireEvent(new KernelEvent(this, "Kernel Connecting Progress", 10, "Opening port"));
                if (SerialKernel.this.isEthernet) {
                    if (!SerialKernel.this.connectEthernet()) {
                        SerialKernel.this.fireEvent(new KernelEvent(this, "Connection failed"));
                        return;
                    }
                } else if (!SerialKernel.this.connectSerial()) {
                    SerialKernel.this.fireEvent(new KernelEvent(this, "Connection failed"));
                    return;
                }
                SerialKernel.this.fireEvent(new KernelEvent(this, "Kernel Connecting Progress", 30, "Init nodes"));
                SerialKernel.this.console.addMsg(SerialKernel.this.messages.getString("apertura"), TerminalDialog.ALLMSG);
                SerialKernel.this.console.addMsg(SerialKernel.this.messages.getString("fin"), TerminalDialog.ALLMSG);
                SerialKernel.this.initAllNodes();
                SerialKernel.this.initAllTimers();
                SerialKernel.this.fireEvent(new KernelEvent(this, "Kernel Connecting Progress", 70, "FInalizing"));
                Thread.sleep(1000L);
                SerialKernel.this.console.addMsg(SerialKernel.this.messages.getString("finok"), TerminalDialog.ALLMSG);
                SerialKernel.this.connected = true;
                SerialKernel.this.stopRunning = false;
                SerialKernel.this.threadStopped = false;
            }
            catch (Exception ex) {
                SerialKernel.this.fireEvent(new KernelEvent(this, "Connection failed"));
                System.out.println(ex.toString());
            }
            SerialKernel.this.connect = false;
        }
    }

    class MessageTimeout
    extends Thread {
        private int msWait = 100;
        public int timeoutMs = 0;
        public boolean stop = false;
        public boolean timeOutExpired = false;

        public MessageTimeout(int timeoutMillis) {
            this.timeoutMs = timeoutMillis;
            this.start();
        }

        @Override
        public void run() {
            try {
                while (!this.stop && !this.timeOutExpired) {
                    Thread.sleep(this.msWait);
                    this.timeoutMs -= this.msWait;
                    if (this.timeoutMs >= 0) continue;
                    this.timeOutExpired = true;
                    break;
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

