/*
 * Decompiled with CFR 0.152.
 */
package connection.gui;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.SerialKernel;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import nodes.BoardsTypesAndDescription;
import nodes.Project;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class CalibrationDialog
extends JDialog
implements IKernelEventListener,
ItemListener {
    Locale currentLocale;
    ResourceBundle messages;
    Project proj;
    SerialKernel kernel;
    boolean collectPlantData = false;
    private AppOptions options = new AppOptions();
    private final String PT100 = "PT100";
    private final String ANALOG_VOLT = "0-10 V";
    private final String ANALOG_CURRENT = "4-20mA";
    public double p1_Ohm;
    public double p1_Temp;
    public double p2_Ohm;
    public double p2_Temp;
    protected ArrayList<String> commandQueue;
    protected Boolean sendingCommandQueue = false;
    private JButton btnCalibrate;
    private JButton btnExit;
    private JCheckBox chkAllInputs;
    private JComboBox comboInNumber;
    private JComboBox comboInputType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable tableCalibrationPoints;
    private JTextArea txtMsgArea;

    public CalibrationDialog(Frame parent, boolean modal, Project prj, IKernel krn) {
        super(parent, modal);
        this.initComponents();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.messages = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.proj = prj;
        this.kernel = (SerialKernel)krn;
        this.FillDialogFields();
        this.comboInputType.addItemListener(this);
        this.kernel.addKernelEventListener(this);
        this.collectPlantData = this.kernel.getCollectStatus();
        this.kernel.collectPlantData(false);
        this.commandQueue = new ArrayList();
        this.center();
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtMsgArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.tableCalibrationPoints = new JTable();
        this.comboInputType = new JComboBox();
        this.comboInNumber = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.btnCalibrate = new JButton();
        this.chkAllInputs = new JCheckBox();
        this.btnExit = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setName("jScrollPane1");
        this.txtMsgArea.setColumns(20);
        this.txtMsgArea.setEditable(false);
        this.txtMsgArea.setRows(5);
        this.txtMsgArea.setName("txtMsgArea");
        this.jScrollPane1.setViewportView(this.txtMsgArea);
        this.jScrollPane2.setName("jScrollPane2");
        this.tableCalibrationPoints.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"Ohm", "Temp"}){
            Class[] types;
            {
                this.types = new Class[]{Double.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableCalibrationPoints.setName("tableCalibrationPoints");
        this.jScrollPane2.setViewportView(this.tableCalibrationPoints);
        this.comboInputType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboInputType.setName("comboInputType");
        this.comboInNumber.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboInNumber.setName("comboInNumber");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(CalibrationDialog.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.btnCalibrate.setText(resourceMap.getString("btnCalibrate.text", new Object[0]));
        this.btnCalibrate.setName("btnCalibrate");
        this.btnCalibrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalibrationDialog.this.btnCalibrateActionPerformed(evt);
            }
        });
        this.chkAllInputs.setText(resourceMap.getString("chkAllInputs.text", new Object[0]));
        this.chkAllInputs.setName("chkAllInputs");
        this.btnExit.setIcon(resourceMap.getIcon("btnExit.icon"));
        this.btnExit.setText(resourceMap.getString("btnExit.text", new Object[0]));
        this.btnExit.setName("btnExit");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalibrationDialog.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.btnCalibrate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnExit)).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.comboInNumber, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(41, 41, 41).addComponent(this.comboInputType, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.chkAllInputs).addGap(18, 18, 18).addComponent(this.jScrollPane2, -2, 214, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboInputType, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboInNumber, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.chkAllInputs))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, 0, 0, Short.MAX_VALUE))).addGap(31, 31, 31).addComponent(this.jScrollPane1, -2, 165, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCalibrate).addComponent(this.btnExit)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCalibrateActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(null, this.messages.getString("tar") + this.messages.getString("tar2"), "Info", 0);
        if (res == 1) {
            return;
        }
        this.txtMsgArea.setText("");
        this.commandQueue.clear();
        this.backupValues();
        String msg = "<CL point ";
        msg = msg + "1 ";
        msg = msg + "" + this.p1_Ohm + " " + this.p1_Temp + " " + this.p2_Ohm + " " + this.p2_Temp + " >";
        this.commandQueue.add(msg);
        msg = "<CL cal ";
        if (this.chkAllInputs.isSelected()) {
            msg = msg + "ALL ";
        } else {
            msg = msg + (this.comboInNumber.getSelectedIndex() + 1);
            msg = msg + " ";
        }
        msg = msg + (this.comboInputType.getSelectedIndex() + 1);
        msg = msg + ">";
        this.commandQueue.add(msg);
        this.btnExit.setEnabled(false);
        this.sendMessageQueue();
    }

    private void backupValues() {
        DefaultTableModel model = (DefaultTableModel)this.tableCalibrationPoints.getModel();
        this.p1_Ohm = Double.parseDouble(model.getValueAt(0, 0).toString());
        this.p1_Temp = Double.parseDouble(model.getValueAt(0, 1).toString());
        this.p2_Ohm = Double.parseDouble(model.getValueAt(1, 0).toString());
        this.p2_Temp = Double.parseDouble(model.getValueAt(1, 1).toString());
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.backupValues();
        this.kernel.collectPlantData(true);
    }

    protected void sendMessageQueue() {
        if (this.commandQueue.size() == 0) {
            return;
        }
        this.sendingCommandQueue = true;
        this.kernel.collectPlantData(false);
        this.kernel.sendCommand(this.commandQueue.get(0));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrationDialog dialog = new CalibrationDialog((Frame)new JFrame(), true, null, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("New Message Received")) {
            this.txtMsgArea.append(evt.getEventMessage() + "\r\n");
        } else if (evt.getEventType().equals("Command Executed")) {
            if (this.sendingCommandQueue.booleanValue()) {
                this.txtMsgArea.append(this.commandQueue.get(0) + " -- Exec OK\r\n");
                this.commandQueue.remove(0);
                if (this.commandQueue.size() > 0) {
                    String msg = this.commandQueue.get(0);
                    this.kernel.sendCommand(msg);
                } else {
                    this.sendingCommandQueue = false;
                    this.btnExit.setEnabled(true);
                }
            }
        } else if (evt.getEventType().equals("Command Not Executed") || evt.getEventType().equals("Timeout on command")) {
            this.txtMsgArea.append("Errore !!\r\n");
            this.btnExit.setEnabled(true);
        }
    }

    private void FillDialogFields() {
        if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID9MX || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID9ST || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID6ST || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID6MX) {
            this.comboInputType.removeItemListener(this);
            this.comboInputType.removeAllItems();
            this.comboInputType.addItem("PT100");
            this.comboInputType.addItem("0-10 V");
            this.comboInputType.addItem("4-20mA");
            this.comboInputType.setSelectedIndex(0);
            this.comboInputType.addItemListener(this);
            this.comboInNumber.removeAllItems();
            for (int i = 1; i < 9; ++i) {
                this.comboInNumber.addItem("UI" + i);
            }
            this.comboInNumber.setSelectedIndex(0);
        } else if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID1CO || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID1HC) {
            this.comboInputType.removeItemListener(this);
            this.comboInputType.removeAllItems();
            this.comboInputType.addItem("PT100");
            this.comboInputType.addItem("0-10 V");
            this.comboInputType.setSelectedIndex(0);
            this.comboInputType.addItemListener(this);
            this.comboInNumber.removeAllItems();
            this.comboInNumber.addItem("P1");
            this.comboInNumber.addItem("P2");
            this.comboInNumber.setSelectedIndex(0);
        } else if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2T || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2TH || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2THR || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2TR) {
            this.comboInputType.removeItemListener(this);
            this.comboInputType.removeAllItems();
            this.comboInputType.addItem("PT100");
            this.comboInputType.addItem("0-10 V");
            this.comboInputType.setSelectedIndex(0);
            this.comboInputType.addItemListener(this);
            this.comboInNumber.removeAllItems();
            this.comboInNumber.addItem("P1");
            this.comboInNumber.addItem("P2");
            this.comboInNumber.setSelectedIndex(0);
        } else if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID4DSP || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID4ST) {
            this.comboInputType.removeItemListener(this);
            this.comboInputType.removeAllItems();
            this.comboInputType.addItem("PT100");
            this.comboInputType.addItem("0-10 V");
            this.comboInputType.addItem("4-20mA");
            this.comboInputType.setSelectedIndex(0);
            this.comboInputType.addItemListener(this);
            this.comboInNumber.removeAllItems();
            for (int i = 1; i < 3; ++i) {
                this.comboInNumber.addItem("UI" + i);
            }
            this.comboInNumber.setSelectedIndex(0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.comboInputType)) {
            if (this.comboInputType.getSelectedItem().equals("PT100")) {
                this.tableCalibrationPoints.getColumnModel().getColumn(0).setHeaderValue("Ohm");
                this.tableCalibrationPoints.getColumnModel().getColumn(1).setHeaderValue("Temp");
            } else if (this.comboInputType.getSelectedItem().equals("0-10 V")) {
                this.tableCalibrationPoints.getColumnModel().getColumn(0).setHeaderValue("Volt");
                this.tableCalibrationPoints.getColumnModel().getColumn(1).setHeaderValue("NA");
            } else if (this.comboInputType.getSelectedItem().equals("4-20mA")) {
                this.tableCalibrationPoints.getColumnModel().getColumn(0).setHeaderValue("mA");
                this.tableCalibrationPoints.getColumnModel().getColumn(1).setHeaderValue("NA");
            }
            this.tableCalibrationPoints.getTableHeader().resizeAndRepaint();
            if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID9MX || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID9ST || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID6ST || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID6MX) {
                return;
            }
            if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID1CO || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID1HC) {
                if (this.comboInputType.getSelectedItem().equals("PT100")) {
                    this.comboInNumber.removeAllItems();
                    this.comboInNumber.addItem("P1");
                    this.comboInNumber.addItem("P2");
                    this.comboInNumber.setSelectedIndex(0);
                } else if (this.comboInputType.getSelectedItem().equals("0-10 V")) {
                    this.comboInNumber.removeAllItems();
                    this.comboInNumber.addItem("X1");
                    this.comboInNumber.setSelectedIndex(0);
                } else if (this.comboInputType.getSelectedItem().equals("4-20mA")) {
                    // empty if block
                }
            } else if (this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2T || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2TH || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2THR || this.proj.getBoardType() == BoardsTypesAndDescription.BoardType.mPID2TR) {
                // empty if block
            }
        }
    }

    public void showDialog() {
        DefaultTableModel tableModel = (DefaultTableModel)this.tableCalibrationPoints.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            tableModel.removeRow(i);
        }
        tableModel.addRow(new Object[]{""});
        tableModel.setValueAt(this.p1_Ohm, 0, 0);
        tableModel.setValueAt(this.p1_Temp, 0, 1);
        tableModel.setValueAt(this.p2_Ohm, 1, 0);
        tableModel.setValueAt(this.p2_Temp, 1, 1);
        this.validate();
        this.setVisible(true);
    }
}

