/*
 * Decompiled with CFR 0.152.
 */
package connection.gui;

import Util.FieldChecker;
import Util.ProgressBar;
import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.SerialKernel;
import connection.gui.InfoDialog;
import connection.gui.PnlUpload;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import nodes.BoardsTypesAndDescription;
import nodes.Project;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.openide.util.Exceptions;

public class ConfigureComDlg
extends JDialog
implements ItemListener,
KeyListener,
IKernelEventListener {
    public static int RET_OK = 1;
    public static int RET_CANCEL = 0;
    private int returnStatus = RET_CANCEL;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();
    public boolean fieldChanged = false;
    private SerialKernel kernel;
    private Project project;
    InfoDialog idlg;
    private ArrayList<String> commandQueue = new ArrayList();
    private PnlUpload pnlUpload = new PnlUpload();
    boolean collectStatus = false;
    InfoDialog dlg = new InfoDialog(null, false);
    private boolean sendingCommandQueue = false;
    private ProgressBar bar = new ProgressBar(null, false);
    private boolean disconnectOnFinish = false;
    public JButton btnChangeProtocol;
    public JButton btnChangeProtocol2;
    public JButton btnChangeProtocol3;
    public JButton btnChangeProtocolNET;
    public JButton btnClose;
    public JButton btnGenerateMAC;
    public JComboBox comboCOM1NumBits;
    public JComboBox comboCOM1Parity;
    public JComboBox comboCOM1Protocol;
    public JComboBox comboCOM1Speed;
    public JComboBox comboCOM1StopBits;
    public JComboBox comboCOM2NumBits;
    public JComboBox comboCOM2Parity;
    public JComboBox comboCOM2Protocol;
    public JComboBox comboCOM2Speed;
    public JComboBox comboCOM2StopBits;
    public JComboBox comboCOM3NumBits;
    public JComboBox comboCOM3Parity;
    public JComboBox comboCOM3Protocol;
    public JComboBox comboCOM3Speed;
    public JComboBox comboCOM3StopBits;
    public JLabel jLabel10;
    public JLabel jLabel12;
    public JLabel jLabel13;
    public JLabel jLabel14;
    public JLabel jLabel15;
    public JLabel jLabel16;
    public JLabel jLabel17;
    public JLabel jLabel19;
    public JLabel jLabel2;
    public JLabel jLabel23;
    public JLabel jLabel24;
    public JLabel jLabel25;
    public JLabel jLabel26;
    public JLabel jLabel27;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JLabel jLabel8;
    public JLabel jLabel9;
    public JSeparator jSeparator1;
    public JPanel pnlEthernet;
    public JPanel pnlRS1;
    public JPanel pnlRS2;
    public JPanel pnlRS4;
    public JSpinner spnrEtherPort;
    public JTextField txtEtherGateway;
    public JTextField txtEtherIPAddress;
    public JFormattedTextField txtEtherMacAddr;
    public JTextField txtEtherSubnetMask;

    public ConfigureComDlg(Frame parent, boolean modal, SerialKernel ker, Project proj) {
        super(parent, modal);
        this.initComponents();
        this.center();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.comboCOM1Protocol.addItemListener(this);
        this.comboCOM1Speed.addItemListener(this);
        this.comboCOM2Protocol.addItemListener(this);
        this.comboCOM2Speed.addItemListener(this);
        this.txtEtherGateway.addKeyListener(this);
        this.txtEtherIPAddress.addKeyListener(this);
        this.txtEtherMacAddr.addKeyListener(this);
        this.txtEtherSubnetMask.addKeyListener(this);
        this.btnChangeProtocol.setVisible(true);
        this.kernel = ker;
        this.kernel.addKernelEventListener(this);
        this.project = proj;
        this.setResizable(false);
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.pnlEthernet = new JPanel();
        this.jLabel2 = new JLabel();
        this.txtEtherIPAddress = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtEtherSubnetMask = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtEtherGateway = new JTextField();
        this.jLabel19 = new JLabel();
        this.spnrEtherPort = new JSpinner();
        this.jLabel13 = new JLabel();
        this.txtEtherMacAddr = new JFormattedTextField();
        this.btnGenerateMAC = new JButton();
        this.btnChangeProtocolNET = new JButton();
        this.pnlRS2 = new JPanel();
        this.comboCOM2StopBits = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.comboCOM2Protocol = new JComboBox();
        this.comboCOM2Speed = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.comboCOM2NumBits = new JComboBox();
        this.jLabel10 = new JLabel();
        this.comboCOM2Parity = new JComboBox();
        this.btnChangeProtocol2 = new JButton();
        this.pnlRS1 = new JPanel();
        this.comboCOM1StopBits = new JComboBox();
        this.jLabel12 = new JLabel();
        this.comboCOM1Speed = new JComboBox();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.comboCOM1NumBits = new JComboBox();
        this.jLabel16 = new JLabel();
        this.comboCOM1Parity = new JComboBox();
        this.jLabel17 = new JLabel();
        this.comboCOM1Protocol = new JComboBox();
        this.btnChangeProtocol = new JButton();
        this.btnClose = new JButton();
        this.pnlRS4 = new JPanel();
        this.comboCOM3StopBits = new JComboBox();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.comboCOM3Protocol = new JComboBox();
        this.comboCOM3Speed = new JComboBox();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.comboCOM3NumBits = new JComboBox();
        this.jLabel27 = new JLabel();
        this.comboCOM3Parity = new JComboBox();
        this.btnChangeProtocol3 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.jSeparator1.setName("jSeparator1");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(ConfigureComDlg.class);
        this.pnlEthernet.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlEthernet.border.title", new Object[0])));
        this.pnlEthernet.setName("pnlEthernet");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.txtEtherIPAddress.setColumns(10);
        this.txtEtherIPAddress.setHorizontalAlignment(11);
        this.txtEtherIPAddress.setText(resourceMap.getString("txtEtherIPAddress.text", new Object[0]));
        this.txtEtherIPAddress.setName("txtEtherIPAddress");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.txtEtherSubnetMask.setColumns(10);
        this.txtEtherSubnetMask.setHorizontalAlignment(11);
        this.txtEtherSubnetMask.setText(resourceMap.getString("txtEtherSubnetMask.text", new Object[0]));
        this.txtEtherSubnetMask.setName("txtEtherSubnetMask");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.txtEtherGateway.setColumns(10);
        this.txtEtherGateway.setHorizontalAlignment(11);
        this.txtEtherGateway.setText(resourceMap.getString("txtEtherGateway.text", new Object[0]));
        this.txtEtherGateway.setName("txtEtherGateway");
        this.jLabel19.setText(resourceMap.getString("jLabel19.text", new Object[0]));
        this.jLabel19.setName("jLabel19");
        this.spnrEtherPort.setModel(new SpinnerNumberModel(23, 1, 65535, 1));
        this.spnrEtherPort.setEnabled(false);
        this.spnrEtherPort.setName("spnrEtherPort");
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        try {
            this.txtEtherMacAddr.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("HH:HH:HH:HH:HH:HH")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.txtEtherMacAddr.setHorizontalAlignment(11);
        this.txtEtherMacAddr.setText(resourceMap.getString("txtEtherMacAddr.text", new Object[0]));
        this.txtEtherMacAddr.setName("txtEtherMacAddr");
        this.btnGenerateMAC.setText(resourceMap.getString("btnGenerateMAC.text", new Object[0]));
        this.btnGenerateMAC.setName("btnGenerateMAC");
        this.btnGenerateMAC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureComDlg.this.btnGenerateMACActionPerformed(evt);
            }
        });
        this.btnChangeProtocolNET.setIcon(resourceMap.getIcon("btnChangeProtocolNET.icon"));
        this.btnChangeProtocolNET.setText(resourceMap.getString("btnChangeProtocolNET.text", new Object[0]));
        this.btnChangeProtocolNET.setName("btnChangeProtocolNET");
        this.btnChangeProtocolNET.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureComDlg.this.btnChangeProtocolNETActionPerformed(evt);
            }
        });
        GroupLayout pnlEthernetLayout = new GroupLayout(this.pnlEthernet);
        this.pnlEthernet.setLayout(pnlEthernetLayout);
        pnlEthernetLayout.setHorizontalGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEthernetLayout.createSequentialGroup().addContainerGap().addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addGroup(GroupLayout.Alignment.TRAILING, pnlEthernetLayout.createSequentialGroup().addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlEthernetLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtEtherIPAddress, -1, 101, Short.MAX_VALUE)).addGroup(pnlEthernetLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtEtherMacAddr, -2, 110, -2).addComponent(this.txtEtherGateway, -2, -1, -2)))).addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEthernetLayout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnrEtherPort, -2, -1, -2)).addGroup(pnlEthernetLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnGenerateMAC).addGroup(pnlEthernetLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtEtherSubnetMask, -2, -1, -2))))).addGap(32, 32, 32).addComponent(this.btnChangeProtocolNET).addGap(104, 104, 104)))));
        pnlEthernetLayout.setVerticalGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEthernetLayout.createSequentialGroup().addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEthernetLayout.createSequentialGroup().addContainerGap().addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtEtherIPAddress, -2, -1, -2).addComponent(this.jLabel19).addComponent(this.spnrEtherPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.txtEtherGateway, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.txtEtherSubnetMask, -2, -1, -2)).addGap(12, 12, 12).addGroup(pnlEthernetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.txtEtherMacAddr, -2, -1, -2).addComponent(this.btnGenerateMAC))).addComponent(this.btnChangeProtocolNET)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlRS2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlRS2.border.title", new Object[0])));
        this.pnlRS2.setName("pnlRS2");
        this.comboCOM2StopBits.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "1.5", "2"}));
        this.comboCOM2StopBits.setEnabled(false);
        this.comboCOM2StopBits.setName("comboCOM2StopBits");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.comboCOM2Protocol.setModel(new DefaultComboBoxModel<String>(new String[]{"MB RTU Slave", "MB RTU Master"}));
        this.comboCOM2Protocol.setName("comboCOM2Protocol");
        this.comboCOM2Speed.setModel(new DefaultComboBoxModel<String>(new String[]{"9600", "19200", "38400", "57600", "115200"}));
        this.comboCOM2Speed.setName("comboCOM2Speed");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.comboCOM2NumBits.setModel(new DefaultComboBoxModel<String>(new String[]{"5", "6", "7", "8"}));
        this.comboCOM2NumBits.setEnabled(false);
        this.comboCOM2NumBits.setName("comboCOM2NumBits");
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.comboCOM2Parity.setModel(new DefaultComboBoxModel<String>(new String[]{"ODD", "EVEN", "NONE"}));
        this.comboCOM2Parity.setEnabled(false);
        this.comboCOM2Parity.setName("comboCOM2Parity");
        this.btnChangeProtocol2.setIcon(resourceMap.getIcon("btnChangeProtocol2.icon"));
        this.btnChangeProtocol2.setText(resourceMap.getString("btnChangeProtocol2.text", new Object[0]));
        this.btnChangeProtocol2.setName("btnChangeProtocol2");
        this.btnChangeProtocol2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureComDlg.this.btnChangeProtocol2ActionPerformed(evt);
            }
        });
        GroupLayout pnlRS2Layout = new GroupLayout(this.pnlRS2);
        this.pnlRS2.setLayout(pnlRS2Layout);
        pnlRS2Layout.setHorizontalGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS2Layout.createSequentialGroup().addContainerGap().addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS2Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboCOM2Protocol, -2, -1, -2)).addGroup(pnlRS2Layout.createSequentialGroup().addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCOM2Speed, -2, -1, -2).addComponent(this.comboCOM2NumBits, -2, -1, -2)).addGap(54, 54, 54).addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCOM2Parity, -2, -1, -2).addComponent(this.comboCOM2StopBits, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 60, Short.MAX_VALUE).addComponent(this.btnChangeProtocol2).addContainerGap()));
        pnlRS2Layout.setVerticalGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS2Layout.createSequentialGroup().addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS2Layout.createSequentialGroup().addContainerGap().addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.comboCOM2Protocol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS2Layout.createSequentialGroup().addGroup(pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboCOM2Speed, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.comboCOM2Parity, -2, -1, -2)).addGap(43, 43, 43)).addGroup(GroupLayout.Alignment.TRAILING, pnlRS2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.comboCOM2NumBits, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.comboCOM2StopBits, -2, -1, -2)))).addComponent(this.btnChangeProtocol2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlRS1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlRS1.border.title", new Object[0])));
        this.pnlRS1.setName("pnlRS1");
        this.comboCOM1StopBits.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "1.5", "2"}));
        this.comboCOM1StopBits.setEnabled(false);
        this.comboCOM1StopBits.setName("comboCOM1StopBits");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.comboCOM1Speed.setModel(new DefaultComboBoxModel<String>(new String[]{"9600", "19200", "38400", "57600", "115200"}));
        this.comboCOM1Speed.setSelectedIndex(4);
        this.comboCOM1Speed.setToolTipText(resourceMap.getString("comboCOM1Speed.toolTipText", new Object[0]));
        this.comboCOM1Speed.setName("comboCOM1Speed");
        this.comboCOM1Speed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureComDlg.this.comboCOM1SpeedItemStateChanged(evt);
            }
        });
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.comboCOM1NumBits.setModel(new DefaultComboBoxModel<String>(new String[]{"5", "6", "7", "8"}));
        this.comboCOM1NumBits.setSelectedIndex(3);
        this.comboCOM1NumBits.setEnabled(false);
        this.comboCOM1NumBits.setName("comboCOM1NumBits");
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        this.comboCOM1Parity.setModel(new DefaultComboBoxModel<String>(new String[]{"ODD", "EVEN", "NONE"}));
        this.comboCOM1Parity.setEnabled(false);
        this.comboCOM1Parity.setName("comboCOM1Parity");
        this.jLabel17.setText(resourceMap.getString("jLabel17.text", new Object[0]));
        this.jLabel17.setName("jLabel17");
        this.comboCOM1Protocol.setModel(new DefaultComboBoxModel<String>(new String[]{"MB Slave", "MB Master", "NTH"}));
        this.comboCOM1Protocol.setName("comboCOM1Protocol");
        this.comboCOM1Protocol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureComDlg.this.comboCOM1ProtocolItemStateChanged(evt);
            }
        });
        this.btnChangeProtocol.setIcon(resourceMap.getIcon("btnChangeProtocol.icon"));
        this.btnChangeProtocol.setText(resourceMap.getString("btnChangeProtocol.text", new Object[0]));
        this.btnChangeProtocol.setName("btnChangeProtocol");
        this.btnChangeProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureComDlg.this.btnChangeProtocolActionPerformed(evt);
            }
        });
        GroupLayout pnlRS1Layout = new GroupLayout(this.pnlRS1);
        this.pnlRS1.setLayout(pnlRS1Layout);
        pnlRS1Layout.setHorizontalGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS1Layout.createSequentialGroup().addContainerGap().addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS1Layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboCOM1NumBits, -2, -1, -2)).addGroup(pnlRS1Layout.createSequentialGroup().addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.comboCOM1Protocol, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.comboCOM1Speed, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)))).addGap(34, 34, 34).addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCOM1Parity, -2, -1, -2).addComponent(this.comboCOM1StopBits, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addComponent(this.btnChangeProtocol).addContainerGap()));
        pnlRS1Layout.setVerticalGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS1Layout.createSequentialGroup().addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS1Layout.createSequentialGroup().addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.comboCOM1Protocol, -2, -1, -2)).addGap(12, 12, 12).addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.comboCOM1Speed, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.comboCOM1Parity, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.comboCOM1NumBits, -2, -1, -2).addComponent(this.jLabel15).addComponent(this.comboCOM1StopBits, -2, -1, -2))).addComponent(this.btnChangeProtocol)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnClose.setIcon(resourceMap.getIcon("btnClose.icon"));
        this.btnClose.setText(resourceMap.getString("btnClose.text", new Object[0]));
        this.btnClose.setName("btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureComDlg.this.btnCloseActionPerformed(evt);
            }
        });
        this.pnlRS4.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlRS4.border.title", new Object[0])));
        this.pnlRS4.setName("pnlRS4");
        this.comboCOM3StopBits.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "1.5", "2"}));
        this.comboCOM3StopBits.setEnabled(false);
        this.comboCOM3StopBits.setName("comboCOM3StopBits");
        this.jLabel23.setText(resourceMap.getString("jLabel23.text", new Object[0]));
        this.jLabel23.setName("jLabel23");
        this.jLabel24.setText(resourceMap.getString("jLabel24.text", new Object[0]));
        this.jLabel24.setName("jLabel24");
        this.comboCOM3Protocol.setModel(new DefaultComboBoxModel<String>(new String[]{"MB RTU Slave", "MB RTU Master"}));
        this.comboCOM3Protocol.setName("comboCOM3Protocol");
        this.comboCOM3Speed.setModel(new DefaultComboBoxModel<String>(new String[]{"9600", "19200", "38400", "57600", "115200"}));
        this.comboCOM3Speed.setSelectedIndex(1);
        this.comboCOM3Speed.setName("comboCOM3Speed");
        this.jLabel25.setText(resourceMap.getString("jLabel25.text", new Object[0]));
        this.jLabel25.setName("jLabel25");
        this.jLabel26.setText(resourceMap.getString("jLabel26.text", new Object[0]));
        this.jLabel26.setName("jLabel26");
        this.comboCOM3NumBits.setModel(new DefaultComboBoxModel<String>(new String[]{"5", "6", "7", "8"}));
        this.comboCOM3NumBits.setEnabled(false);
        this.comboCOM3NumBits.setName("comboCOM3NumBits");
        this.jLabel27.setText(resourceMap.getString("jLabel27.text", new Object[0]));
        this.jLabel27.setName("jLabel27");
        this.comboCOM3Parity.setModel(new DefaultComboBoxModel<String>(new String[]{"ODD", "EVEN", "NONE"}));
        this.comboCOM3Parity.setEnabled(false);
        this.comboCOM3Parity.setName("comboCOM3Parity");
        this.btnChangeProtocol3.setIcon(resourceMap.getIcon("btnChangeProtocol3.icon"));
        this.btnChangeProtocol3.setText(resourceMap.getString("btnChangeProtocol3.text", new Object[0]));
        this.btnChangeProtocol3.setName("btnChangeProtocol3");
        this.btnChangeProtocol3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureComDlg.this.btnChangeProtocol3ActionPerformed(evt);
            }
        });
        GroupLayout pnlRS4Layout = new GroupLayout(this.pnlRS4);
        this.pnlRS4.setLayout(pnlRS4Layout);
        pnlRS4Layout.setHorizontalGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS4Layout.createSequentialGroup().addContainerGap().addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS4Layout.createSequentialGroup().addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboCOM3Protocol, -2, -1, -2)).addGroup(pnlRS4Layout.createSequentialGroup().addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel27).addComponent(this.jLabel23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCOM3Speed, -2, -1, -2).addComponent(this.comboCOM3NumBits, -2, -1, -2)).addGap(54, 54, 54).addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel26).addComponent(this.jLabel25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCOM3Parity, -2, -1, -2).addComponent(this.comboCOM3StopBits, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 60, Short.MAX_VALUE).addComponent(this.btnChangeProtocol3).addContainerGap()));
        pnlRS4Layout.setVerticalGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS4Layout.createSequentialGroup().addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS4Layout.createSequentialGroup().addContainerGap().addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel24).addComponent(this.comboCOM3Protocol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRS4Layout.createSequentialGroup().addGroup(pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.comboCOM3Speed, -2, -1, -2).addComponent(this.jLabel25).addComponent(this.comboCOM3Parity, -2, -1, -2)).addGap(43, 43, 43)).addGroup(GroupLayout.Alignment.TRAILING, pnlRS4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.comboCOM3NumBits, -2, -1, -2).addComponent(this.jLabel26).addComponent(this.comboCOM3StopBits, -2, -1, -2)))).addComponent(this.btnChangeProtocol3)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlRS1, -1, -1, Short.MAX_VALUE)).addComponent(this.pnlRS2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlRS4, -1, -1, Short.MAX_VALUE).addComponent(this.pnlEthernet, -1, 528, Short.MAX_VALUE).addComponent(this.btnClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -2, 10, -2).addComponent(this.pnlRS1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlRS2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlRS4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlEthernet, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlRS4.getAccessibleContext().setAccessibleName(resourceMap.getString("pnlRS4.AccessibleContext.accessibleName", new Object[0]));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (!(FieldChecker.isValidIP(this.txtEtherIPAddress.getText(), "Error IP Address") && FieldChecker.isValidIP(this.txtEtherSubnetMask.getText(), "Error Subnet") && FieldChecker.isValidIP(this.txtEtherGateway.getText(), "Error Gateway"))) {
            return;
        }
        this.returnStatus = RET_OK;
        this.setVisible(false);
    }

    private void btnGenerateMACActionPerformed(ActionEvent evt) {
        Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
        if (JOptionPane.showOptionDialog(null, this.message.getString("sicuroGenerico"), this.message.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 1) {
            return;
        }
        Random rand = new Random();
        String newMAC = "02:00:00";
        for (int i = 0; i < 3; ++i) {
            int number = ConfigureComDlg.genRandomInteger(0, 255, rand);
            newMAC = newMAC + ":" + String.format("%1$02X", number);
        }
        this.txtEtherMacAddr.setText(newMAC);
        this.validate();
        this.fieldChanged = true;
    }

    public PnlUpload getPnlUpload() {
        return this.pnlUpload;
    }

    public boolean sendCommands() {
        if (this.commandQueue.size() == 0) {
            this.bar.setProgress(100);
            this.sendingCommandQueue = false;
            this.kernel.collectPlantData(this.collectStatus);
            return false;
        }
        this.kernel.collectPlantData(false);
        this.sendingCommandQueue = true;
        this.kernel.sendCommand(this.commandQueue.get(0));
        this.bar.setVisible(true);
        this.bar.setProgress(0);
        this.bar.setAlwaysOnTop(true);
        return true;
    }

    private void btnChangeProtocolActionPerformed(ActionEvent evt) {
        this.commandQueue.clear();
        int idx = this.comboCOM1Protocol.getSelectedIndex();
        if (idx == 0) {
            String msg = "<PT set 1 1 ";
            msg = msg + this.comboCOM1Speed.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1NumBits.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1Parity.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1StopBits.getSelectedIndex() + " ";
            msg = msg + " >";
            this.disconnectOnFinish = this.kernel.isKernelSerial();
            this.commandQueue.clear();
            this.commandQueue.add(msg);
            this.sendCommands();
        } else if (idx == 1) {
            String msg = "<PT set 1 2 ";
            msg = msg + this.comboCOM1Speed.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1NumBits.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1Parity.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1StopBits.getSelectedIndex() + " ";
            msg = msg + " >";
            this.disconnectOnFinish = this.kernel.isKernelSerial();
            this.commandQueue.clear();
            this.commandQueue.add(msg);
            this.sendCommands();
        } else if (idx == 2) {
            String msg = "<PT set 1 5 ";
            msg = msg + this.comboCOM1Speed.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1NumBits.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1Parity.getSelectedIndex() + " ";
            msg = msg + this.comboCOM1StopBits.getSelectedIndex() + " ";
            msg = msg + " >";
            this.disconnectOnFinish = this.kernel.isKernelSerial();
            this.commandQueue.clear();
            this.commandQueue.add(msg);
            this.sendCommands();
        }
    }

    private void btnChangeProtocol2ActionPerformed(ActionEvent evt) {
        this.commandQueue.clear();
        String msg = "<PT set 2 ";
        msg = msg + (this.comboCOM2Protocol.getSelectedIndex() + 1) + " ";
        msg = msg + this.comboCOM2Speed.getSelectedIndex() + " ";
        msg = msg + this.comboCOM2NumBits.getSelectedIndex() + " ";
        msg = msg + this.comboCOM2Parity.getSelectedIndex() + " ";
        msg = msg + this.comboCOM2StopBits.getSelectedIndex() + " ";
        msg = msg + " >";
        this.commandQueue.add(msg);
        this.sendCommands();
    }

    private void btnChangeProtocolNETActionPerformed(ActionEvent evt) {
        if (!(FieldChecker.isValidIP(this.txtEtherIPAddress.getText(), "Error IP Address") && FieldChecker.isValidIP(this.txtEtherSubnetMask.getText(), "Error Subnet") && FieldChecker.isValidIP(this.txtEtherGateway.getText(), "Error Gateway"))) {
            return;
        }
        this.commandQueue.clear();
        String msg = "<WB set 2 2 ";
        StringTokenizer ipTokens = new StringTokenizer(this.txtEtherIPAddress.getText(), ".");
        while (ipTokens.hasMoreTokens()) {
            msg = msg + ipTokens.nextToken() + " ";
        }
        ipTokens = new StringTokenizer(this.txtEtherSubnetMask.getText(), ".");
        while (ipTokens.hasMoreTokens()) {
            msg = msg + ipTokens.nextToken() + " ";
        }
        ipTokens = new StringTokenizer(this.txtEtherGateway.getText(), ".");
        while (ipTokens.hasMoreTokens()) {
            msg = msg + ipTokens.nextToken() + " ";
        }
        msg = msg + " >";
        this.commandQueue.add(msg);
        msg = "<WB mac ";
        ipTokens = new StringTokenizer(this.txtEtherMacAddr.getText(), ":");
        while (ipTokens.hasMoreTokens()) {
            msg = msg + ipTokens.nextToken() + " ";
        }
        msg = msg + " >";
        this.commandQueue.add(msg);
        this.getPnlUpload().clearProgressBar();
        this.sendCommands();
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Command Executed") || evt.getEventType().equals("Valid Reply Received")) {
            if (this.sendingCommandQueue) {
                this.bar.setProgress(100 - 30 * this.commandQueue.size());
                this.commandQueue.remove(0);
                if (this.commandQueue.size() > 0) {
                    String msg = this.commandQueue.get(0);
                    this.kernel.sendCommand(msg);
                } else {
                    this.bar.setVisible(false);
                    this.sendingCommandQueue = false;
                    if (this.disconnectOnFinish) {
                        JOptionPane.showMessageDialog(null, this.message.getString("disconn"), this.message.getString("info2"), 1);
                        try {
                            this.kernel.getTerminalDialog().saveComParameters();
                            this.kernel.disconnect();
                            this.setVisible(false);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        } else if ((evt.getEventType().equals("Timeout on command") || evt.getEventType().equals("Command Not Executed")) && this.sendingCommandQueue) {
            JOptionPane.showMessageDialog(null, this.message.getString("errsend") + this.commandQueue.get(0), this.message.getString("er"), 0);
            this.commandQueue.clear();
            this.sendingCommandQueue = false;
            this.bar.setVisible(false);
        }
    }

    private void comboCOM1SpeedItemStateChanged(ItemEvent evt) {
        this.fieldChanged = true;
    }

    private void comboCOM1ProtocolItemStateChanged(ItemEvent evt) {
        this.fieldChanged = true;
    }

    private void btnChangeProtocol3ActionPerformed(ActionEvent evt) {
        this.commandQueue.clear();
        String msg = "<PT set 3 ";
        msg = msg + (this.comboCOM3Protocol.getSelectedIndex() + 1) + " ";
        msg = msg + this.comboCOM3Speed.getSelectedIndex() + " ";
        msg = msg + this.comboCOM3NumBits.getSelectedIndex() + " ";
        msg = msg + this.comboCOM3Parity.getSelectedIndex() + " ";
        msg = msg + this.comboCOM3StopBits.getSelectedIndex() + " ";
        msg = msg + " >";
        this.commandQueue.add(msg);
        this.sendCommands();
    }

    private static int genRandomInteger(int aStart, int aEnd, Random aRandom) {
        if (aStart > aEnd) {
            throw new IllegalArgumentException("Start cannot exceed End.");
        }
        long range = (long)aEnd - (long)aStart + 1L;
        long fraction = (long)((double)range * aRandom.nextDouble());
        int randomNumber = (int)(fraction + (long)aStart);
        return randomNumber;
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void showDialog() {
        this.fieldChanged = false;
        this.setVisible(true);
    }

    public boolean hasChanged() {
        return this.fieldChanged;
    }

    void setComboIdx(String value, JComboBox combo) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!combo.getItemAt(i).toString().equals(value)) continue;
            combo.setSelectedIndex(i);
            return;
        }
        combo.setSelectedIndex(0);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fieldChanged = true;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.fieldChanged = true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    void enablePanel(JPanel pnl, boolean enable) {
        for (Component c : pnl.getComponents()) {
            c.setEnabled(enable);
        }
        this.spnrEtherPort.setEnabled(false);
    }

    void setupPorts(BoardsTypesAndDescription.BoardType bt) {
        int ports = BoardsTypesAndDescription.boardNOfSerialPorts[bt.ordinal()];
        switch (ports) {
            case 0: {
                this.enablePanel(this.pnlRS1, false);
                this.enablePanel(this.pnlRS2, false);
                this.enablePanel(this.pnlRS4, false);
                break;
            }
            case 1: {
                this.enablePanel(this.pnlRS1, true);
                this.enablePanel(this.pnlRS2, false);
                this.enablePanel(this.pnlRS4, false);
                break;
            }
            case 2: {
                this.enablePanel(this.pnlRS1, true);
                this.enablePanel(this.pnlRS2, true);
                this.enablePanel(this.pnlRS4, false);
                break;
            }
            case 3: {
                this.enablePanel(this.pnlRS1, true);
                this.enablePanel(this.pnlRS2, true);
                this.enablePanel(this.pnlRS4, true);
            }
        }
        if (BoardsTypesAndDescription.boardNOfEthPorts[bt.ordinal()] > 0) {
            this.enablePanel(this.pnlEthernet, true);
        } else {
            this.enablePanel(this.pnlEthernet, false);
        }
    }

    class GenericWait
    extends SwingWorker<Void, Void> {
        int waitAmountMS = 0;

        public GenericWait(int amountSec) {
            this.waitAmountMS = amountSec * 1000;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                Thread.sleep(this.waitAmountMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }
}

