/*
 * Decompiled with CFR 0.152.
 */
package connection.gui;

import VisiProg.VisiProgApp;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class LogDialog
extends JDialog {
    public static int ALLMSG = 0;
    public static int OUTMSG = 1;
    public static int INMSG = 2;
    private JButton btnClear;
    private JButton btnClose;
    private JCheckBox checkShowIN;
    private JCheckBox checkShowOUT;
    private JScrollPane scrollLog;
    private JTextArea txtLog;

    public LogDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Logs");
        this.checkShowIN.setSelected(true);
        this.checkShowOUT.setSelected(true);
    }

    private void initComponents() {
        this.scrollLog = new JScrollPane();
        this.txtLog = new JTextArea();
        this.btnClear = new JButton();
        this.btnClose = new JButton();
        this.checkShowIN = new JCheckBox();
        this.checkShowOUT = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.scrollLog.setName("scrollLog");
        this.txtLog.setColumns(20);
        this.txtLog.setEditable(false);
        this.txtLog.setRows(5);
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(LogDialog.class);
        this.txtLog.setText(resourceMap.getString("txtLog.text", new Object[0]));
        this.txtLog.setName("txtLog");
        this.scrollLog.setViewportView(this.txtLog);
        this.btnClear.setText(resourceMap.getString("btnClear.text", new Object[0]));
        this.btnClear.setName("btnClear");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogDialog.this.btnClearActionPerformed(evt);
            }
        });
        this.btnClose.setIcon(resourceMap.getIcon("btnClose.icon"));
        this.btnClose.setText(resourceMap.getString("btnClose.text", new Object[0]));
        this.btnClose.setName("btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.checkShowIN.setText(resourceMap.getString("checkShowIN.text", new Object[0]));
        this.checkShowIN.setName("checkShowIN");
        this.checkShowOUT.setText(resourceMap.getString("checkShowOUT.text", new Object[0]));
        this.checkShowOUT.setName("checkShowOUT");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollLog, GroupLayout.Alignment.LEADING, -1, 625, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnClear).addGap(18, 18, 18).addComponent(this.checkShowIN).addGap(18, 18, 18).addComponent(this.checkShowOUT)).addComponent(this.btnClose, GroupLayout.Alignment.TRAILING))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClear).addComponent(this.checkShowIN).addComponent(this.checkShowOUT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollLog, -1, 274, Short.MAX_VALUE).addGap(23, 23, 23).addComponent(this.btnClose).addContainerGap()));
        this.pack();
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.txtLog.setText("");
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void addMsg(String message, int direction) {
        if (direction == OUTMSG && this.checkShowOUT.isSelected() || direction == INMSG && this.checkShowIN.isSelected() || direction == ALLMSG) {
            JScrollBar vbar = this.scrollLog.getVerticalScrollBar();
            boolean autoScroll = false;
            if (vbar.getValue() + vbar.getVisibleAmount() >= vbar.getMaximum() - 50) {
                autoScroll = true;
            }
            Date data = new Date();
            String msg = data.toString() + " ";
            msg = direction == OUTMSG ? msg + "OUT:" : msg + "IN:";
            this.txtLog.append(msg + message + "\n");
            if (autoScroll) {
                this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogDialog dialog = new LogDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

