/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import VisiProg.AppOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import nodes.DeviceData;
import nodes.SingleValDataEntry;
import nodes.devices.GenericNode;
import org.openide.util.Exceptions;
import sceneManager.AFOPin;

public class AfoDBDao {
    private String dbSystemLocation = "./db";
    private String dbName;
    private PreparedStatement stmtSaveNewInputRecord;
    private PreparedStatement stmtSaveNewOutputRecord;
    private PreparedStatement stmtSaveNewDeviceRecord;
    private PreparedStatement stmtSaveNewPinRecord;
    private AppOptions options = new AppOptions();
    Locale currentLocale;
    ResourceBundle message;
    private Connection dbConnection;
    private Properties dbProperties;
    private boolean isConnected = false;
    private boolean isEnabled = true;
    public static final int DEVICES_TABLE = 0;
    public static final int PIN_TABLE = 1;
    public static final int INPUT_TABLE = 2;
    public static final int OUTPUT_TABLE = 3;
    public static final int ERRORS_TABLE = 4;
    private static final String[] strTableNames = new String[]{"DEVICES", "PINS", "DATA_IN", "DATA_OUT", "ERRORS"};
    private static final String strCreateDataTablePrefix = "create table APP.";
    private static final String strCreateDataTableSuffix = " (    ID          INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),    ADDRESS     INTEGER,     IO_ID       VARCHAR(256),     TIME        TIMESTAMP,     VALUE       REAL )";
    private static final String strCreateDevicesTable = "create table APP.DEVICES (    ID          INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),    ADDRESS     INTEGER,     COMMENT     VARCHAR(256),     NOFIN       INTEGER,     NOFOUT      INTEGER )";
    private static final String strCreatePINTable = "create table APP.PINS (    ID          INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),    ADDRESS     INTEGER,     PINID       VARCHAR(256),    LABEL       VARCHAR(256) )";
    private static final String strCreateErrorsTable = "create table APP.ERRORS (    ID          INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),    DEVICE      INTEGER,     DESCRIPTION     VARCHAR(256),     TIME        TIMESTAMP)";
    private static final String strSaveError = "INSERT INTO APP.ERRORS   (DEVICE, DESCRIPTION, TIME) VALUES (?, ?, ?)";
    private static final String strSaveDevice = "INSERT INTO APP.DEVICES   (ADDRESS, COMMENT, NOFIN, NOFOUT) VALUES (?, ?, ?, ?)";
    private static final String strSaveOutData = "INSERT INTO APP.DATA_OUT   (ADDRESS, IO_ID, TIME, VALUE) VALUES (?, ?, ?, ?)";
    private static final String strSaveInData = "INSERT INTO APP.DATA_IN   (ADDRESS, IO_ID, TIME, VALUE) VALUES (?, ?, ?, ?)";
    private static final String strSavePin = "INSERT INTO APP.PINS   (ADDRESS, PINID, LABEL) VALUES (?, ?, ?)";
    private static final String strGetAllEntriesFromTablePrefix = "SELECT ID, ADDRESS, LABEL, TIME, VALUE FROM APP.";
    private static final String strGetAllEntriesFromTableSuffix = " ORDER BY ADDRESS ASC, TIME ASC ";
    private static final String strGetDevices = "SELECT DISTINCT ADDRESS, COMMENT, NOFIN, NOFOUT FROM APP.DEVICES ORDER BY ADDRESS ASC";
    private static final String strGetDevicesAndPins = "SELECT DISTINCT APP.DEVICES.ADDRESS, APP.DEVICES.COMMENT, PINID, LABEL FROM APP.DEVICES, APP.PINS WHERE APP.PINS.ADDRESS = APP.DEVICES.ADDRESS ORDER BY ADDRESS ASC, LABEL ASC";
    private static final String strGetPins = "SELECT DISTINCT ADDRESS, PINID, LABEL FROM APP.DEVICES, APP.PINS ORDER BY ADDRESS ASC, LABEL ASC";
    private static final String strDeleteSingleValPrefix = "DELETE FROM APP.";
    private static final String strDeleteSingleValSuffix = " WHERE ID = ";
    private static final String strCleanDB = "DELETE FROM APP.";

    public boolean isDBEnabled() {
        return this.isEnabled;
    }

    public void enableDB(boolean enable) {
        this.isEnabled = enable;
    }

    public AfoDBDao() {
        this("AFODatabase", "./db");
    }

    public AfoDBDao(String databaseName, String dbPath) {
        this.dbName = databaseName;
        this.dbSystemLocation = dbPath;
        this.setDBSystemDir();
        this.dbProperties = this.loadDBProperties();
        String driverName = this.dbProperties.getProperty("derby.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        this.loadDatabaseDriver(driverName);
        if (!this.dbExists()) {
            this.createDatabase();
        }
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
    }

    private boolean dbExists() {
        boolean bExists = false;
        String dbLocation = this.getDatabaseLocation();
        File dbFileDir = new File(dbLocation);
        if (dbFileDir.exists()) {
            bExists = true;
        }
        return bExists;
    }

    private void setDBSystemDir() {
        String systemDir = this.dbSystemLocation;
        System.setProperty("derby.system.home", systemDir);
        File fileSystemDir = new File(systemDir);
        fileSystemDir.mkdir();
    }

    private void loadDatabaseDriver(String driverName) {
        try {
            try {
                Class.forName(driverName).newInstance();
            }
            catch (InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private Properties loadDBProperties() {
        InputStream dbPropInputStream = null;
        dbPropInputStream = AfoDBDao.class.getResourceAsStream("Configuration.properties");
        this.dbProperties = new Properties();
        if (dbPropInputStream != null) {
            try {
                this.dbProperties.load(dbPropInputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.dbProperties;
    }

    private boolean createTables(Connection dbConnection) {
        boolean bCreatedTables = false;
        Statement statement = null;
        try {
            statement = dbConnection.createStatement();
            statement.execute(strCreateDevicesTable);
            statement.execute(strCreatePINTable);
            for (int i = 2; i < strTableNames.length; ++i) {
                String creaDb = strCreateDataTablePrefix + strTableNames[i] + strCreateDataTableSuffix;
                statement.execute(creaDb);
            }
            bCreatedTables = true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return bCreatedTables;
    }

    private boolean createDatabase() {
        boolean bCreated = false;
        String dbUrl = this.getDatabaseUrl();
        this.dbProperties.put("create", "true");
        try {
            this.dbConnection = DriverManager.getConnection(dbUrl, this.dbProperties);
            bCreated = this.createTables(this.dbConnection);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.dbProperties.remove("create");
        return bCreated;
    }

    public boolean connect() {
        String dbUrl = this.getDatabaseUrl();
        if (this.isConnected) {
            return true;
        }
        try {
            this.dbProperties.clear();
            this.dbConnection = DriverManager.getConnection(dbUrl, this.dbProperties);
            this.stmtSaveNewInputRecord = this.dbConnection.prepareStatement(strSaveInData, 1);
            this.stmtSaveNewOutputRecord = this.dbConnection.prepareStatement(strSaveOutData, 1);
            this.stmtSaveNewDeviceRecord = this.dbConnection.prepareStatement(strSaveDevice, 1);
            this.stmtSaveNewPinRecord = this.dbConnection.prepareStatement(strSavePin, 1);
            this.isConnected = this.dbConnection != null;
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, this.message.getString("dberrgrave"));
            ex.printStackTrace();
            this.disconnect();
            this.isConnected = false;
        }
        return this.isConnected;
    }

    private String getHomeDir() {
        return System.getProperty("user.home");
    }

    public void disconnect() {
        if (this.isConnected) {
            try {
                String dbUrl = this.getDatabaseUrl();
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                    System.out.println("Derby shut down normally");
                }
                System.err.println("Derby did not shut down normally");
                se.printStackTrace();
            }
            try {
                this.stmtSaveNewDeviceRecord.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            try {
                this.stmtSaveNewInputRecord.close();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                this.stmtSaveNewOutputRecord.close();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                this.stmtSaveNewPinRecord.close();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                this.dbConnection.close();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.isConnected = false;
        }
    }

    public String getDatabaseLocation() {
        String dbLocation = this.dbSystemLocation + "/" + this.dbName;
        return dbLocation;
    }

    public String getDatabaseUrl() {
        String dbUrl = "jdbc:derby:" + this.dbName;
        return dbUrl;
    }

    public int saveDeviceRecord(GenericNode device) {
        int id = -1;
        if (!this.isEnabled || !this.isConnected) {
            return -1;
        }
        try {
            this.stmtSaveNewDeviceRecord.clearParameters();
            this.stmtSaveNewDeviceRecord.setInt(1, device.getAddressList().get(0));
            this.stmtSaveNewDeviceRecord.setString(2, device.getComment());
            this.stmtSaveNewDeviceRecord.setInt(3, device.getNofInputPins());
            this.stmtSaveNewDeviceRecord.setInt(4, device.getNofOutputPins());
            this.stmtSaveNewDeviceRecord.executeUpdate();
            ResultSet results = this.stmtSaveNewDeviceRecord.getGeneratedKeys();
            if (results.next()) {
                id = results.getInt(1);
            }
            List<AFOPin> pinList = device.getPinList();
            for (AFOPin pin : pinList) {
                this.stmtSaveNewPinRecord.clearParameters();
                this.stmtSaveNewPinRecord.setInt(1, device.getAddressList().get(0));
                this.stmtSaveNewPinRecord.setString(2, pin.getPinIDString());
                this.stmtSaveNewPinRecord.setString(3, pin.getLabel());
                this.stmtSaveNewPinRecord.executeUpdate();
                results = this.stmtSaveNewPinRecord.getGeneratedKeys();
                if (!results.next()) continue;
                id = results.getInt(1);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return id;
    }

    public boolean existsDevice(int address) {
        boolean exists = false;
        if (!this.isEnabled) {
            return true;
        }
        try {
            String query = "SELECT * FROM APP.DEVICES WHERE ADDRESS=" + Integer.toString(address);
            Statement st = this.dbConnection.createStatement();
            ResultSet results = null;
            results = st.executeQuery(query);
            exists = results.next();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return exists;
    }

    public int saveSingleDataEntryRecord(SingleValDataEntry data, int tableIdx) {
        int id = -1;
        try {
            PreparedStatement st = null;
            if (tableIdx == 2) {
                st = this.stmtSaveNewInputRecord;
            } else if (tableIdx == 3) {
                st = this.stmtSaveNewOutputRecord;
            }
            if (st == null) {
                return -1;
            }
            st.clearParameters();
            st.setInt(1, data.getAddress());
            st.setString(2, data.getPinID());
            st.setTimestamp(3, data.getTimestamp());
            st.setFloat(4, data.getValue());
            st.executeUpdate();
            ResultSet results = st.getGeneratedKeys();
            if (results.next()) {
                id = results.getInt(1);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return id;
    }

    public boolean cleanDBData() {
        boolean bCleaned = false;
        try {
            for (int i = 1; i < strTableNames.length; ++i) {
                String command = "DELETE FROM APP." + strTableNames[i];
                Statement st = this.dbConnection.createStatement();
                st.executeUpdate(command);
            }
            bCleaned = true;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return bCleaned;
    }

    public boolean deleteRecord(int id, String tableName) {
        boolean bDeleted = false;
        try {
            String command = "DELETE FROM APP." + tableName + strDeleteSingleValSuffix + Integer.toString(id);
            Statement st = this.dbConnection.createStatement();
            st.executeUpdate(command);
            bDeleted = true;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return bDeleted;
    }

    public List<SingleValDataEntry> getTableDataByAddressLabelAndTime(int address, String pinID, int tableIdx, TimeDiscretization interval) {
        ArrayList<SingleValDataEntry> listEntries = new ArrayList<SingleValDataEntry>();
        Statement queryStatement = null;
        ResultSet results = null;
        Timestamp lastTimeStamp = new Timestamp(0L);
        String strTimeInterval = "YEAR(TIME), MONTH(TIME), DAY(TIME), HOUR(TIME), MINUTE(TIME), SECOND(TIME), ";
        switch (interval) {
            case SECOND: {
                strTimeInterval = "YEAR(TIME), MONTH(TIME), DAY(TIME),HOUR(TIME), MINUTE(TIME), SECOND(TIME), ";
                break;
            }
            case MINUTE: {
                strTimeInterval = "YEAR(TIME), MONTH(TIME), DAY(TIME), HOUR(TIME), MINUTE(TIME), ";
                break;
            }
            case HOUR: {
                strTimeInterval = "YEAR(TIME), MONTH(TIME), DAY(TIME), HOUR(TIME), ";
                break;
            }
            case DAY: {
                strTimeInterval = "YEAR(TIME), MONTH(TIME), DAY(TIME),";
            }
        }
        try {
            String query = "SELECT DISTINCT " + strTimeInterval + " VALUE" + " FROM APP." + strTableNames[tableIdx] + " WHERE ADDRESS = " + Integer.toString(address) + " AND IO_ID = '" + pinID + "' ";
            queryStatement = this.dbConnection.createStatement();
            results = queryStatement.executeQuery(query);
            while (results.next()) {
                String strTime = "1970-01-01 00:00:00.0";
                Formatter fmt = new Formatter();
                switch (interval) {
                    case SECOND: {
                        fmt.format("%4d-%02d-%02d %02d:%02d:%02d.%09d", results.getInt(1), results.getInt(2), results.getInt(3), results.getInt(4), results.getInt(5), results.getInt(6), 0);
                        strTime = fmt.toString();
                        break;
                    }
                    case MINUTE: {
                        fmt.format("%4d-%02d-%02d %02d:%02d:%02d.%09d", results.getInt(1), results.getInt(2), results.getInt(3), results.getInt(4), results.getInt(5), 0, 0);
                        strTime = fmt.toString();
                        break;
                    }
                    case HOUR: {
                        fmt.format("%4d-%02d-%02d %02d:%02d:%02d.%09d", results.getInt(1), results.getInt(2), results.getInt(3), results.getInt(4), 0, 0, 0);
                        strTime = fmt.toString();
                        break;
                    }
                    case DAY: {
                        fmt.format("%4d-%02d-%02d %02d:%02d:%02d.%09d", results.getInt(1), results.getInt(2), results.getInt(3), 0, 0, 0, 0);
                        strTime = fmt.toString();
                    }
                }
                Timestamp timeStamp = Timestamp.valueOf(strTime);
                if (timeStamp.equals(lastTimeStamp)) continue;
                lastTimeStamp = timeStamp;
                float value = results.getFloat("VALUE");
                SingleValDataEntry entry = new SingleValDataEntry(0, address, pinID, "", timeStamp, value);
                listEntries.add(entry);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return listEntries;
    }

    public List<DeviceData> getDevicesList() {
        ArrayList<DeviceData> listEntries = new ArrayList<DeviceData>();
        Statement queryStatement = null;
        ResultSet results = null;
        try {
            this.connect();
            String query = strGetDevicesAndPins;
            queryStatement = this.dbConnection.createStatement();
            results = queryStatement.executeQuery(query);
            while (results.next()) {
                int id = 0;
                int address = results.getInt(1);
                String comment = results.getString(2);
                String pinID = results.getString(3);
                String pinLabel = results.getString(4);
                DeviceData entry = new DeviceData(id, address, comment, pinID, pinLabel);
                listEntries.add(entry);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return listEntries;
    }

    public List<String> getUniqueDataLabels(int address, String pinID, int tableIndex) {
        ArrayList<String> listEntries = new ArrayList<String>();
        Statement queryStatement = null;
        ResultSet results = null;
        try {
            this.connect();
            String query = "SELECT DISTINCT IO_ID FROM APP." + strTableNames[tableIndex] + " WHERE ADDRESS=" + Integer.toString(address);
            queryStatement = this.dbConnection.createStatement();
            results = queryStatement.executeQuery(query);
            while (results.next()) {
                String label = results.getString(1);
                listEntries.add(label);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return listEntries;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public static enum TimeDiscretization {
        SECOND,
        MINUTE,
        HOUR,
        DAY;

    }
}

