/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import Util.GenericProgressDialog;
import VisiProg.AppOptions;
import VisiProg.ConfigFileView;
import VisiProg.NewProjectDialog;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.ProgramDownloader;
import connection.ProgramUploader;
import connection.SerialKernel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import nodes.AFOScenePopup;
import nodes.AFOSystemManager;
import nodes.AfoDBDao;
import nodes.BoardsTypesAndDescription;
import nodes.ComPort;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.ProjectEvent;
import nodes.ProjectEventListener;
import nodes.SceneSerializer;
import nodes.devices.AfoTimer;
import nodes.devices.ClimaticCurveNode;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.devices.LoggerNode;
import nodes.devices.ModbusStation;
import nodes.devices.MonitorNode;
import nodes.devices.MonitorNode_2;
import nodes.gui.ProjectDialog;
import org.jfree.ui.RefineryUtilities;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFONode;
import sceneManager.AFOPin;
import sceneManager.SceneEvent;
import sceneManager.SceneEventListener;

public class Project
implements ChangeListener,
IKernelEventListener,
SceneEventListener,
ProjectEventListener,
PropertyChangeListener {
    public static final int MAX_NUM_BLOCKS_MPID9 = 200;
    public static final int MAX_NUM_CLOCKS_MPID9 = 5;
    public static final int MAX_NUM_BLOCKS_MPID3 = 200;
    public static final int MAX_NUM_BLOCKS_MPID1_2 = 110;
    public static final int MAX_NUM_CLOCKS_MPID = 2;
    private BoardsTypesAndDescription.BoardType boardType;
    private int programHash = 0;
    private String boardAddress = "1";
    private List<String> outMsgList = new ArrayList<String>();
    private AFOSystemManager mainSystem;
    private List<AFOSystemManager> subSystemsList = new ArrayList<AFOSystemManager>();
    private List<AfoTimer> timerList = new ArrayList<AfoTimer>();
    public boolean projectDirty = false;
    private boolean isActiveProject;
    public String projectFolder;
    private String projectName;
    private long nextSubSystemID = 0L;
    private ProjectDialog myDialog;
    private AFOScenePopup scene;
    private JTabbedPane myTabbedPane;
    public int lastTabSelected = 0;
    private IKernel kernel;
    private ComPort[] portList = new ComPort[3];
    private boolean waitingForAnswer = false;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();
    public boolean projectIsLoading = false;
    public NewProjectDialog dlg;
    public final String virgola = ",";
    private AfoDBDao projectDB;
    GenericProgressDialog pf = new GenericProgressDialog(null, false);
    SubSystemImporter subImporter;
    protected EventListenerList listenerList = new EventListenerList();

    public Project() {
        this.boardType = SceneSerializer.getTypeSerialized();
        this.mainSystem = new AFOSystemManager(this, this.boardType);
        this.mainSystem.getSubSystemScene().addSceneEventListener(this);
        this.portList[0] = new ComPort();
        this.portList[1] = new ComPort();
        this.portList[2] = new ComPort();
        this.myDialog = new ProjectDialog(this, this.getPortList());
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.addEventListener(this);
    }

    public AFOSystemManager getSystemManager() {
        return this.mainSystem;
    }

    public void calcHash() {
        this.programHash = (int)(Math.random() * 1000000.0);
    }

    public int getHash() {
        return this.programHash;
    }

    private int countNodes(List<AFONode> nodes) {
        int cont = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i).getBlockType().equals((Object)CommonDefinitions.blockTypes.IN) || nodes.get(i).getBlockType().equals((Object)CommonDefinitions.blockTypes.OUT) || nodes.get(i).getBlockType().equals((Object)CommonDefinitions.blockTypes.Subsystem)) continue;
            ++cont;
        }
        return cont;
    }

    public int getNofBlocks() {
        int nOfBlocks = 0;
        for (AFONode nd : this.mainSystem.getNodeList()) {
            if (nd.getBlockType().ordinal() < CommonDefinitions.blockTypes.Monitor.ordinal() || nd.getBlockType() == CommonDefinitions.blockTypes.Scope || nd.getBlockType() == CommonDefinitions.blockTypes.Comment || nd.getBlockType() == CommonDefinitions.blockTypes.IN || nd.getBlockType() == CommonDefinitions.blockTypes.OUT || nd.getBlockType() == CommonDefinitions.blockTypes.Subsystem) continue;
            ++nOfBlocks;
        }
        for (AFOSystemManager mngr : this.subSystemsList) {
            nOfBlocks += this.countNodes(mngr.getNodeList());
        }
        return nOfBlocks;
    }

    public void disconnectDB() {
        this.projectDB.disconnect();
    }

    public boolean connectDB() {
        try {
            if (!this.projectDB.isConnected()) {
                this.projectDB.connect();
                this.projectDB.enableDB(true);
                return true;
            }
            return true;
        }
        catch (Exception ex) {
            this.projectDB.enableDB(false);
            ex.printStackTrace();
            return false;
        }
    }

    public int getMaxNumBlocks() {
        if (this.boardType.ordinal() <= BoardsTypesAndDescription.BoardType.mPID6ST.ordinal()) {
            return 200;
        }
        if (this.boardType.ordinal() >= BoardsTypesAndDescription.BoardType.mPID3ST.ordinal()) {
            return 200;
        }
        return 110;
    }

    public Project(String projectName, String projectFolder, BoardsTypesAndDescription.BoardType type) {
        this.projectName = projectName;
        this.projectFolder = projectFolder;
        this.boardType = type;
        if (!this.projectFolder.endsWith(File.separator)) {
            this.projectFolder = this.projectFolder + File.separator;
        }
        this.mainSystem = new AFOSystemManager(this, this.boardType);
        this.portList[0] = new ComPort();
        this.portList[1] = new ComPort();
        this.portList[2] = new ComPort();
        this.setupDefaultPorts();
        this.myDialog = new ProjectDialog(this, this.getPortList());
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        String dbPath = projectFolder;
        if (!dbPath.endsWith(File.separator)) {
            dbPath = dbPath + File.separator;
        }
        dbPath = dbPath + "db" + File.separator;
        this.projectDB = new AfoDBDao(projectName, dbPath);
        this.addEventListener(this);
    }

    public AfoDBDao getProjectDB() {
        return this.projectDB;
    }

    public void setupDefaultPorts() {
        this.portList[0].enabled = true;
        this.portList[0].typeOfProtocol = "AFO";
        this.portList[0].serSpeed = "115200";
        this.portList[0].serParity = "NONE";
        this.portList[0].serStopBits = "1";
        this.portList[0].serNumbits = "8";
        this.portList[1].enabled = false;
        this.portList[1].serSpeed = "19200";
        this.portList[1].serParity = "NONE";
        this.portList[1].serStopBits = "1";
        this.portList[1].serNumbits = "8";
        this.portList[1].typeOfProtocol = "MB RTU Master";
        this.portList[2].enabled = false;
    }

    public void addSubSystem(Point point) {
        this.addSubSystem(point, null);
        this.projectDirty = true;
    }

    public void addSubSystem(Point point, String id) {
        this.projectDirty = true;
        if (id == null) {
            id = new String();
            id = Long.toString(this.nextSubSystemID++);
        } else if (Long.parseLong(id) >= this.nextSubSystemID) {
            this.nextSubSystemID = Long.parseLong(id) + 1L;
        }
        AFOSystemManager node = new AFOSystemManager(this, id, "SubSystem", this.mainSystem.getSubSystemScene());
        this.mainSystem.getSubSystemScene().validate();
        node.getWidget().setPreferredLocation(point);
        node.getSubSystemScene().addSceneEventListener(this);
        node.setParentSystem(this.mainSystem);
        node.setParentNode(node);
        this.mainSystem.addNode(node, false);
        this.subSystemsList.add(node);
    }

    public void addSubSystem(AFOSystemManager parent, AFOSystemManager system) {
        this.projectDirty = true;
        parent.getSubSystemScene().addNode(system);
        parent.getSubSystemScene().revalidate();
        parent.getSubSystemScene().validate();
        system.getWidget().setPreferredLocation(system.getWidget().getLocation());
        system.getSubSystemScene().addSceneEventListener(this);
        system.setParentSystem(parent);
        system.setParentNode(parent);
        parent.addNode(system, true);
        this.subSystemsList.add(system);
    }

    public void addSubSystem(AFOSystemManager parent, Point point, String id) {
        this.projectDirty = true;
        if (id == null) {
            id = new String();
            id = Long.toString(this.nextSubSystemID++);
        } else if (Long.parseLong(id) >= this.nextSubSystemID) {
            this.nextSubSystemID = Long.parseLong(id) + 1L;
        }
        AFOSystemManager node = new AFOSystemManager(this, id, "SubSystem", parent.getSubSystemScene());
        parent.getSubSystemScene().validate();
        node.getWidget().setPreferredLocation(point);
        node.getSubSystemScene().addSceneEventListener(this);
        node.setParentSystem(parent);
        node.setParentNode(node);
        parent.addNode(node, false);
        this.subSystemsList.add(node);
    }

    public boolean connect(IKernelEventListener listener) {
        try {
            this.saveProject();
            this.createKernel();
            if (listener != null) {
                this.kernel.addKernelEventListener(listener);
            }
            this.getKernel().connect();
            return true;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            JOptionPane.showMessageDialog(null, this.message.getString("err") + ex.toString(), this.message.getString("er"), 0);
            return false;
        }
    }

    public void disconnect() {
        try {
            this.getKernel().disconnect();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            JOptionPane.showMessageDialog(null, this.message.getString("err") + ex.toString(), this.message.getString("er"), 0);
        }
    }

    public void stopEngine() {
        this.outMsgList.clear();
        this.outMsgList.add("<BL stop >");
        this.outMsgList.add("<BL get 0 >");
        this.sendMessageList();
    }

    public void startEngine() {
        this.outMsgList.clear();
        this.outMsgList.add("<BL start >");
        this.outMsgList.add("<BL get 0 >");
        this.sendMessageList();
    }

    public void openProject() {
    }

    public void closeProject() {
        if (this.projectDirty) {
            Object[] options2 = new Object[]{this.message.getString("yes"), this.message.getString("no")};
            if (JOptionPane.showOptionDialog(null, this.message.getString("save"), this.message.getString("att"), 0, 2, null, options2, options2[0]) == 0) {
                this.saveProject();
            }
        }
        try {
            if (this.getKernel() != null && this.getKernel().isConnected()) {
                this.disconnect();
            }
        }
        catch (Exception ex) {
            System.out.println(this.message.getString("errkern"));
            ex.printStackTrace();
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Project.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static boolean deleteFilesByExtension(File path, String extension) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(extension)) continue;
                files[i].delete();
            }
        }
        return true;
    }

    public void saveProject() {
        String title;
        int num;
        AfoTimer tmr;
        if (this.getTabbedPane().getSelectedIndex() > 0 && (tmr = this.getTimerbyID(num = Integer.parseInt((title = this.getTabbedPane().getTitleAt(this.getTabbedPane().getSelectedIndex())).substring(6)))).isTimerDirty()) {
            Object[] options3 = new Object[]{this.message.getString("yes"), this.message.getString("no")};
            if (JOptionPane.showOptionDialog(null, this.message.getString("savetimer"), this.message.getString("att"), 0, 2, null, options3, options3[0]) == 0 && tmr != null) {
                tmr.getTimerPanelData();
            }
        }
        File file = new File(this.getProjectFolder() + this.getProjectName());
        Project.deleteFilesByExtension(new File(this.getProjectFolder()), ".prj");
        Project.deleteFilesByExtension(new File(this.getProjectFolder()), ".sub");
        if (this.projectDirty) {
            this.calcHash();
        }
        SceneSerializer.subSystemNumber = 1;
        SceneSerializer.serialize(this, this.getMainScene(), file, false);
    }

    public void regenerateClimaticIDs() {
        for (AFOSystemManager sm : this.subSystemsList) {
            for (AFONode node : sm.getNodeList()) {
                if (node.getBlockType() != CommonDefinitions.blockTypes.ClimaticCurve) continue;
                ((ClimaticCurveNode)node).setClimateID(0);
            }
        }
        for (AFOSystemManager sm : this.subSystemsList) {
            for (AFONode node : sm.getNodeList()) {
                if (node.getBlockType() != CommonDefinitions.blockTypes.ClimaticCurve) continue;
                ((ClimaticCurveNode)node).calculateClimaticID();
            }
        }
    }

    public void showDialog() {
        this.myDialog.txtIPAddress.setText(this.portList[2].ipAddress);
        BoardsTypesAndDescription.BoardType type = this.getBoardType();
        System.out.println((Object)type);
        this.getDialog().showDialog(null);
        this.boardAddress = this.myDialog.spnNewBoardAddress.getValue().toString();
        if (this.myDialog.comboPort.getSelectedIndex() == 0) {
            this.portList[2].ipAddress = this.myDialog.txtIPAddress.getText();
        }
    }

    public long getNextSubSystemID() {
        return this.nextSubSystemID;
    }

    public void setNextSubSystemID(long nextSubSystemID) {
        this.nextSubSystemID = nextSubSystemID;
    }

    public String getProjectFolder() {
        return this.projectFolder;
    }

    public void setProjectFolder(String projectFolder) {
        this.projectFolder = projectFolder;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void createProjectDB() {
        this.projectDB = new AfoDBDao(this.projectName, this.projectFolder + "db/");
    }

    public MyGraphPinScene getMainScene() {
        return this.mainSystem.getSubSystemScene();
    }

    public JComponent getAfoView() {
        return this.mainSystem.getAfoView();
    }

    public AFOSystemManager getMainSystem() {
        return this.mainSystem;
    }

    public void setSystemManager(AFOSystemManager systemManager) {
        this.mainSystem = systemManager;
    }

    public boolean isActiveProject() {
        return this.isActiveProject;
    }

    public void setAsActiveProject(boolean isActiveProject) {
        this.isActiveProject = isActiveProject;
    }

    public List<AFOSystemManager> getSubSystemList() {
        return this.subSystemsList;
    }

    public boolean createAddressFile(boolean showFileOnExit) {
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        try {
            JFileChooser chooser = new JFileChooser();
            UIManager.put("FileChooser.openButtonText", this.message.getString("openbutton"));
            UIManager.put("FileChooser.cancelButtonText", this.message.getString("cancelbutton"));
            UIManager.put("FileChooser.saveButtonText", this.message.getString("savebutton"));
            UIManager.put("FileChooser.filesOfTypeLabelText", this.message.getString("tipobutton"));
            UIManager.put("FileChooser.fileNameLabelText", this.message.getString("nomefilebutton"));
            UIManager.put("FileChooser.lookInLabelText", this.message.getString("guardainbutton"));
            UIManager.put("FileChooser.cancelButtonToolTipText", this.message.getString("cancelbuttontooltip"));
            SwingUtilities.updateComponentTreeUI(chooser);
            chooser.setApproveButtonText(this.message.getString("sal"));
            chooser.setDialogTitle(this.message.getString("salvac"));
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.options.lastOpenDir));
            chooser.setVisible(true);
            if (chooser.showSaveDialog(null) == 0) {
                boolean exists;
                File f = chooser.getSelectedFile();
                String nameOfFile = "";
                nameOfFile = f.getPath();
                if (!nameOfFile.endsWith(".csv")) {
                    nameOfFile = nameOfFile + ".csv";
                }
                if (exists = new File(nameOfFile).exists()) {
                    Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
                    if (JOptionPane.showOptionDialog(null, this.message.getString("sovrascr"), this.message.getString("att"), 0, 2, null, myOptions, myOptions[0]) == 1) {
                        return true;
                    }
                }
                File addressFile = new File(nameOfFile);
                FileWriter iniWriter = new FileWriter(addressFile);
                String blockStr = "";
                Iterator<AFOSystemManager> subSystemIt = this.subSystemsList.iterator();
                for (AFONode nm : this.mainSystem.getNodeList()) {
                    if (nm instanceof AFOSystemManager) {
                        AFOSystemManager nodeManager = (AFOSystemManager)nm;
                        int nOfBlocks = 0;
                        nOfBlocks = nodeManager.createAddressBlocks(nOfBlocks, iniWriter);
                        continue;
                    }
                    if (!(nm instanceof DeviceNode)) continue;
                    DeviceNode dn = (DeviceNode)nm;
                    for (int i = 0; i < dn.getAddressSpace(); ++i) {
                        blockStr = dn.getBlockType().toString();
                        blockStr = blockStr + this.options.separator;
                        blockStr = blockStr + dn.getComment();
                        blockStr = blockStr + this.options.separator;
                        blockStr = blockStr + (dn.getAddressList().get(0) + i);
                        blockStr = blockStr + "\r\n";
                        iniWriter.write(blockStr);
                    }
                }
                iniWriter.flush();
                iniWriter.close();
                if (showFileOnExit) {
                    ConfigFileView cf = new ConfigFileView(nameOfFile);
                    cf.setVisible(true);
                    cf.toFront();
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            JOptionPane.showMessageDialog(null, this.message.getString("addressfile"), this.message.getString("info"), 0);
            return false;
        }
        return true;
    }

    public boolean createMoviconFile(boolean showFileOnExit) {
        block17: {
            this.options.LoadOptions();
            this.currentLocale = new Locale(this.options.language, this.options.country);
            this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
            try {
                boolean exists;
                JFileChooser chooser = new JFileChooser();
                UIManager.put("FileChooser.openButtonText", this.message.getString("openbutton"));
                UIManager.put("FileChooser.cancelButtonText", this.message.getString("cancelbutton"));
                UIManager.put("FileChooser.saveButtonText", this.message.getString("savebutton"));
                UIManager.put("FileChooser.filesOfTypeLabelText", this.message.getString("tipobutton"));
                UIManager.put("FileChooser.fileNameLabelText", this.message.getString("nomefilebutton"));
                UIManager.put("FileChooser.lookInLabelText", this.message.getString("guardainbutton"));
                UIManager.put("FileChooser.cancelButtonToolTipText", this.message.getString("cancelbuttontooltip"));
                SwingUtilities.updateComponentTreeUI(chooser);
                chooser.setApproveButtonText(this.message.getString("sal"));
                chooser.setDialogTitle(this.message.getString("salvac"));
                chooser.setMultiSelectionEnabled(false);
                chooser.setCurrentDirectory(new File(this.options.lastOpenDir));
                chooser.setVisible(true);
                if (chooser.showSaveDialog(null) != 0) break block17;
                File f = chooser.getSelectedFile();
                String nameOfFile = "";
                nameOfFile = f.getPath();
                if (!nameOfFile.endsWith(".csv")) {
                    nameOfFile = nameOfFile + ".csv";
                }
                if (exists = new File(nameOfFile).exists()) {
                    Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
                    if (JOptionPane.showOptionDialog(null, this.message.getString("sovrascr"), this.message.getString("att"), 0, 2, null, myOptions, myOptions[0]) == 1) {
                        return true;
                    }
                }
                File addressFile = new File(nameOfFile);
                FileWriter iniWriter = new FileWriter(addressFile);
                String blockStr = "";
                for (AFONode nm : this.mainSystem.getNodeList()) {
                    int i;
                    DeviceNode dn;
                    if (nm instanceof AFOSystemManager) {
                        AFOSystemManager nodeManager = (AFOSystemManager)nm;
                        int nOfBlocks = 0;
                        nOfBlocks = nodeManager.createMoviconBlocks(nOfBlocks, iniWriter);
                        continue;
                    }
                    if (!(nm instanceof DeviceNode) || (dn = (DeviceNode)nm).getAddressSpace() == 1) continue;
                    if (dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.ModbusIN) || dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.ModbusOUT)) {
                        for (i = 1; i < dn.getAddressList().size(); ++i) {
                            blockStr = dn.getList().get(i) + "_" + dn.getAddressList().get(i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "HR" + dn.getAddressList().get(i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "WORD";
                            blockStr = blockStr + ",";
                            blockStr = blockStr + (Object)((Object)dn.getBlockType()) + " " + dn.getComment();
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "\r\n";
                            iniWriter.write(blockStr);
                            blockStr = "";
                        }
                        continue;
                    }
                    if (dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.Monitor)) {
                        for (i = 1; i < dn.getAddressSpace(); ++i) {
                            blockStr = dn.getList().get(i) + "_" + (dn.getAddressList().get(0) + i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "HR" + (dn.getAddressList().get(0) + i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "WORD";
                            blockStr = blockStr + ",";
                            blockStr = blockStr + (Object)((Object)dn.getBlockType()) + " " + dn.getComment();
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "\r\n";
                            iniWriter.write(blockStr);
                            blockStr = "";
                        }
                        continue;
                    }
                    if (dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.Monitor_2)) {
                        for (i = 2; i < dn.getAddressSpace(); ++i) {
                            blockStr = blockStr + dn.getList().get(i) + "_" + (dn.getAddressList().get(0) + i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "HR" + (dn.getAddressList().get(0) + i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "WORD";
                            blockStr = blockStr + ",";
                            blockStr = blockStr + (Object)((Object)dn.getBlockType()) + " " + dn.getComment();
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "\r\n";
                            iniWriter.write(blockStr);
                            blockStr = "";
                        }
                        continue;
                    }
                    if (dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.Pt100) || dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.NTC) || dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.TempHumi) || dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.Rit) || dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.Button) || dn.getBlockType().equals((Object)CommonDefinitions.blockTypes.DipSwitch)) {
                        for (i = 1; i < dn.getAddressList().size(); ++i) {
                            blockStr = blockStr + dn.getList().get(i) + "_" + dn.getAddressList().get(i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "HR" + dn.getAddressList().get(i);
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "WORD";
                            blockStr = blockStr + ",";
                            blockStr = blockStr + (Object)((Object)dn.getBlockType()) + " " + dn.getComment();
                            blockStr = blockStr + ",";
                            blockStr = blockStr + "\r\n";
                            iniWriter.write(blockStr);
                            blockStr = "";
                        }
                        continue;
                    }
                    for (i = 1; i < dn.getAddressList().size(); ++i) {
                        blockStr = dn.getDeviceID() + "_" + dn.getAddressList().get(i);
                        blockStr = blockStr + ",";
                        blockStr = blockStr + "HR" + dn.getAddressList().get(i);
                        blockStr = blockStr + ",";
                        blockStr = blockStr + "WORD";
                        blockStr = blockStr + ",";
                        blockStr = blockStr + (Object)((Object)dn.getBlockType()) + " " + dn.getComment();
                        blockStr = blockStr + ",";
                        blockStr = blockStr + "\r\n";
                        iniWriter.write(blockStr);
                        blockStr = "";
                    }
                }
                iniWriter.flush();
                iniWriter.close();
                if (showFileOnExit) {
                    ConfigFileView cf = new ConfigFileView(nameOfFile);
                    cf.setVisible(true);
                    cf.toFront();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                JOptionPane.showMessageDialog(null, this.message.getString("addressfile"), this.message.getString("info"), 0);
                return false;
            }
        }
        return true;
    }

    public boolean createConfigFile() {
        try {
            File configFile = new File(this.projectFolder + "config.txt");
            for (AFOSystemManager ssManager : this.subSystemsList) {
                boolean nodesSwapped = false;
                int iterationLimit = 100000;
                do {
                    ArrayList swapNodeList = (ArrayList)ssManager.getNodeList();
                    Iterator<AFONode> nodeIt = ssManager.getNodeList().iterator();
                    nodesSwapped = false;
                    while (nodeIt.hasNext()) {
                        AFONode nodeExamined = nodeIt.next();
                        for (AFOPin pinExamined : nodeExamined.getPinList()) {
                            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_INPUT || ssManager.getSubSystemScene().findPinEdges(pinExamined, false, true).size() <= 0) continue;
                            AFOEdge edge = (AFOEdge)ssManager.getSubSystemScene().findPinEdges(pinExamined, false, true).toArray()[0];
                            AFOPin sourcePin = (AFOPin)ssManager.getSubSystemScene().getEdgeSource(edge);
                            AFONode sourceNode = (AFONode)ssManager.getSubSystemScene().getPinNode(sourcePin);
                            if (sourceNode.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN)) continue;
                            int sourceNodeIdx = swapNodeList.indexOf(sourceNode);
                            int examNodeIdx = swapNodeList.indexOf(nodeExamined);
                            if (examNodeIdx >= sourceNodeIdx) continue;
                            swapNodeList.set(examNodeIdx, sourceNode);
                            swapNodeList.set(sourceNodeIdx, nodeExamined);
                            nodesSwapped = true;
                        }
                    }
                    ssManager.setNodeList(swapNodeList);
                } while (nodesSwapped && --iterationLimit > 0);
                if (iterationLimit != 0) continue;
                JOptionPane.showMessageDialog(null, this.message.getString("sottloop") + ssManager.getComment() + this.message.getString("loop"), this.message.getString("er"), 0);
            }
            String blockStr = "";
            Iterator<AFOSystemManager> subSystemIt = this.subSystemsList.iterator();
            boolean subSystemNumber = true;
            Iterator<AFONode> nodeManagerIt = this.mainSystem.getNodeList().iterator();
            if (!configFile.exists()) {
                configFile.createNewFile();
            } else {
                configFile.delete();
                configFile.createNewFile();
            }
            FileWriter iniWriter = new FileWriter(configFile);
            iniWriter.write("<BL stop >\r\n");
            iniWriter.write("<BL rem all >\r\n");
            iniWriter.write("<BL tmr 0 rem >\r\n");
            boolean hasDisplayNode = false;
            while (nodeManagerIt.hasNext()) {
                boolean connected;
                AFONode nm = nodeManagerIt.next();
                if (nm instanceof AFOSystemManager) {
                    AFOSystemManager nodeManager = (AFOSystemManager)nm;
                    int nOfBlocks = 0;
                    nOfBlocks = nodeManager.createConfigBlocks(nOfBlocks, iniWriter);
                    continue;
                }
                if (!(nm instanceof DeviceNode) || !(connected = true)) continue;
                DeviceNode dn = (DeviceNode)nm;
                blockStr = "<BL add ";
                blockStr = blockStr + dn.getConfigString(0);
                blockStr = blockStr + " >\r\n";
                iniWriter.write(blockStr);
                if (dn instanceof MonitorNode) {
                    hasDisplayNode = true;
                    blockStr = ((MonitorNode)dn).getVarConfiguration();
                    iniWriter.write(blockStr);
                    continue;
                }
                if (dn instanceof MonitorNode_2) {
                    blockStr = ((MonitorNode_2)dn).getVarConfiguration();
                    iniWriter.write(blockStr);
                    continue;
                }
                if (dn instanceof ModbusStation) {
                    blockStr = ((ModbusStation)dn).getVarConfiguration();
                    iniWriter.write(blockStr);
                    continue;
                }
                if (!(dn instanceof LoggerNode)) continue;
                blockStr = ((LoggerNode)dn).getVarConfiguration();
                iniWriter.write(blockStr);
            }
            iniWriter.write("<BL tmr 0 rem >\r\n");
            for (AfoTimer tmr : this.timerList) {
                String config = "<BL tmr " + tmr.getTimerID() + " add >\r\n";
                config = config + tmr.getConfiguration();
                iniWriter.write(config);
            }
            iniWriter.write("<BL save >\r\n");
            iniWriter.write("<BL set 0 " + this.getHash() + ">\r\n");
            iniWriter.write("<BL start >\r\n");
            iniWriter.write("<RESET >\r\n");
            iniWriter.flush();
            iniWriter.close();
            return true;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            JOptionPane.showMessageDialog(null, this.message.getString("confignotwritten"), this.message.getString("info"), 0);
            return false;
        }
    }

    void serialize(Document document, Element commonProperties) {
        SceneSerializer.setAttribute(document, commonProperties, "ProjectName", this.projectName);
        SceneSerializer.setAttribute(document, commonProperties, "ProjectHash", "" + this.programHash);
        SceneSerializer.setAttribute(document, commonProperties, "BoardAddress", this.getBoardAddress());
        SceneSerializer.setAttribute(document, commonProperties, "IPAddress", this.getDialog().txtIPAddress.getText());
        SceneSerializer.setAttribute(document, commonProperties, "IPPort", this.getDialog().txtIPPort.getText());
        SceneSerializer.setAttribute(document, commonProperties, "COMPort", this.getDialog().comboPort.getSelectedItem().toString());
        SceneSerializer.setAttribute(document, commonProperties, "COMPortSpeed", "" + this.getDialog().comboPortSpeed.getSelectedIndex());
        if (this.boardType != null) {
            SceneSerializer.setAttribute(document, commonProperties, "BoardType", this.boardType.toString());
        }
        for (int i = 0; i < 3; ++i) {
            Element portNode = document.createElement("Port");
            SceneSerializer.setAttribute(document, portNode, "id", new Integer(i).toString());
            SceneSerializer.setAttribute(document, portNode, "enabled", "" + this.getPortList()[i].enabled);
            SceneSerializer.setAttribute(document, portNode, "type", this.getPortList()[i].typeOfPort);
            SceneSerializer.setAttribute(document, portNode, "protocol", this.getPortList()[i].typeOfProtocol);
            Element generic = document.createElement("SerPort");
            SceneSerializer.setAttribute(document, generic, "serSpeed", this.getPortList()[i].serSpeed);
            SceneSerializer.setAttribute(document, generic, "serNumBits", this.getPortList()[i].serNumbits);
            SceneSerializer.setAttribute(document, generic, "serParity", this.getPortList()[i].serParity);
            SceneSerializer.setAttribute(document, generic, "serStopBit", this.getPortList()[i].serStopBits);
            portNode.appendChild(generic);
            generic = document.createElement("Ethernet");
            SceneSerializer.setAttribute(document, generic, "ipAddr", this.getPortList()[i].ipAddress);
            SceneSerializer.setAttribute(document, generic, "ipPort", this.getPortList()[i].ipPort);
            SceneSerializer.setAttribute(document, generic, "ipGW", this.getPortList()[i].ipGateway);
            SceneSerializer.setAttribute(document, generic, "ipSubnet", this.getPortList()[i].ipSubnet);
            SceneSerializer.setAttribute(document, generic, "ipMAC", this.getPortList()[i].ipMac);
            portNode.appendChild(generic);
            commonProperties.appendChild(portNode);
        }
    }

    public void deserialize(Node node) throws Exception {
        try {
            this.programHash = Integer.parseInt(SceneSerializer.getAttributeValue(node, "ProjectHash"));
            this.boardAddress = SceneSerializer.getAttributeValue(node, "BoardAddress");
            this.getDialog().txtIPAddress.setText(SceneSerializer.getAttributeValue(node, "IPAddress"));
            this.getDialog().txtIPPort.setText(SceneSerializer.getAttributeValue(node, "IPPort"));
            this.getDialog().comboPort.setSelectedItem(SceneSerializer.getAttributeValue(node, "COMPort"));
            int index = Integer.parseInt(SceneSerializer.getAttributeValue(node, "COMPortSpeed"));
            this.getDialog().comboPortSpeed.setSelectedIndex(index);
            this.getDialog().spnNewBoardAddress.setValue(Integer.parseInt(this.boardAddress));
            String brdType = SceneSerializer.getAttributeValue(node, "BoardType");
            if (brdType == null) {
                this.boardType = BoardsTypesAndDescription.BoardType.mPID9MX;
            } else {
                for (BoardsTypesAndDescription.BoardType boardType : BoardsTypesAndDescription.BoardType.values()) {
                    if (!boardType.toString().equals(brdType)) continue;
                    this.boardType = boardType;
                    break;
                }
            }
            if (this.boardType == null) {
                this.boardType = BoardsTypesAndDescription.BoardType.mPID9MX;
            }
            for (Node node2 : SceneSerializer.getChildNode(node)) {
                if (!node2.getNodeName().equals("Port")) continue;
                index = Integer.parseInt(SceneSerializer.getAttributeValue(node2, "id"));
                ComPort port = new ComPort();
                port.enabled = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node2, "enabled"));
                port.typeOfPort = SceneSerializer.getAttributeValue(node2, "type");
                port.typeOfProtocol = SceneSerializer.getAttributeValue(node2, "protocol");
                for (Node subElement : SceneSerializer.getChildNode(node2)) {
                    if (subElement.getNodeName().equals("SerPort")) {
                        port.serSpeed = SceneSerializer.getAttributeValue(subElement, "serSpeed");
                        port.serNumbits = SceneSerializer.getAttributeValue(subElement, "serNumBits");
                        port.serParity = SceneSerializer.getAttributeValue(subElement, "serParity");
                        port.serStopBits = SceneSerializer.getAttributeValue(subElement, "serStopBits");
                        continue;
                    }
                    if (!subElement.getNodeName().equals("Ethernet")) continue;
                    port.ipAddress = SceneSerializer.getAttributeValue(subElement, "ipAddr");
                    port.ipGateway = SceneSerializer.getAttributeValue(subElement, "ipGW");
                    port.ipPort = SceneSerializer.getAttributeValue(subElement, "ipPort");
                    port.ipSubnet = SceneSerializer.getAttributeValue(subElement, "ipSubnet");
                    port.ipMac = SceneSerializer.getAttributeValue(subElement, "ipMAC");
                    if (port.ipMac == null || port.ipMac.length() < 13) {
                        port.ipMac = "02:00:00:00:00:01";
                    }
                    this.myDialog.txtIPAddress.setText(port.ipAddress);
                }
                this.portList[index] = port;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.programHash = 0;
            this.boardAddress = "65535";
            this.getDialog().txtIPAddress.setText("127.0.0.1");
            this.getDialog().txtIPPort.setText("23");
            this.getDialog().comboPort.setSelectedIndex(0);
            for (int index = 0; index < 3; ++index) {
                ComPort comPort = new ComPort();
                comPort.enabled = false;
                comPort.typeOfPort = "RS232";
                comPort.typeOfProtocol = "AFO";
                comPort.serSpeed = "9600";
                comPort.serNumbits = "8";
                comPort.serParity = "NONE";
                comPort.serStopBits = "1";
                comPort.ipAddress = "127.0.0.1";
                comPort.ipGateway = "127.0.0.1";
                comPort.ipPort = "23";
                comPort.ipSubnet = "255.255.255.0";
                this.portList[index] = comPort;
            }
        }
    }

    public void addTimer() {
        int maxTimer = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) ? 5 : 2;
        if (this.timerList.size() >= maxTimer) {
            JOptionPane.showMessageDialog(null, this.message.getString("nummaxtmr"), this.message.getString("er"), 0);
            return;
        }
        int timerID = this.findTimerID();
        AfoTimer timer = new AfoTimer(timerID, "Clock " + timerID, this.kernel, this);
        if (this.kernel != null) {
            timer.setConnectionStatus(this.kernel.isConnected());
        }
        this.myTabbedPane.add(timer.getName(), timer.getTimerPanel());
        this.myTabbedPane.validate();
        this.getTimerList().add(timer);
        this.projectDirty = true;
    }

    private int findTimerID() {
        int timerID = 1;
        boolean IDFound = true;
        block0: do {
            IDFound = true;
            for (int i = 0; i < this.timerList.size(); ++i) {
                if (this.timerList.get(i).getTimerID() != timerID) continue;
                ++timerID;
                IDFound = false;
                continue block0;
            }
        } while (!IDFound);
        return timerID;
    }

    public void addTimer(AfoTimer timer) {
        int maxTimer = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) ? 5 : 2;
        if (this.timerList.size() >= maxTimer) {
            JOptionPane.showMessageDialog(null, this.message.getString("nummaxtmr"), this.message.getString("er"), 0);
            return;
        }
        this.lastTabSelected = 0;
        this.myTabbedPane.add(timer.getName(), timer.getTimerPanel());
        this.myTabbedPane.validate();
        this.getTimerList().add(timer);
        this.projectDirty = true;
    }

    public void deleteTimer(int timerIndex) {
        this.lastTabSelected = 0;
        this.myTabbedPane.remove(timerIndex + 1);
        this.myTabbedPane.validate();
        this.timerList.remove(timerIndex);
        this.projectDirty = true;
    }

    public JTabbedPane getTabbedPane() {
        return this.myTabbedPane;
    }

    public void setTabbedPane(JTabbedPane myTabbedPane) {
        this.myTabbedPane = myTabbedPane;
        this.lastTabSelected = -1;
        myTabbedPane.addChangeListener(this);
    }

    public List<AfoTimer> getTimerList() {
        return this.timerList;
    }

    public ProjectDialog getDialog() {
        return this.getMyDialog();
    }

    public IKernel getKernel() {
        return this.kernel;
    }

    public BoardsTypesAndDescription.BoardType getBoardType() {
        return this.boardType;
    }

    public void setBoardType(BoardsTypesAndDescription.BoardType boardType) {
        this.boardType = boardType;
    }

    public void setBoardAddress(String newAddress) {
        this.boardAddress = newAddress;
    }

    public void generateDefaultBlocks() {
        String[] param;
        int i;
        BoardsTypesAndDescription.BoardType bt = this.getBoardType();
        int xPosition = 0;
        int stdBlockNumber = BoardsTypesAndDescription.boardAnalogInputNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.AnalogIN.toString(), "X" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardAnalogInputNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardDigitalInputNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.DigitalIN.toString(), "I" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardDigitalInputNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardUniversalInputNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.UniversalIN.toString(), "UI" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardUniversalInputNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardPtNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Pt100.toString(), "Pt100-" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardPtNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardNTCNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.NTC.toString(), "NTC-" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardNTCNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardDSNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.DipSwitch.toString(), "DS" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardDSNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardTempHumiNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.TempHumi.toString(), "TempHumi" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardTempHumiNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardHumidityNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Hum.toString(), "Hum" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardHumidityNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardButtonNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Button.toString(), "Button" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardButtonNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardJumperNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Jumper.toString(), "Jumper" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardJumperNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardRitNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Rit.toString(), "Rit" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardRitNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardMonitorNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Monitor_2.toString(), "MonitorFPF" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        xPosition += 200;
        if (BoardsTypesAndDescription.boardMonitorNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardAnalogOutputNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.AnalogOUT.toString(), "Y" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardAnalogOutputNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardLedNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.Led.toString(), "Led" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        if (BoardsTypesAndDescription.boardLedNumber[this.boardType.ordinal()] != 0) {
            xPosition += 200;
        }
        stdBlockNumber = BoardsTypesAndDescription.boardDigitalOutputNumber[this.boardType.ordinal()];
        for (i = 0; i < stdBlockNumber; ++i) {
            param = new String[]{CommonDefinitions.blockTypes.DigitalOUT.toString(), "K" + (i + 1)};
            this.mainSystem.addElementToSystem(param, new Point(xPosition, i * 100), null, null, true, true);
        }
        this.projectDirty = true;
    }

    public ProjectDialog getMyDialog() {
        return this.myDialog;
    }

    public void createKernel() throws Exception {
        this.kernel = new SerialKernel(this, null);
        ((SerialKernel)this.kernel).isEthernet = this.myDialog.comboPort.getSelectedIndex() == 0;
        this.kernel.addKernelEventListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.myTabbedPane)) {
            AfoTimer tmr;
            int num;
            int index;
            block11: {
                index = this.myTabbedPane.getSelectedIndex();
                if (index == this.lastTabSelected) {
                    return;
                }
                if (this.lastTabSelected > 0) {
                    num = Integer.parseInt(this.myTabbedPane.getTitleAt(this.lastTabSelected).substring(6));
                    tmr = this.getTimerbyID(num);
                    if (tmr == null) {
                        System.out.println(this.message.getString("idtimer") + num + this.message.getString("notexist"));
                        return;
                    }
                    if (!tmr.isTimerDirty()) {
                        return;
                    }
                    Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
                    if (JOptionPane.showOptionDialog(null, this.message.getString("savetimer"), this.message.getString("att"), 0, 2, null, myOptions, myOptions[0]) == 0) {
                        tmr.sortAllTables();
                        tmr.getTimerPanelData();
                        try {
                            if (!this.kernel.isConnected()) break block11;
                            Object[] op = new Object[]{this.message.getString("yes"), this.message.getString("no"), this.message.getString("cancel")};
                            if (JOptionPane.showOptionDialog(null, this.message.getString("inviotimer"), this.message.getString("att"), 0, 2, null, op, op[0]) == 0) {
                                tmr.sendTimer();
                            }
                        }
                        catch (Exception ex) {}
                    } else {
                        tmr.setTimerDirty(false);
                    }
                }
            }
            if (index > 0 && (tmr = this.getTimerbyID(num = Integer.parseInt(this.myTabbedPane.getTitleAt(index).substring(6)))) != null) {
                tmr.setTimerPanelData();
                tmr.setTimerDirty(false);
            }
            this.lastTabSelected = index;
        }
    }

    public AfoTimer getTimerbyID(int num) {
        for (AfoTimer tmr : this.timerList) {
            if (tmr.getTimerID() != num) continue;
            return tmr;
        }
        return null;
    }

    public String getBoardAddress() {
        return this.boardAddress;
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Kernel Disconnected")) {
            this.kernel = null;
            for (AFONode node : this.mainSystem.getNodeList()) {
                try {
                    ((GenericNode)node).kernelConnected = false;
                }
                catch (Exception ex) {}
            }
            this.mainSystem.getSubSystemScene().enableConnectAndReconnect(true);
            for (AFOSystemManager sm : this.subSystemsList) {
                sm.getSubSystemScene().enableConnectAndReconnect(true);
                for (AFONode node : sm.getNodeList()) {
                    try {
                        ((GenericNode)node).kernelConnected = false;
                    }
                    catch (Exception ex) {}
                }
            }
            for (AfoTimer tmr : this.timerList) {
                tmr.enableButtonPanel(false);
            }
            this.myDialog.enableControls(true);
        } else if (evt.getEventType().equals("Kernel Connected")) {
            for (AFONode node : this.mainSystem.getNodeList()) {
                try {
                    ((GenericNode)node).kernelConnected = true;
                }
                catch (Exception ex) {}
            }
            this.mainSystem.getSubSystemScene().enableConnectAndReconnect(false);
            for (AFOSystemManager sm : this.subSystemsList) {
                sm.getSubSystemScene().enableConnectAndReconnect(false);
                for (AFONode node : sm.getNodeList()) {
                    try {
                        ((GenericNode)node).kernelConnected = true;
                    }
                    catch (Exception ex) {}
                }
            }
            for (AfoTimer tmr : this.timerList) {
                tmr.enableButtonPanel(true);
            }
            this.outMsgList.clear();
            this.outMsgList.add("<BL get 0 >");
            this.outMsgList.add("<RT ? >");
            this.outMsgList.add("<BL ? >");
            this.sendMessageList();
            this.myDialog.enableControls(false);
        } else if (evt.getEventType().equals("Command Executed")) {
            if (this.waitingForAnswer) {
                this.sendMessageList();
            }
        } else if ((evt.getEventType().equals("Command Not Executed") || evt.getEventType().equals("Timeout on command")) && this.waitingForAnswer) {
            this.options.LoadOptions();
            this.currentLocale = new Locale(this.options.language, this.options.country);
            this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
            JOptionPane.showMessageDialog(null, this.message.getString("commandko"), this.message.getString("er"), 0);
            this.outMsgList.clear();
            this.waitingForAnswer = false;
        }
    }

    private boolean sendMessageList() {
        if (this.outMsgList.size() == 0) {
            this.waitingForAnswer = false;
            return false;
        }
        String msg = this.outMsgList.get(0).toString();
        this.outMsgList.remove(0);
        if (this.kernel.sendCommand(msg)) {
            this.waitingForAnswer = true;
        } else {
            System.out.println(this.message.getString("commandnotsend") + msg);
        }
        return true;
    }

    @Override
    public void sceneEventOccurred(SceneEvent evt) {
        if (this.projectIsLoading) {
            this.fireEvent(new ProjectEvent(this, "Scene Changed"));
            return;
        }
        if (evt.getEventType().equals("Scene Changed")) {
            this.projectDirty = true;
            this.calcHash();
            this.fireEvent(new ProjectEvent(this, "Scene Changed"));
        }
    }

    public void addEventListener(ProjectEventListener listener) {
        this.listenerList.add(ProjectEventListener.class, listener);
    }

    public void removeEventListener(ProjectEventListener listener) {
        this.listenerList.remove(ProjectEventListener.class, listener);
    }

    public void importSubsystem(AFOSystemManager systemManager) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("AFO Subsystems", ".sub".substring(1));
        chooser.setDialogTitle(this.message.getString("openss"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(filter);
        chooser.setCurrentDirectory(new File(this.getProjectFolder()));
        if (chooser.showOpenDialog(null) == 0) {
            File openFile = chooser.getSelectedFile();
            String importedSubsystemID = chooser.getName(openFile);
            this.subImporter = new SubSystemImporter(systemManager, openFile, importedSubsystemID);
            this.subImporter.addPropertyChangeListener(this);
            this.pf.setTitle("Opening ...");
            this.pf.lblNofBlocks.setText("0");
            this.pf.lblMessageLabel.setText("Importing ...");
            this.pf.validate();
            this.pf.setModal(false);
            RefineryUtilities.centerFrameOnScreen((Window)this.pf);
            this.pf.setVisible(true);
            try {
                this.subImporter.execute();
            }
            catch (Exception e) {
                e.toString();
            }
        }
    }

    void fireEvent(ProjectEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).projectEventOccurred(evt);
        }
    }

    public ComPort[] getPortList() {
        return this.portList;
    }

    public void downloadConfiguration() {
        this.outMsgList.clear();
        this.sendMessageList();
        ProgramDownloader pu = new ProgramDownloader(this, this.kernel);
        pu.addKernelEventListener(this.kernel.getTerminalDialog().getPnlUpload());
        pu.addKernelEventListener(this.kernel.getTerminalDialog());
        pu.start();
    }

    public void uploadFile(String filePath) {
        this.outMsgList.clear();
        this.sendMessageList();
        ProgramUploader pu = new ProgramUploader(filePath, this.kernel);
        pu.addKernelEventListener(this.kernel.getTerminalDialog().getPnlUpload());
        pu.addKernelEventListener(this.kernel.getTerminalDialog());
        pu.start();
    }

    public void cleanSubsystemFileName() {
        this.mainSystem.setFileName(" ");
        for (AFOSystemManager sys : this.subSystemsList) {
            sys.setFileName(" ");
        }
    }

    public static Image getImage(Component c) {
        Dimension d = c.getSize();
        Frame f = new Frame();
        f.addNotify();
        f.setSize(d);
        Image i = f.createImage(d.width, d.height);
        c.paint(i.getGraphics());
        return i;
    }

    public int countSub() {
        int count = this.subSystemsList.size();
        return count;
    }

    public void printprj() {
        Iterator<AFONode> nodeManagerIt = this.mainSystem.getNodeList().iterator();
        JComponent image = this.mainSystem.getAfoView();
        Image im = Project.getImage(image);
        String nameoffile = this.projectFolder + "Principal" + ".jpeg";
        System.out.print(nameoffile + "\r\n");
        Dimension size = image.getSize();
        BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = myImage.createGraphics();
        ((Component)image).paint(g2);
        try {
            FileOutputStream out = new FileOutputStream(nameoffile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(myImage);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        while (nodeManagerIt.hasNext()) {
            AFONode nm = nodeManagerIt.next();
            int nOfPrint = 0;
            if (!(nm instanceof AFOSystemManager)) continue;
            AFOSystemManager nodeManager = (AFOSystemManager)nm;
            try {
                nOfPrint = nodeManager.createPrintProject(nOfPrint);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void addSubSystemNodesToDB(AFOSystemManager system) {
        for (AFONode nd : system.getNodeList()) {
            if (nd.getBlockType() == CommonDefinitions.blockTypes.IN || nd.getBlockType() == CommonDefinitions.blockTypes.OUT || nd.getBlockType() == CommonDefinitions.blockTypes.Scope || nd.getBlockType() == CommonDefinitions.blockTypes.Comment || nd.getBlockType() == CommonDefinitions.blockTypes.Subsystem) continue;
            ((GenericNode)nd).setDatabase(this.projectDB);
        }
    }

    public void addNodesToDB() {
        this.addSubSystemNodesToDB(this.mainSystem);
        for (AFOSystemManager mngr : this.subSystemsList) {
            this.addSubSystemNodesToDB(mngr);
        }
    }

    private void getTreeNodeLeafs(GenericNode device, DefaultMutableTreeNode node) {
        List<AFOPin> pinList = device.getPinList();
        for (AFOPin pin : pinList) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(pin);
            node.add(newNode);
        }
    }

    public void getProjectTree(DefaultMutableTreeNode treeRoot, AFOSystemManager system) {
        for (AFONode nd : system.getNodeList()) {
            if (nd.getBlockType() != CommonDefinitions.blockTypes.IN && nd.getBlockType() != CommonDefinitions.blockTypes.OUT && nd.getBlockType() != CommonDefinitions.blockTypes.Scope && nd.getBlockType() != CommonDefinitions.blockTypes.Comment && nd.getBlockType() != CommonDefinitions.blockTypes.Subsystem) {
                GenericNode genNode = (GenericNode)nd;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(genNode);
                this.getTreeNodeLeafs(genNode, newNode);
                treeRoot.add(newNode);
                continue;
            }
            if (nd.getBlockType() != CommonDefinitions.blockTypes.Subsystem) continue;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode((GenericNode)nd);
            this.getProjectTree(newNode, (AFOSystemManager)nd);
            treeRoot.add(newNode);
        }
    }

    @Override
    public void projectEventOccurred(ProjectEvent evt) {
        if (evt.getEventType().equals("Scene Changed") && this.pf.isVisible()) {
            this.pf.prgBarProgBar.setValue(this.getNofBlocks() % 10 * 10);
            this.pf.lblNofBlocks.setText("" + this.getNofBlocks());
            this.pf.validate();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.subImporter) && evt.getPropertyName().equals("progress")) {
            this.pf.prgBarProgBar.setValue((Integer)evt.getNewValue());
            this.pf.validate();
        }
    }

    public void finalizeOpen() {
        this.mainSystem.resetUndo();
        for (AFOSystemManager sys : this.subSystemsList) {
            sys.resetUndo();
        }
    }

    public ArrayList<AFONode> getNodeList() {
        ArrayList<AFONode> list = new ArrayList<AFONode>();
        list.addAll(this.mainSystem.getNodeList());
        for (AFOSystemManager mngr : this.subSystemsList) {
            list.addAll(mngr.getNodeList());
        }
        return list;
    }

    class SubSystemImporter
    extends SwingWorker<Void, Void> {
        int progress = 0;
        File fileName;
        String systemID;
        AFOSystemManager sm;

        public SubSystemImporter(AFOSystemManager system, File fileName, String systemID) {
            this.sm = system;
            this.fileName = fileName;
            this.systemID = systemID;
        }

        @Override
        public Void doInBackground() {
            try {
                this.sm.importSubsystem(this.fileName, this.systemID);
            }
            catch (ConcurrentModificationException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }

        @Override
        public void done() {
            Project.this.pf.setVisible(false);
        }
    }
}

