/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import java.awt.Point;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import nodes.AFOSystemManager;
import nodes.devices.GenericNode;

class UndoRedo
extends AbstractUndoableEdit {
    public AFOSystemManager system;
    public GenericNode node;
    String elementID;
    Point position;
    Integer address;
    boolean isDelete;

    public UndoRedo(GenericNode node, AFOSystemManager system, boolean isDelete) {
        this.node = node;
        this.system = system;
        this.isDelete = isDelete;
        this.position = node.getWidget().getLocation();
    }

    @Override
    public String getPresentationName() {
        return "UNDO/REDO";
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (!this.isDelete) {
            if (this.node instanceof AFOSystemManager) {
                this.position = this.node.getWidget().getLocation();
                this.system.deleteElementFromSystem(this.node.getWidget(), true);
            } else {
                this.position = this.node.getWidget().getLocation();
                this.system.deleteElementFromSystem(this.node.getWidget(), true);
            }
        } else if (this.node instanceof AFOSystemManager) {
            this.system.getProject().addSubSystem(this.system, (AFOSystemManager)this.node);
            this.system.getScene().validate();
            ((AFOSystemManager)this.node).rescanIOPins();
            this.system.getScene().validate();
        } else {
            this.elementID = this.node.getId();
            this.address = null;
            String[] splitted = new String[2];
            splitted[0] = this.node.getBlockType().toString();
            if (!this.node.getSubType().equals(null)) {
                splitted[1] = this.node.getSubType().toString();
            }
            this.system.addElementToSystem(splitted, this.position, this.elementID, this.address, true, true);
            this.node = (GenericNode)this.system.getNodeAtIndex(this.system.getNodeListSize() - 1);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.isDelete) {
            if (this.node instanceof AFOSystemManager) {
                this.position = this.node.getWidget().getLocation();
                this.system.deleteElementFromSystem(this.node.getWidget(), true);
            } else {
                this.position = this.node.getWidget().getLocation();
                this.system.deleteElementFromSystem(this.node.getWidget(), true);
            }
        } else if (this.node instanceof AFOSystemManager) {
            this.system.getProject().addSubSystem(this.system, (AFOSystemManager)this.node);
            this.system.getScene().validate();
            ((AFOSystemManager)this.node).rescanIOPins();
            this.system.getScene().validate();
        } else {
            this.elementID = this.node.getId();
            this.address = null;
            String[] splitted = new String[2];
            splitted[0] = this.node.getBlockType().toString();
            if (!this.node.getSubType().equals(null)) {
                splitted[1] = this.node.getSubType().toString();
            }
            this.system.addElementToSystem(splitted, this.position, this.elementID, this.address, true, true);
        }
    }
}

