/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import VisiProg.AppOptions;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileNameExtensionFilter;
import nodes.AFOSystemManager;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.devices.ScopeNode;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;

public class WidgetPopupMenu
implements PopupMenuProvider,
ActionListener {
    private AFOGraphPinScene scene;
    private AFOSystemManager systemManager;
    private JPopupMenu menu;
    private Widget node;
    Locale currentLocale;
    ResourceBundle message;
    private Point point;
    private AppOptions options = new AppOptions();
    Color currentColor;
    JColorChooser colorChooser;
    JDialog colordialog;

    public WidgetPopupMenu(AFOGraphPinScene scene, AFOSystemManager systemManager) {
        this.scene = scene;
        this.systemManager = systemManager;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.menu = new JPopupMenu(this.message.getString("nodemenu"));
        this.colorChooser = new JColorChooser();
        this.colordialog = JColorChooser.createDialog(null, this.message.getString("colori"), true, this.colorChooser, null, null);
        this.colorChooser.setColor(Color.blue);
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        JMenuItem item;
        boolean isConnected = false;
        this.node = widget;
        this.point = point;
        this.menu.removeAll();
        if (this.systemManager.getProject().getKernel() != null && this.systemManager.getProject().getKernel().isConnected()) {
            isConnected = true;
        }
        if (this.scene.isEdge(this.scene.findObject(widget))) {
            if (!isConnected) {
                JMenuItem item2 = new JMenuItem("Change Color");
                item2.setActionCommand("Change Color");
                item2.addActionListener(this);
                this.menu.add(item2);
                item2 = new JMenuItem("Delete Object");
                item2.setActionCommand("Delete Object");
                item2.addActionListener(this);
                this.menu.add(item2);
            }
            return this.menu;
        }
        AFONode selectedNode = (AFONode)this.scene.findObject(this.node);
        try {
            if (selectedNode.getBlockType().ordinal() > CommonDefinitions.blockTypes.DigitalOUT.ordinal() || selectedNode.getBlockType().equals((Object)CommonDefinitions.blockTypes.Monitor)) {
                if (!isConnected) {
                    item = new JMenuItem(this.message.getString("cancellaoggetto"));
                    item.setActionCommand("Delete Object");
                    item.addActionListener(this);
                    this.menu.add(item);
                    this.menu.add(new JSeparator());
                    item = new JMenuItem(this.message.getString("copiaoggetto"));
                    item.setActionCommand("Copy Object");
                    item.addActionListener(this);
                    this.menu.add(item);
                }
            } else {
                item = new JMenuItem(this.message.getString("nascondi"));
                item.setActionCommand("Hide Object");
                item.addActionListener(this);
                this.menu.add(item);
            }
            if (selectedNode instanceof AFOSystemManager) {
                item = new JMenuItem(this.message.getString("export"));
                item.setActionCommand("Export Node");
                item.addActionListener(this);
                this.menu.add(item);
            } else if (selectedNode instanceof ScopeNode) {
                item = new JMenuItem(this.message.getString("mostranasc"));
                item.setActionCommand("Show Chart");
                item.addActionListener(this);
                this.menu.add(item);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.menu.add(new JSeparator());
        item = new JMenuItem(this.message.getString("properties"));
        item.setActionCommand("Edit Node");
        item.addActionListener(this);
        this.menu.add(item);
        if (isConnected && selectedNode.getBlockType() != CommonDefinitions.blockTypes.Subsystem && selectedNode.getBlockType() != CommonDefinitions.blockTypes.Comment && selectedNode.getBlockType() != CommonDefinitions.blockTypes.Scope && selectedNode.getBlockType() != CommonDefinitions.blockTypes.IN && selectedNode.getBlockType() != CommonDefinitions.blockTypes.OUT) {
            this.menu.add(new JSeparator());
            item = new JMenuItem(this.message.getString("update"));
            item.setActionCommand("Update Node Data");
            item.addActionListener(this);
            this.menu.add(item);
        }
        return this.menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color newColor;
        if (e.getActionCommand().equals("Delete Object")) {
            this.systemManager.deleteElementFromSystem(this.node, false);
        } else if (e.getActionCommand().equals("Hide Object")) {
            this.node.setVisible(false);
        } else if (e.getActionCommand().equals("Copy Object")) {
            this.systemManager.copySystem(this.node, this.scene);
        } else if (e.getActionCommand().equals("Edit Node")) {
            Object blockType = null;
            AFONode selectedNode = (AFONode)this.scene.findObject(this.node);
            try {
                selectedNode.showPropertiesDialog();
                if (this.systemManager.isSubSystem()) {
                    this.systemManager.getScene().validate();
                }
            }
            catch (Exception ex) {
                System.out.println(this.message.getString("errselnodo") + ex.getLocalizedMessage());
            }
        } else if (e.getActionCommand().equals("Update Node Data")) {
            GenericNode selectedNode = (GenericNode)this.scene.findObject(this.node);
            try {
                selectedNode.updateBlockIO();
            }
            catch (Exception ex) {}
        } else if (e.getActionCommand().equals("Export Node")) {
            Set blockList = this.systemManager.getSubSystemScene().getSelectedObjects();
            Object[] blockArray = blockList.toArray();
            if (blockList.size() != 1 || !(blockArray[0] instanceof AFOSystemManager)) {
                return;
            }
            AFOSystemManager manager = (AFOSystemManager)blockArray[0];
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("AFO Subsystems", ".sub".substring(1));
            chooser.setDialogTitle(this.message.getString("savesub"));
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.addChoosableFileFilter(filter);
            chooser.setCurrentDirectory(new File(this.systemManager.getProject().getProjectFolder()));
            chooser.setSelectedFile(new File(manager.getComment() + ".sub"));
            if (chooser.showSaveDialog(null) == 0) {
                File saveFile;
                String fileName = chooser.getSelectedFile().toString();
                if (!fileName.endsWith(".sub")) {
                    fileName = fileName + ".sub";
                }
                if ((saveFile = new File(fileName)).exists()) {
                    saveFile.delete();
                }
                try {
                    saveFile.createNewFile();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    JOptionPane.showMessageDialog(null, this.message.getString("errfile"), this.message.getString("er"), 0);
                    return;
                }
                SceneSerializer.subSystemNumber = 1;
                SceneSerializer.serialize(this.systemManager.getProject(), manager.getSubSystemScene(), saveFile, true);
            }
        } else if (e.getActionCommand().equals("Show Chart")) {
            AFONode selectedNode = (AFONode)this.scene.findObject(this.node);
            ((ScopeNode)selectedNode).showChartFrame();
        } else if (e.getActionCommand().equals("Change Color") && (newColor = JColorChooser.showDialog(null, this.message.getString("newcolor"), Color.blue)) != null) {
            this.systemManager.changeEdgeColor(newColor);
        }
    }
}

