/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class AddressNode
extends DeviceNode {
    private String value = "0.0";
    public static final String ADDRESS_ID = "46";

    public AddressNode(String id, String label, String UID, AFOGraphPinScene scene) {
        super(id, label, "Address", scene);
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Address;
        this.numberOfInputs = 1;
        this.addressSpace = 1;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "Address");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Address");
        String pinLabel = "Addr";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.getValue());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
        }
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "46 " + this.getCommonData() + this.value;
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
            String newLabel = cmd.getValue("OUT1");
            ((AFONodeWidget)this.widget).setSubType(newLabel);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(1)).toString())) {
            this.value = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Costant", this.value);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.value = SceneSerializer.getAttributeValue(node, "Costant");
    }
}

