/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class ArithmeticNode
extends GenericNode {
    String implicitOperand = "0.0";
    public static final int ARITHMETIC_ID = 10;

    public ArithmeticNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.subType = CommonDefinitions.subBlockTypes.ADD;
        for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
            if (!mytype.toString().equals(label)) continue;
            this.subType = mytype;
            break;
        }
        this.numberOfInputs = 2;
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Arithmetic;
        this.addressSpace = 3;
        this.codici = new ArrayList();
        this.codici.add("ArithmeticNode");
        this.codici.add("ArithmeticNode_R");
        this.codici.add("ArithmeticNode_Impl");
        this.setList(this.codici);
        this.CreatePropertiesDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Arithmetic");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        this.createInputPins();
        ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void createInputPins() {
        int i;
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            ArrayList edgeList = (ArrayList)this.scene.findPinEdges(pin, false, true);
            for (AFOEdge edge : edgeList) {
                this.scene.removeEdge(edge);
            }
        }
        ((AFONodeWidget)this.widget).clearInputPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        for (i = 0; i < this.pinList.size(); ++i) {
            if (!((AFOPin)this.pinList.get(i)).getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            this.pinList.remove(i);
            --i;
        }
        for (i = 1; i <= this.numberOfInputs; ++i) {
            String pinLabel = "IN" + i;
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setPinIDString("IN" + i);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.resetPinValues();
        this.scene.validate();
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        for (CommonDefinitions.arithmeticTypes myType : CommonDefinitions.arithmeticTypes.values()) {
            ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem(CommonDefinitions.arithmeticStrings[myType.ordinal()]);
        }
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Implicit Operand :");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Number of Inputs :");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.getDocument().addDocumentListener(new FieldChangeListener());
        ((GenericBlockDialog)this.propertiesDialog).txtField2.getDocument().addDocumentListener(new FieldChangeListener());
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(((AFONodeWidget)this.widget).getSubType().substring(0, 1));
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(!this.kernelConnected);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.implicitOperand);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText("" + this.numberOfInputs);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setEnabled(!this.kernelConnected);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            int newNIns;
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.implicitOperand = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + this.implicitOperand + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
            String newType = ((GenericBlockDialog)this.propertiesDialog).comboSubType.getSelectedItem().toString();
            for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
                if (!CommonDefinitions.subBlockStrings[mytype.ordinal()].equals(newType)) continue;
                this.subType = mytype;
                break;
            }
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
            AFOPin pin = this.getPinByID("IN2");
            if (pin != null && this.scene.findPinEdges(pin, false, true).isEmpty()) {
                ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + this.implicitOperand);
            }
            if ((newNIns = (int)Float.parseFloat(((GenericBlockDialog)this.propertiesDialog).txtField2.getText())) > 1 && newNIns != this.numberOfInputs) {
                this.numberOfInputs = newNIns;
                this.createInputPins();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + (this.subType.ordinal() - CommonDefinitions.subBlockTypes.IF_NE.ordinal()));
        retVal = retVal + "10 " + this.getCommonData() + type + " " + this.implicitOperand;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        AFOPin pin = this.getPinByID("IN2");
        if (this.scene.findPinEdges(pin, false, true).isEmpty()) {
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + this.implicitOperand);
        } else {
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + pin.getValue().substring(1, pin.getValue().length()));
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "ImplicitOperand", this.implicitOperand);
        SceneSerializer.setAttribute(document, nodeElement, "NOfInputs", "" + this.numberOfInputs);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        String nOfInputs;
        this.implicitOperand = SceneSerializer.getAttributeValue(node, "ImplicitOperand");
        if (this.implicitOperand == null) {
            this.implicitOperand = "0.0";
        }
        this.numberOfInputs = (nOfInputs = SceneSerializer.getAttributeValue(node, "NOfInputs")) == null ? 2 : Integer.parseInt(nOfInputs);
        this.createInputPins();
        ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + this.implicitOperand);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
    }

    class FieldChangeListener
    implements DocumentListener {
        private int MAX_INPUTS = 10;

        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void control() {
            int nOfIn = 0;
            try {
                nOfIn = (int)Float.parseFloat(((GenericBlockDialog)((ArithmeticNode)ArithmeticNode.this).propertiesDialog).txtField2.getText());
                if (nOfIn > this.MAX_INPUTS) {
                    throw new Exception("Max Num Inputs");
                }
                if (nOfIn < 2) {
                    ((GenericBlockDialog)((ArithmeticNode)ArithmeticNode.this).propertiesDialog).btnOk.setEnabled(false);
                } else {
                    ((GenericBlockDialog)((ArithmeticNode)ArithmeticNode.this).propertiesDialog).btnOk.setEnabled(true);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Errore nel campo Numero Ingressi", "Errore", 0);
                ((GenericBlockDialog)((ArithmeticNode)ArithmeticNode.this).propertiesDialog).btnOk.setEnabled(false);
            }
        }
    }
}

