/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class BinaryEncoderNode
extends GenericNode {
    boolean checkin = true;
    public static final int BIN_ENCDEC_ID = 18;

    public BinaryEncoderNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.BinaryEncoder;
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "BinEncoder");
        this.codici.add(1, "BinEncoder_R");
        this.setList(this.codici);
        this.numberOfInputs = 4;
        this.CreateWidget();
        this.CreatePropertiesDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Encoder");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        this.createInputPins();
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void createInputPins() {
        int i;
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            ArrayList edgeList = (ArrayList)this.scene.findPinEdges(pin, false, true);
            for (AFOEdge edge : edgeList) {
                this.scene.removeEdge(edge);
            }
        }
        ((AFONodeWidget)this.widget).clearInputPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        for (i = 0; i < this.pinList.size(); ++i) {
            if (!((AFOPin)this.pinList.get(i)).getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            this.pinList.remove(i);
            --i;
        }
        for (i = 1; i <= this.numberOfInputs; ++i) {
            String pinLabel = "IN" + i;
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setPinIDString("IN" + i);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.resetPinValues();
        this.scene.validate();
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Number of Inputs :");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.getDocument().addDocumentListener(new FieldChangeListener());
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.checkin);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setText("Controllo ingresso non valido.");
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(!this.kernelConnected);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText("" + this.numberOfInputs);
        ((GenericBlockDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 2) {
            this.checkin = !this.checkin;
        }
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            int newNIns;
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            int check = this.checkin ? 1 : 0;
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + check + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
            if ((newNIns = (int)Float.parseFloat(((GenericBlockDialog)this.propertiesDialog).txtField2.getText())) > 1 && newNIns != this.numberOfInputs) {
                this.numberOfInputs = newNIns;
                this.createInputPins();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        int check = this.checkin ? 0 : 1;
        retVal = retVal + "18 " + this.getCommonData() + "1.0 " + "0.0 " + check;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "NOfInputs", "" + this.numberOfInputs);
        SceneSerializer.setAttribute(document, nodeElement, "CheckIN", "" + this.checkin);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        String nOfInputs = SceneSerializer.getAttributeValue(node, "NOfInputs");
        this.numberOfInputs = nOfInputs == null ? 4 : Integer.parseInt(nOfInputs);
        this.createInputPins();
        String checkinstring = SceneSerializer.getAttributeValue(node, "CheckIN");
        this.checkin = checkinstring == null ? true : (checkinstring.equals("true") ? true : !checkinstring.equals("false"));
    }

    class FieldChangeListener
    implements DocumentListener {
        private int MAX_INPUTS = 10;

        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void control() {
            int nOfIn = 0;
            try {
                nOfIn = (int)Float.parseFloat(((GenericBlockDialog)((BinaryEncoderNode)BinaryEncoderNode.this).propertiesDialog).txtField2.getText());
                if (nOfIn > this.MAX_INPUTS) {
                    throw new Exception("Max Num Inputs");
                }
                if (nOfIn < 2) {
                    ((GenericBlockDialog)((BinaryEncoderNode)BinaryEncoderNode.this).propertiesDialog).btnOk.setEnabled(false);
                } else {
                    ((GenericBlockDialog)((BinaryEncoderNode)BinaryEncoderNode.this).propertiesDialog).btnOk.setEnabled(true);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Errore nel campo Numero Ingressi", "Errore", 0);
                ((GenericBlockDialog)((BinaryEncoderNode)BinaryEncoderNode.this).propertiesDialog).btnOk.setEnabled(false);
            }
        }
    }
}

