/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.SerialKernel;
import connection.XMLCommands.UtilXML;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class ButtonNode
extends DeviceNode {
    private String typeName;
    public static final int Button_ID = 34;

    public ButtonNode(String id, String label, String deviceID, AFOGraphPinScene scene) {
        super(id, label, deviceID, scene);
        this.typeName = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, deviceID, this);
        this.blockType = CommonDefinitions.blockTypes.Button;
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        this.numberOfInputs = 0;
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "Button");
        this.codici.add(1, "Button");
        this.setList(this.codici);
        this.CreateWidget();
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), false).booleanValue()) {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        String pinLabel = "B";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType("Button");
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1) {
            if (((SimplePropertiesDlg)this.propertiesDialog).indexLabel.isVisible()) {
                JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                return;
            }
            if (((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
                this.scene.sceneChanged();
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.propertiesDialog.setVisible(false);
                if (this.kernel != null && this.kernel instanceof SerialKernel) {
                    this.commandQueue.clear();
                    int num = Integer.parseInt(this.deviceID.substring(2));
                    int valInt = 0;
                    String msg = "<BL set " + this.addressList.get(1) + " ";
                    String val = ((SimplePropertiesDlg)this.propertiesDialog).txtValue.getText();
                    valInt = (int)Float.parseFloat(val);
                    msg = valInt == 0 ? msg + "0.0" : msg + "1.0";
                    msg = msg + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "34 ";
        retVal = retVal + this.getCommonData();
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        if (UtilXML.cmpCmdValue(com, "ADDRESS", (Integer)this.addressList.get(0))) {
            AFOPin pin = (AFOPin)this.pinList.get(0);
            String tempVal = com.getValue("BUTTON");
            pin.getPinNameWidget().setLabel("(" + tempVal + ")" + "IN");
            this.getScene().validate();
            return true;
        }
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        }
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }
}

