/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.SerialKernel;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.C3PointDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class C3PointCtrlNode
extends GenericNode {
    private String setpoint = "20.0";
    private String setpointH = "35.0";
    private String setpointL = "15.0";
    private String moveTime = "180";
    private String nullZone = "3.0";
    private String summer = "0";
    private String address;
    public static final int C3POINT_ID = 19;
    public final String SETPOINT = "Setpoint";
    public final String SETPOINTH = "SetpointH";
    public final String SETPOINTL = "SetpointL";
    public final String NULLZONE = "NullZone";
    public final String MOVETIME = "Movetime";
    public final String SUMMER = "Summer";

    public C3PointCtrlNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.C3PointCtrl;
        this.addressSpace = 11;
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "C3");
        this.codici.add(1, "OUT_OPEN");
        this.codici.add(2, "OUT_CLOSE");
        this.codici.add(3, "OUT_FullOPEN");
        this.codici.add(4, "OUT_FullCLOSE");
        this.codici.add(5, "Setpoint");
        this.codici.add(6, "SetpointH");
        this.codici.add(7, "SetpointL");
        this.codici.add(8, "Summer");
        this.codici.add(9, "Movetime");
        this.codici.add(10, "NullZone");
        this.setList(this.codici);
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("3 Point");
        this.getScene().addNode(this);
        String pinLabel = "OPEN";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "CLOSE";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "FULL Open";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT3");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "FULL Closed";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT4");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ctrl IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "LM IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "SPH";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "SPL";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "MT";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "NZ";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new C3PointDialog(null, true, this);
        this.propertiesDialog.setResizable(false);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "19 " + this.getCommonData();
        retVal = retVal + this.setpoint + " " + this.setpointH + " " + this.setpointL;
        retVal = retVal + " " + Float.parseFloat(this.summer);
        retVal = retVal + " " + this.moveTime + " " + this.nullZone;
        return retVal;
    }

    private void setDialogFields() {
        ((C3PointDialog)this.propertiesDialog).txtSetpoint.setText(this.setpoint);
        ((C3PointDialog)this.propertiesDialog).txtSetpointH.setText(this.setpointH);
        ((C3PointDialog)this.propertiesDialog).txtSetpointL.setText(this.setpointL);
        if (this.summer.equals("1")) {
            ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(true);
        } else {
            ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(false);
        }
        ((C3PointDialog)this.propertiesDialog).txtMovetime.setText(this.moveTime);
        ((C3PointDialog)this.propertiesDialog).txtNullzone.setText(this.nullZone);
    }

    private void getDialogFields() {
        this.setpoint = ((C3PointDialog)this.propertiesDialog).txtSetpoint.getText();
        this.setpointH = ((C3PointDialog)this.propertiesDialog).txtSetpointH.getText();
        this.setpointL = ((C3PointDialog)this.propertiesDialog).txtSetpointL.getText();
        this.summer = this.boolToIntString(((C3PointDialog)this.propertiesDialog).checkSummer.isSelected());
        this.moveTime = ((C3PointDialog)this.propertiesDialog).txtMovetime.getText();
        this.nullZone = ((C3PointDialog)this.propertiesDialog).txtNullzone.getText();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((C3PointDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((C3PointDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.setDialogFields();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((C3PointDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((C3PointDialog)this.propertiesDialog).checkFields()) {
                return;
            }
            this.getDialogFields();
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.scene.sceneChanged();
            if (this.kernel == null || !this.kernel.isConnected()) {
                this.propertiesDialog.setVisible(false);
                return;
            }
            if (this.kernel instanceof SerialKernel) {
                this.commandQueue.clear();
                int paramBaseAddr = 5;
                String msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtSetpoint.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtSetpointH.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtSetpointL.getText() + " >";
                this.commandQueue.add(msg);
                msg = ((C3PointDialog)this.propertiesDialog).checkSummer.isSelected() ? "<BL set " + this.addressList.get(paramBaseAddr++) + " 1.0 >" : "<BL set " + this.addressList.get(paramBaseAddr++) + " 0.0 >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtMovetime.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtNullzone.getText() + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Setpoint", this.setpoint);
        SceneSerializer.setAttribute(document, nodeElement, "SetpointH", this.setpointH);
        SceneSerializer.setAttribute(document, nodeElement, "SetpointL", this.setpointL);
        SceneSerializer.setAttribute(document, nodeElement, "NullZone", this.nullZone);
        SceneSerializer.setAttribute(document, nodeElement, "Movetime", this.moveTime);
        SceneSerializer.setAttribute(document, nodeElement, "Summer", this.summer);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.setpoint = SceneSerializer.getAttributeValue(node, "Setpoint");
        this.setpointH = SceneSerializer.getAttributeValue(node, "SetpointH");
        this.setpointL = SceneSerializer.getAttributeValue(node, "SetpointL");
        this.nullZone = SceneSerializer.getAttributeValue(node, "NullZone");
        this.moveTime = SceneSerializer.getAttributeValue(node, "Movetime");
        this.summer = SceneSerializer.getAttributeValue(node, "Summer");
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 5) {
                case 0: {
                    ((C3PointDialog)this.propertiesDialog).txtSetpoint.setText(value);
                    this.setpoint = value;
                    break;
                }
                case 1: {
                    ((C3PointDialog)this.propertiesDialog).txtSetpointH.setText(value);
                    this.setpointH = value;
                    break;
                }
                case 2: {
                    ((C3PointDialog)this.propertiesDialog).txtSetpointL.setText(value);
                    this.setpointL = value;
                    break;
                }
                case 3: {
                    if ((double)Float.parseFloat(value) == 0.0) {
                        ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(false);
                    } else {
                        ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(true);
                    }
                    this.summer = value;
                    break;
                }
                case 4: {
                    ((C3PointDialog)this.propertiesDialog).txtMovetime.setText(value);
                    this.moveTime = value;
                    break;
                }
                case 5: {
                    ((C3PointDialog)this.propertiesDialog).txtNullzone.setText(value);
                    this.nullZone = value;
                    break;
                }
                case 6: {
                    int status = Integer.parseInt(value);
                    switch (status) {
                        case 0: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Opening");
                            break;
                        }
                        case 1: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Closing");
                            break;
                        }
                        case 2: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Full Open");
                            break;
                        }
                        case 3: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Full Closed");
                            break;
                        }
                        case 4: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Stopped");
                        }
                    }
                    break;
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    public String getAddress() {
        String newAddress = ((C3PointDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }
}

