/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import nodes.AFONodeWidget;
import nodes.AFOSystemManager;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.ClimaticCurveDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;
import sceneManager.AFOPin;

public class ClimaticCurveNode
extends GenericNode {
    private Integer climateID = 1;
    private DefaultTableModel climateTableModel;
    public boolean propertyChanged = false;
    private static AppOptions options = new AppOptions();
    public static final int CLIMATIC_ID = 22;

    public ClimaticCurveNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.ClimaticCurve;
        this.addressSpace = 13;
        this.numberOfInputs = 1;
        this.climateTableModel = new DefaultTableModel(new Object[][]{{"0", "0"}, {"0", "0"}}, new String[]{"T Esterna", "Setpoint"});
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.calculateClimaticID();
        options.LoadOptions();
        this.currentLocale = new Locale(ClimaticCurveNode.options.language, ClimaticCurveNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        int i = 0;
        this.codici.add(i++, "ClimaticCurve");
        this.codici.add(i++, "IO_ClimaticCurve");
        this.codici.add(i++, "NofPoints_ClimaticCurve");
        this.codici.add(i++, "P1_TExt");
        this.codici.add(i++, "P1_SP");
        this.codici.add(i++, "P2_TExt");
        this.codici.add(i++, "P2_SP");
        this.codici.add(i++, "P3_TExt");
        this.codici.add(i++, "P3_SP");
        this.codici.add(i++, "P4_Text");
        this.codici.add(i++, "P4_SP");
        this.codici.add(i++, "P5_TExt");
        this.codici.add(i++, "P5_SP");
        this.setList(this.codici);
        ((ClimaticCurveDialog)this.propertiesDialog).clearTable();
        ClimaticCurveNode.tableClear(this.climateTableModel);
    }

    public String getAddress() {
        String newAddress = ((ClimaticCurveDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    public void calculateClimaticID() {
        ArrayList list = (ArrayList)((MyGraphPinScene)this.scene).getManager().getProject().getSubSystemList();
        this.climateID = 0;
        for (AFOSystemManager sm : list) {
            for (AFONode node : sm.getNodeList()) {
                Integer newID;
                if (node.getBlockType() != CommonDefinitions.blockTypes.ClimaticCurve || (newID = ((ClimaticCurveNode)node).getClimateID()) <= this.climateID) continue;
                this.climateID = newID;
            }
        }
        this.climateID = this.climateID + 1;
        ((AFONodeWidget)this.widget).setSubType(this.climateID.toString());
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Climatic");
        this.getScene().addNode(this);
        String pinLabel = "Out";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "In";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Comp.";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ++this.numberOfInputs;
        ((AFONodeWidget)this.widget).setSubType(this.getClimateID().toString());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new ClimaticCurveDialog(null, true, this);
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        ClimaticCurveNode.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1)});
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        ClimaticCurveDialog dlg = (ClimaticCurveDialog)this.propertiesDialog;
        dlg.btnDelete.setEnabled(!isConnected);
        dlg.btnInsert.setEnabled(!isConnected);
        dlg.tableClimatic.setEnabled(!isConnected);
    }

    private void updateDialogTable() {
        DefaultTableModel dialogTable = (DefaultTableModel)((ClimaticCurveDialog)this.propertiesDialog).tableClimatic.getModel();
        ClimaticCurveNode.tableCopy(dialogTable, this.climateTableModel);
        ((ClimaticCurveDialog)this.propertiesDialog).tableClimatic.setModel(dialogTable);
    }

    private void updateInternalTable() {
        DefaultTableModel dialogTable = (DefaultTableModel)((ClimaticCurveDialog)this.propertiesDialog).tableClimatic.getModel();
        ClimaticCurveNode.tableCopy(this.climateTableModel, dialogTable);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((ClimaticCurveDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((ClimaticCurveDialog)this.propertiesDialog).txtClimaticID.setText(this.getClimateID().toString());
        ((ClimaticCurveDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.updateDialogTable();
        ((ClimaticCurveDialog)this.propertiesDialog).fieldChanged = false;
        this.requestData();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((ClimaticCurveDialog)this.propertiesDialog).getReturnStatus() == 1) {
            this.setClimateID(Integer.parseInt(((ClimaticCurveDialog)this.propertiesDialog).txtClimaticID.getText()));
            ((AFONodeWidget)this.widget).setSubType(this.getClimateID().toString());
            this.updateInternalTable();
            if (((ClimaticCurveDialog)this.propertiesDialog).fieldChanged) {
                this.scene.sceneChanged();
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                if (this.kernel == null || !this.kernel.isConnected()) {
                    return;
                }
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.climateTableModel.getRowCount() + " >";
                    this.commandQueue.add(msg);
                    for (int i = 0; i < this.climateTableModel.getRowCount(); ++i) {
                        msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.climateTableModel.getValueAt(i, 0) + " >";
                        this.commandQueue.add(msg);
                        msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.climateTableModel.getValueAt(i, 1) + " >";
                        this.commandQueue.add(msg);
                    }
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    private void clearTableModel() {
        while (this.climateTableModel.getRowCount() > 0) {
            this.climateTableModel.removeRow(0);
        }
    }

    public Integer getClimateID() {
        return this.climateID;
    }

    public void setClimateID(Integer climateID) {
        this.climateID = climateID;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        DefaultTableModel model = this.climateTableModel;
        retVal = retVal + "22 " + this.getCommonData();
        float type = Float.parseFloat("" + model.getRowCount());
        retVal = retVal + type + " ";
        for (int i = 0; i < model.getRowCount(); ++i) {
            retVal = retVal + Float.parseFloat("" + model.getValueAt(i, 0)) + " " + Float.parseFloat("" + model.getValueAt(i, 1)) + " ";
        }
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "ClimaticID", this.climateID.toString());
        SceneSerializer.setAttribute(document, nodeElement, "NofRows", "" + this.climateTableModel.getRowCount());
        for (int i = 0; i < this.climateTableModel.getRowCount(); ++i) {
            Element climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "TempExt", this.climateTableModel.getValueAt(i, 0).toString());
            SceneSerializer.setAttribute(document, climaticElement, "TempMnd", this.climateTableModel.getValueAt(i, 1).toString());
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.climateID = Integer.parseInt(SceneSerializer.getAttributeValue(node, "ClimaticID"));
        int row = 0;
        this.clearTableModel();
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("TableRow")) continue;
            String tExt = SceneSerializer.getAttributeValue(element, "TempExt");
            String tMnd = SceneSerializer.getAttributeValue(element, "TempMnd");
            this.climateTableModel.addRow((Object[])new Object[0][]);
            this.climateTableModel.setValueAt(Float.valueOf(Float.parseFloat(tExt)), row, 0);
            this.climateTableModel.setValueAt(Float.valueOf(Float.parseFloat(tMnd)), row, 1);
            ++row;
        }
        this.propertiesDialog.validate();
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            int addr = msgAddress - (Integer)this.addressList.get(0) - 2;
            if (addr < 0) {
                return true;
            }
            switch (addr) {
                case 0: {
                    ClimaticCurveNode.tableClear(this.climateTableModel);
                    int nOfRows = (int)Float.parseFloat(value);
                    for (int i = 0; i < nOfRows; ++i) {
                        this.climateTableModel.addRow((Object[])new Object[0][]);
                        this.climateTableModel.setValueAt(-100.0, i, 0);
                        this.climateTableModel.setValueAt(-100.0, i, 1);
                    }
                    break;
                }
                default: {
                    int row = --addr / 2;
                    int column = addr % 2;
                    if (row >= this.climateTableModel.getRowCount()) {
                        return true;
                    }
                    float fval = Float.parseFloat(value);
                    this.climateTableModel.setValueAt(Float.valueOf(fval), row, column);
                }
            }
            this.updateDialogTable();
        }
        return true;
    }
}

