/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class ClockNode
extends GenericNode {
    private String m_TimerID = "0";
    public static final int CLOCK_ID = 12;

    public ClockNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.Clock;
        this.numberOfInputs = 0;
        this.addressSpace = 4;
        this.codici = new ArrayList();
        this.codici.add(0, "Clock");
        this.codici.add(1, "Digital_Clock");
        this.codici.add(2, "Analog_Clock");
        this.codici.add(3, "TimerID_Clock");
        this.setList(this.codici);
        this.CreateWidget();
        this.CreatePropertiesDialog();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClockNode.this.control();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClockNode.this.control();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClockNode.this.control();
            }
        });
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), false).booleanValue()) {
            ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.m_TimerID);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setEnabled(!this.kernelConnected);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            if (((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                String temp;
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.propertiesDialog.setVisible(false);
                this.scene.sceneChanged();
                this.m_TimerID = temp = "" + (int)Float.parseFloat(((GenericBlockDialog)this.propertiesDialog).txtField1.getText());
                ((AFONodeWidget)this.widget).setSubType(this.m_TimerID);
                if (this.kernel != null && this.kernel.isConnected()) {
                    this.commandQueue.clear();
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + 3) + " " + this.m_TimerID + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                }
            }
        }
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("TimerID :");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.m_TimerID);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Clock");
        this.getScene().addNode(this);
        String pinLabel = "Digital";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Analog";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.m_TimerID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + this.m_TimerID);
        retVal = retVal + "12 " + this.getCommonData() + type;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "TimerID", this.m_TimerID);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            String temp;
            this.m_TimerID = temp = "" + (int)Float.parseFloat(SceneSerializer.getAttributeValue(node, "TimerID"));
            ((AFONodeWidget)this.widget).setSubType(this.m_TimerID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_TimerID = "0";
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
            this.m_TimerID = cmd.getValue("TOKEN3");
            ((AFONodeWidget)this.widget).setSubType(this.m_TimerID);
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.m_TimerID);
        }
        return true;
    }
}

