/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;

public class CommentNode
extends GenericNode {
    private WidgetAction moveAction;

    public CommentNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.Comment;
        this.moveAction = ActionFactory.createAlignWithMoveAction((LayerWidget)scene.mainLayer, (LayerWidget)scene.interactionLayer, null, (boolean)false);
        this.CreateWidget();
        this.addressSpace = 0;
    }

    private void CreateWidget() {
        this.widget = new LabelWidget((Scene)this.scene, this.label);
        this.widget.setOpaque(true);
        this.widget.setBackground((Paint)Color.LIGHT_GRAY);
        this.widget.setBorder(BorderFactory.createEmptyBorder((int)8));
        this.widget.setFont(new Font("SansSerif", 0, 14));
        this.widget.getActions().addAction(this.editorAction);
        this.widget.getActions().addAction(this.moveAction);
        this.widget = this.getScene().addNode(this);
        this.getScene().revalidate();
    }

    @Override
    public void setComment(String comment) {
        ((LabelWidget)this.widget).setLabel(comment);
    }

    @Override
    public String getComment() {
        return ((LabelWidget)this.widget).getLabel();
    }

    @Override
    public Widget getOverallWidget() {
        return this.widget;
    }

    private static class RenameEditor
    implements TextFieldInplaceEditor {
        private RenameEditor() {
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return ((LabelWidget)widget).getLabel();
        }

        public void setText(Widget widget, String text) {
            ((LabelWidget)widget).setLabel(text);
        }
    }
}

