/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.DelayDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class DelayNode
extends GenericNode {
    private String delayAmount = "1";
    private String timeBase = "0";
    private String defVal = "0.0";
    private static AppOptions options = new AppOptions();
    public static final int DELAY_ID = 21;

    public DelayNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.Delay;
        this.addressSpace = 6;
        this.numberOfInputs = 2;
        this.CreatePropertiesDialog();
        options.LoadOptions();
        this.currentLocale = new Locale(DelayNode.options.language, DelayNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        this.codici.add(0, "Delay");
        this.codici.add(1, "OUT_Delay");
        this.codici.add(2, "DelayValue");
        this.codici.add(3, "Scale");
        this.codici.add(4, "DefaultValue");
        this.codici.add(5, "Reset");
        this.setList(this.codici);
        this.CreateWidget();
    }

    public String getAddress() {
        String newAddress = ((DelayDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Delay Node");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "In";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Reset";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        String times = "";
        if (this.timeBase.equals("0")) {
            times = "sec";
        }
        if (this.timeBase.equals("1")) {
            times = "min";
        }
        if (this.timeBase.equals("2")) {
            times = "h";
        }
        ((AFONodeWidget)this.widget).setSubType(this.delayAmount + " " + times);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new DelayDialog(null, true, this);
        options.LoadOptions();
        this.currentLocale = new Locale(DelayNode.options.language, DelayNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((DelayDialog)this.propertiesDialog).lblRit.setText(this.message.getString("ritsec"));
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.delayAmount));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.removeAllItems();
        ((DelayDialog)this.propertiesDialog).comboTimeBase.addItem(this.message.getString("secondi"));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.addItem(this.message.getString("minuti"));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.addItem(this.message.getString("ore"));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.setSelectedIndex(Integer.parseInt(this.timeBase));
        ((DelayDialog)this.propertiesDialog).txtDefVal.setText(this.defVal);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((DelayDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.delayAmount));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.setSelectedIndex(Integer.parseInt(this.timeBase));
        ((DelayDialog)this.propertiesDialog).txtDefVal.setText(this.defVal);
        ((DelayDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((DelayDialog)this.propertiesDialog).showDialog();
        if (((DelayDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((DelayDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.delayAmount = ((DelayDialog)this.propertiesDialog).spnrDelay.getValue().toString();
            this.timeBase = "" + ((DelayDialog)this.propertiesDialog).comboTimeBase.getSelectedIndex();
            String tim = "";
            if (this.timeBase.equals("0")) {
                tim = "sec";
            }
            if (this.timeBase.equals("1")) {
                tim = "min";
            }
            if (this.timeBase.equals("2")) {
                tim = "h";
            }
            ((AFONodeWidget)this.widget).setSubType(this.delayAmount + " " + tim);
            this.defVal = ((DelayDialog)this.propertiesDialog).txtDefVal.getText();
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + Float.parseFloat(this.delayAmount) + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(3) + " " + Float.parseFloat(this.timeBase) + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(4) + " " + Float.parseFloat(this.defVal) + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(5) + " 1.0 >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            } else {
                this.scene.sceneChanged();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat(this.delayAmount);
        retVal = retVal + "21 " + this.getCommonData();
        retVal = retVal + this.delayAmount + " " + this.timeBase + " " + this.defVal;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "delay", this.delayAmount);
        SceneSerializer.setAttribute(document, nodeElement, "timebase", this.timeBase);
        SceneSerializer.setAttribute(document, nodeElement, "defval", this.defVal);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            this.delayAmount = SceneSerializer.getAttributeValue(node, "delay");
            this.timeBase = SceneSerializer.getAttributeValue(node, "timebase");
            this.defVal = SceneSerializer.getAttributeValue(node, "defval");
        }
        catch (Exception ex) {
            this.delayAmount = "1";
            this.timeBase = "0";
            this.defVal = "0.0";
            ex.printStackTrace();
        }
        String time = "";
        if (this.timeBase.equals("0")) {
            time = "sec";
        }
        if (this.timeBase.equals("1")) {
            time = "min";
        }
        if (this.timeBase.equals("2")) {
            time = "h";
        }
        ((AFONodeWidget)this.widget).setSubType(this.delayAmount + " " + time);
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            int delay = (int)Float.parseFloat(cmd.getValue("TOKEN3"));
            this.delayAmount = "" + delay;
            ((AFONodeWidget)this.widget).setSubType(this.delayAmount);
            ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.delayAmount));
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
            this.timeBase = "" + (int)Float.parseFloat(cmd.getValue("TOKEN3"));
            ((DelayDialog)this.propertiesDialog).comboTimeBase.setSelectedIndex(Integer.parseInt(this.timeBase));
            ((DelayDialog)this.propertiesDialog).validate();
            ((DelayDialog)this.propertiesDialog).fieldChanged = false;
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(4)).toString())) {
            this.defVal = cmd.getValue("TOKEN3");
            ((DelayDialog)this.propertiesDialog).txtDefVal.setText(this.defVal);
            ((DelayDialog)this.propertiesDialog).validate();
        }
        return true;
    }
}

