/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class DipSwitchNode
extends DeviceNode {
    private String type;
    public static final int DipSwitch_ID = 27;
    int rs485ReservedBits = 0;

    public DipSwitchNode(String id, String label, String analogID, AFOGraphPinScene scene) {
        super(id, label, analogID, scene);
        this.type = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel1.setText("RS485 Bits:");
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        for (int i = 0; i < 9; ++i) {
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem("" + i);
        }
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        this.blockType = CommonDefinitions.blockTypes.DipSwitch;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 10;
        this.codici = new ArrayList();
        this.codici.add(0, "DipSwitch");
        this.codici.add(1, "DS1");
        this.codici.add(2, "DS2");
        this.codici.add(3, "DS3");
        this.codici.add(4, "DS4");
        this.codici.add(5, "DS5");
        this.codici.add(6, "DS6");
        this.codici.add(7, "DS7");
        this.codici.add(8, "DS8");
        this.codici.add(9, "RS485Bits");
        this.setList(this.codici);
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), false).booleanValue()) {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        this.deviceID = "";
        for (int i = 0; i < 8; ++i) {
            String pinLabel = "" + (i + 1);
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT" + (i + 1));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(this.rs485ReservedBits);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setEnabled(!this.kernelConnected);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1 && ((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.rs485ReservedBits = ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.getSelectedIndex();
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "27 " + this.getCommonData() + this.rs485ReservedBits;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "ReservedBits", "" + this.rs485ReservedBits);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        this.rs485ReservedBits = Integer.parseInt(SceneSerializer.getAttributeValue(node, "ReservedBits"));
    }
}

