/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import Util.ProgressBar;
import VisiProg.AppOptions;
import connection.ICmd;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.SerialKernel;
import connection.XMLCommands.Cmd;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import nodes.AFOSystemManager;
import nodes.AfoDBDao;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.SingleValDataEntry;
import nodes.devices.ScopeNode;
import nodes.devices.SubSystemIONode;
import org.jfree.data.time.Second;
import org.netbeans.api.visual.action.WidgetAction;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;
import sceneManager.AFOPin;
import sceneManager.TextEditorEvent;
import sceneManager.TextEditorEventListener;

public class GenericNode
extends AFONode
implements IKernelEventListener,
TextEditorEventListener {
    protected int configSlotsUsed = 1;
    protected static final String deviceConfigFormat = "Device%02d=";
    private int iniFileBlockNumber;
    protected static final int MAX_NUM_INPUT_PIN = 50;
    protected static final int MAX_NUM_OUTPUT_PIN = 50;
    protected SerialKernel kernel;
    protected int numberOfInputs = 0;
    public boolean kernelConnected = false;
    protected ArrayList<String> commandQueue;
    protected Boolean sendingCommandQueue = false;
    protected Boolean closePropertiesDialogOnCommandQueueEmpty = true;
    protected final int MAX_MSG_SEND_RETRIES = 3;
    protected int msgSendRetries = 0;
    protected boolean collectPlantDataStatus = false;
    private ProgressBar bar = new ProgressBar(null, false);
    Locale currentLocale;
    private AppOptions options = new AppOptions();
    ResourceBundle message;
    private AFOSystemManager sysManager = null;
    private AfoDBDao database;
    public static final int MAX_DEVICE_ADDRESS_SPACE = 10;
    public static final int MAX_BLOCK_ADDRESS_SPACE = 25;
    public static final int MAX_BLOCK_ADDRESS_SPACE_MONITOR2 = 50;
    public ArrayList<String> codici;

    public GenericNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.addressSpace = 0;
        this.addressList = new ArrayList();
        this.commandQueue = new ArrayList();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        if (this.textEditor != null) {
            this.textEditor.addEventListener(this);
        }
    }

    public void setDatabase(AfoDBDao newDB) {
        this.database = newDB;
        this.addNodeToDB();
    }

    public Boolean controlAddress(String address, Boolean isMonitor) {
        if (this.addressList.size() == 0) {
            return false;
        }
        if (this.addressList.size() == 0 || address.equals(((Integer)this.addressList.get(0)).toString())) {
            return false;
        }
        if (this.sysManager.existAddress(address, isMonitor)) {
            return true;
        }
        return false;
    }

    public void setSysManager(AFOSystemManager sysManager) {
        this.sysManager = sysManager;
    }

    protected void addNodeToDB() {
        if (this.database == null) {
            return;
        }
        try {
            if (this.addressList == null || this.addressList.size() == 0) {
                return;
            }
            if (!this.database.existsDevice((Integer)this.addressList.get(0))) {
                this.database.saveDeviceRecord(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getConfigString(int deviceIndex) throws Exception {
        throw new Exception(this.message.getString("istclasse"));
    }

    public ArrayList<String> getList() {
        return this.codici;
    }

    public void setList(ArrayList<String> codici) {
        this.codici = codici;
    }

    public boolean parseCmd(ICmd com) {
        return false;
    }

    public void resetPinValues() {
        for (AFOPin checkedPin : this.pinList) {
            if (checkedPin.isBusPin() || checkedPin.getParentNode() instanceof SubSystemIONode) continue;
            this.setPinValue(checkedPin.getPinIDString(), "-100.0");
        }
    }

    @Override
    public CommonDefinitions.blockTypes getBlockType() {
        return this.blockType;
    }

    protected boolean isMsgForMe(ICmd com) {
        int msgAddr = 0;
        if (!com.containsAttribute("ADDRESS")) {
            return false;
        }
        msgAddr = Integer.parseInt(com.getValue("ADDRESS"));
        return msgAddr >= (Integer)this.addressList.get(0) && msgAddr < (Integer)this.addressList.get(0) + this.addressSpace;
    }

    protected boolean parseStandardBlockCmd(ICmd com) {
        try {
            String output;
            AFOPin pin;
            String tempVal;
            String input;
            int i;
            if (!this.isMsgForMe(com)) {
                return false;
            }
            for (i = 0; i < 50 && com.containsAttribute(input = "IN" + (i + 1)); ++i) {
                tempVal = com.getValue(input);
                this.setPinValue(input, tempVal);
                try {
                    pin = this.getPinByID(input);
                    if (pin == null) continue;
                    this.updateDB(Float.parseFloat(tempVal), 2, input);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            for (i = 0; i < 50 && com.containsAttribute(output = "OUT" + (i + 1)); ++i) {
                tempVal = com.getValue(output);
                this.setPinValue(output, tempVal);
                try {
                    this.setTargetPinValue(output, tempVal);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.sendValueToChart(output, tempVal);
                try {
                    pin = this.getPinByID(output);
                    if (pin == null) continue;
                    this.updateDB(Float.parseFloat(tempVal), 3, output);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            this.getScene().validate();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, this.message.getString("errinter"), this.message.getString("er"), 0);
            return false;
        }
    }

    public boolean parseBlockCmd(ICmd com) {
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.Subsystem) || this.blockType.equals((Object)CommonDefinitions.blockTypes.IN) || this.blockType.equals((Object)CommonDefinitions.blockTypes.OUT) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Comment) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Scope)) {
            return false;
        }
        return this.parseStandardBlockCmd(com);
    }

    protected AFOPin getPinByID(String pinIdx) {
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinIDString().equals(pinIdx)) continue;
            return pin;
        }
        return null;
    }

    public void setPinValue(String pinIdx, String value) {
        try {
            this.getPinByID(pinIdx).setValue(value);
            this.getScene().validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPinValue(String pinIdx) {
        try {
            return this.getPinByID(pinIdx).getValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public List<Integer> getAddressList() {
        return this.addressList;
    }

    public void generateAddresses(Integer startAddress) {
        switch (this.blockType) {
            case Comment: {
                this.addressSpace = 0;
                return;
            }
        }
        try {
            int i;
            for (i = 0; i < this.getAddressSpace(); ++i) {
                this.addressList.add(new Integer(startAddress + i));
                if (i >= this.pinList.size()) continue;
                ((AFOPin)this.pinList.get((int)i)).pinAddress = startAddress + i;
            }
            if (this.pinList.size() > this.getAddressSpace() + 1) {
                for (i = this.getAddressSpace(); i < this.pinList.size(); ++i) {
                    if (((AFOPin)this.pinList.get(i)).isBusPin()) continue;
                    ((AFOPin)this.pinList.get((int)i)).pinAddress = ((AFOPin)this.pinList.get((int)(this.getAddressSpace() - 1))).pinAddress;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.addressList.add(new Integer(0));
        }
    }

    public int getConfigSlotsUsed() {
        return this.configSlotsUsed;
    }

    protected String boolToIntString(boolean val) {
        if (val) {
            return "1";
        }
        return "0";
    }

    protected boolean intStringToBool(String val) {
        return val.equalsIgnoreCase("1");
    }

    protected Integer boolToInteger(boolean val) {
        Integer retVal = val ? new Integer(1) : new Integer(0);
        return retVal;
    }

    protected String getCommonData() {
        int inputNumber = 1;
        boolean outputNumber = true;
        String retVal = "";
        retVal = retVal + Integer.toString((Integer)this.addressList.get(0)) + " " + this.numberOfInputs + " ";
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() == AFOPin.E_PinType.PIN_OUTPUT) continue;
            if (this.getScene().findPinEdges(pinExamined, true, true).size() == 0) {
                retVal = retVal + "0-0 ";
                continue;
            }
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_INPUT) continue;
            retVal = retVal + this.getCommonInputData((MyGraphPinScene)this.scene, pinExamined, inputNumber);
            ++inputNumber;
        }
        return retVal;
    }

    public String getCommonInputData(MyGraphPinScene pinScene, AFOPin inputPin, int inputNumber) {
        String retVal = "";
        Object[] edgesArray = pinScene.findPinEdges(inputPin, false, true).toArray();
        if (edgesArray.length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("erringress"));
            return inputNumber + "-" + "0";
        }
        AFOEdge edge = (AFOEdge)edgesArray[0];
        AFOPin sourcePin = (AFOPin)pinScene.getEdgeSource(edge);
        GenericNode sourceNode = (GenericNode)pinScene.getPinNode(sourcePin);
        if (sourceNode.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN)) {
            Object[] edges = ((SubSystemIONode)sourceNode).getParentScene().findPinEdges(((SubSystemIONode)sourceNode).getParentPin(), false, true).toArray();
            if (edges.length == 0) {
                retVal = "0-0 ";
            } else {
                for (int i = 0; i < edges.length; ++i) {
                    AFOPin sourceParentPin = ((SubSystemIONode)sourceNode).getParentPin();
                    retVal = this.getCommonInputData(((SubSystemIONode)sourceNode).getParentScene(), sourceParentPin, inputNumber);
                }
            }
        } else if (sourceNode instanceof AFOSystemManager) {
            SubSystemIONode ioNode = ((AFOSystemManager)sourceNode).getPinChildNode(sourcePin);
            try {
                retVal = this.getCommonInputData((MyGraphPinScene)ioNode.getScene(), ioNode.getPinAt(0), inputNumber);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (sourceNode.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal() || sourceNode.getBlockType().ordinal() <= CommonDefinitions.blockTypes.ModbusOUT.ordinal()) {
            int pinIndex = sourceNode.getOutputPinChannel(sourcePin);
            retVal = retVal + sourceNode.getAddressList().get(0) + "-" + pinIndex + " ";
        }
        return retVal;
    }

    private int getOutputPinChannel(AFOPin pin) {
        int channelNo = 0;
        for (AFOPin checkPin : this.pinList) {
            if (checkPin.equals(pin)) {
                return channelNo;
            }
            if (checkPin.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            ++channelNo;
        }
        return 0;
    }

    private List<Integer> getIOAddress(boolean isInput, SubSystemIONode ioNode) {
        ArrayList<Integer> retVal;
        block9: {
            retVal = new ArrayList<Integer>();
            try {
                Object[] edges = ioNode.getParentScene().findPinEdges(ioNode.getParentPin(), true, true).toArray();
                if (edges.length == 0) {
                    return retVal;
                }
                if (isInput) {
                    for (int i = 0; i < edges.length; ++i) {
                        AFOPin sourcePin = (AFOPin)ioNode.getParentScene().getEdgeSource((AFOEdge)edges[i]);
                        GenericNode sourceNode = (GenericNode)ioNode.getParentScene().getPinNode(sourcePin);
                        if (((AFONode)sourceNode).getBlockType().equals((Object)CommonDefinitions.blockTypes.IN)) {
                            if (this.getIOAddress(true, (SubSystemIONode)sourceNode).size() <= 0) continue;
                            retVal.add((int)this.getIOAddress(true, (SubSystemIONode)sourceNode).get(0));
                            continue;
                        }
                        retVal.add(new Integer(sourcePin.pinAddress));
                    }
                    break block9;
                }
                for (int i = 0; i < edges.length; ++i) {
                    AFOPin targetPin = (AFOPin)ioNode.getParentScene().getEdgeTarget((AFOEdge)edges[i]);
                    GenericNode targetNode = (GenericNode)ioNode.getParentScene().getPinNode(targetPin);
                    if (targetNode instanceof SubSystemIONode) {
                        List<Integer> subAddresses = this.getIOAddress(false, (SubSystemIONode)targetNode);
                        for (Integer subAddr : subAddresses) {
                            retVal.add(subAddr);
                        }
                        continue;
                    }
                    if (((AFONode)targetNode).getBlockType().ordinal() > CommonDefinitions.blockTypes.ModbusOUT.ordinal()) continue;
                    retVal.add(new Integer(targetPin.pinAddress));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retVal;
    }

    public int getIniFileBlockNumber() {
        return this.iniFileBlockNumber;
    }

    public void setIniFileBlockNumber(int iniFileBlockNumber) {
        this.iniFileBlockNumber = iniFileBlockNumber;
    }

    public void addKeyEventManager(WidgetAction.Adapter action) {
        this.widget.getActions().addAction((WidgetAction)action);
    }

    protected void setTargetPinValue(AFOPin sourcePin, String value) {
        try {
            if (this.scene.findPinEdges(sourcePin, true, false) == null) {
                return;
            }
            Object[] edgeArray = this.getScene().findPinEdges(sourcePin, true, false).toArray();
            for (int i = 0; i < edgeArray.length; ++i) {
                AFOPin targetPin = (AFOPin)this.getScene().getEdgeTarget((AFOEdge)edgeArray[i]);
                if (targetPin == null) continue;
                if (targetPin.getParentNode() instanceof AFOSystemManager) {
                    targetPin.setValue(value);
                    SubSystemIONode ioNode = ((AFOSystemManager)targetPin.getParentNode()).getPinChildNode(targetPin);
                    ioNode.setPinValue("IN1", value);
                    AFOPin trgPin = ioNode.getPinByID("IN1");
                    if (trgPin == null) {
                        return;
                    }
                    ioNode.setTargetPinValue(trgPin, value);
                    continue;
                }
                if (!(targetPin.getParentNode() instanceof SubSystemIONode)) continue;
                targetPin.setValue(value);
                AFOPin parentPin = ((SubSystemIONode)targetPin.getParentNode()).getParentPin();
                AFOSystemManager sm = (AFOSystemManager)parentPin.getParentNode();
                parentPin.setValue(value);
                sm.sendValueToChart(parentPin, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setTargetPinValue(String pinIdx, String value) {
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinIDString().equals(pinIdx)) continue;
            this.setTargetPinValue(pin, value);
            break;
        }
        this.getScene().validate();
    }

    public void setKernel(IKernel kernel) {
        this.kernel = (SerialKernel)kernel;
        this.kernel.addKernelEventListener(this);
    }

    protected Cmd generateBasicNodeCommand() {
        Cmd com = new Cmd("DEVICE");
        com.putValue("COMMAND", "BlockCommand");
        com.putValue("ADDRESS", "100000");
        com.putValue("SUBADDR", ((Integer)this.addressList.get(0)).toString());
        return com;
    }

    public void setConnectionStatus(boolean isConnected) {
    }

    protected void sendCommand(Cmd com) {
        try {
            this.kernel.sendCommand(com.toString());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, this.message.getString("errinvio") + ex.toString());
            ex.printStackTrace();
        }
    }

    public void sendValueToChart(String pinIdx, String val) {
        try {
            AFOPin pin = this.getPinByID(pinIdx);
            Object[] edgesArray = this.scene.findPinEdges(pin, true, false).toArray();
            for (int i = 0; i < edgesArray.length; ++i) {
                AFOEdge edge = (AFOEdge)edgesArray[i];
                AFONode node = ((AFOPin)this.scene.getEdgeTarget(edge)).getParentNode();
                if (node instanceof ScopeNode) {
                    ((ScopeNode)node).addValue(val);
                    continue;
                }
                if (node instanceof SubSystemIONode) {
                    AFONode nd = ((SubSystemIONode)node).getParentPin().getParentNode();
                    for (AFOPin pn : ((GenericNode)nd).getPinList()) {
                        ((GenericNode)nd).sendValueToChart(pn.getPinIDString(), val);
                    }
                    continue;
                }
                if (!(node instanceof AFOSystemManager)) continue;
                AFOPin destPin = (AFOPin)this.scene.getEdgeTarget(edge);
                SubSystemIONode ioNode = ((AFOSystemManager)node).getPinChildNode(destPin);
                for (AFOPin pn : ioNode.getPinList()) {
                    ioNode.sendValueToChart(pn.getPinIDString(), val);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendValueToChart(AFOPin pin, String val) {
        try {
            List<AFONode> nodeList = this.scene.getNodesConnectedAtPin(pin);
            for (AFONode node : nodeList) {
                if (!(node instanceof ScopeNode)) continue;
                ((ScopeNode)node).addValue(val);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getAddressSpace() {
        return this.addressSpace;
    }

    public boolean execCommand(ICmd cmd) throws Exception {
        return false;
    }

    protected void regenerateAddressList(int addressBase) {
        this.addressList.clear();
        for (int i = 0; i < this.addressSpace; ++i) {
            this.addressList.add(addressBase + i);
        }
    }

    public void requestData() throws Exception {
        if (this.kernel != null && this.kernel.isConnected()) {
            if (!this.sendingCommandQueue.booleanValue()) {
                this.commandQueue.clear();
                for (int i = 1; i < this.addressSpace; ++i) {
                    String msg = "<BL get " + this.addressList.get(i) + " >";
                    this.commandQueue.add(msg);
                }
                this.sendMessageQueue(false);
            } else {
                JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
            }
        }
    }

    public void requestData(int offset) throws Exception {
        if (this.kernel != null && this.kernel.isConnected()) {
            if (!this.sendingCommandQueue.booleanValue()) {
                this.commandQueue.clear();
                for (int i = 1; i < offset; ++i) {
                    String msg = "<BL get " + this.addressList.get(i) + " >";
                    this.commandQueue.add(msg);
                }
                this.sendMessageQueue(false);
            } else {
                JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
            }
        }
    }

    public void updateBlockIO() throws Exception {
        if (this.kernel != null && this.kernel.isConnected()) {
            if (!this.sendingCommandQueue.booleanValue()) {
                this.commandQueue.clear();
                String msg = "<BL get " + this.addressList.get(0) + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(false);
            } else {
                JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
            }
        }
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Kernel Disconnected")) {
            this.kernelConnected = false;
            this.setConnectionStatus(this.kernelConnected);
        } else if (evt.getEventType().equals("Kernel Connected")) {
            this.kernelConnected = true;
            this.msgSendRetries = 0;
            this.sendingCommandQueue = false;
            this.commandQueue.clear();
        } else if (evt.getEventType().equals("Command Executed") || evt.getEventType().equals("Valid Reply Received")) {
            if (this.sendingCommandQueue.booleanValue()) {
                System.out.println(this.addressList.size());
                System.out.println(this.commandQueue.size());
                System.out.println((this.addressList.size() - this.commandQueue.size()) * 100 / this.addressList.size());
                this.bar.setProgress((this.addressList.size() - (this.commandQueue.size() - 1)) * 100 / this.addressList.size());
                this.commandQueue.remove(0);
                if (this.commandQueue.size() > 0) {
                    String msg = this.commandQueue.get(0);
                    this.kernel.sendCommand(msg);
                } else {
                    if (this.closePropertiesDialogOnCommandQueueEmpty.booleanValue()) {
                        this.propertiesDialog.setVisible(false);
                    }
                    this.bar.setVisible(false);
                    this.sendingCommandQueue = false;
                    this.kernel.collectPlantData(this.collectPlantDataStatus);
                }
            }
        } else if ((evt.getEventType().equals("Timeout on command") || evt.getEventType().equals("Command Not Executed")) && this.sendingCommandQueue.booleanValue()) {
            if (this.msgSendRetries < 3) {
                ++this.msgSendRetries;
                String msg = this.commandQueue.get(0);
                this.kernel.sendCommand(msg);
            } else {
                JOptionPane.showMessageDialog(null, this.message.getString("errsend") + this.commandQueue.get(0), this.message.getString("er"), 0);
                this.msgSendRetries = 0;
                this.commandQueue.clear();
                this.sendingCommandQueue = false;
                this.bar.setVisible(false);
            }
        }
    }

    protected void sendMessageQueue(Boolean closePropertiesOnExit) {
        if (this.commandQueue.isEmpty()) {
            return;
        }
        boolean sendHash = false;
        for (String st : this.commandQueue) {
            if (!st.toLowerCase().contains("set")) continue;
            sendHash = true;
            break;
        }
        if (sendHash) {
            this.commandQueue.add(this.kernel.getHashCommand());
        }
        this.sendingCommandQueue = true;
        this.closePropertiesDialogOnCommandQueueEmpty = closePropertiesOnExit;
        this.msgSendRetries = 0;
        this.collectPlantDataStatus = this.kernel.getCollectStatus();
        this.kernel.collectPlantData(false);
        this.kernel.sendCommand(this.commandQueue.get(0));
        this.bar.setVisible(true);
        this.bar.setProgress(0);
        this.bar.setAlwaysOnTop(true);
    }

    public ProgressBar getProgressBar() {
        return this.bar;
    }

    protected void updateDB(float val, int tableIndex, String ioID) {
        if (this.database == null || !this.database.isDBEnabled()) {
            return;
        }
        try {
            Second now = new Second();
            Timestamp ts = new Timestamp(now.getFirstMillisecond());
            SingleValDataEntry entry = new SingleValDataEntry(0, (Integer)this.addressList.get(0), ioID, "", ts, val);
            this.database.saveSingleDataEntryRecord(entry, tableIndex);
        }
        catch (Exception ex) {
            System.out.println("ERRORE in aggiornamento DB\r\n" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void textEditorEventOccurred(TextEditorEvent evt) {
    }

    public String toString() {
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.Subsystem) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Scope) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Comment) || this.blockType.equals((Object)CommonDefinitions.blockTypes.IN) || this.blockType.equals((Object)CommonDefinitions.blockTypes.OUT)) {
            return this.comment;
        }
        return ((Integer)this.addressList.get(0)).toString() + "-" + this.comment;
    }
}

