/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class IntegralNode
extends GenericNode {
    private String initialCondition = "0.0";
    private String timeStep = "1000";
    public static final String INTEGER_ID = "41";

    public IntegralNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.PID;
        this.subType = CommonDefinitions.subBlockTypes.Integral;
        this.addressSpace = 4;
        this.codici = new ArrayList();
        this.codici.add(0, "Integral");
        this.codici.add(1, "Integral_OUT");
        this.codici.add(2, "Integral_InitValue");
        this.codici.add(3, "Integral_Reset");
        this.setList(this.codici);
        this.numberOfInputs = 2;
        this.CreateWidget();
        this.CreatePropertiesDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Integral");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "RESET";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.getValue());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.initialCondition);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Initial Condition : ");
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Timestep (ms) :");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.timeStep);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setText("Reset");
    }

    public String getValue() {
        return this.initialCondition;
    }

    public void setValue(String value) {
        this.initialCondition = value;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.initialCondition);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.initialCondition = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            ((AFONodeWidget)this.widget).setSubType(this.initialCondition);
            this.timeStep = ((GenericBlockDialog)this.propertiesDialog).txtField2.getText();
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + this.initialCondition + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(3) + " " + this.timeStep + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "41 " + this.getCommonData() + this.initialCondition + " " + this.timeStep;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
            String newLabel = cmd.getValue("OUT");
            ((AFONodeWidget)this.widget).setSubType(newLabel);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            this.initialCondition = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.initialCondition);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
            this.timeStep = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.timeStep);
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "subType", this.subType.toString());
        SceneSerializer.setAttribute(document, nodeElement, "InitialCondition", this.initialCondition);
        SceneSerializer.setAttribute(document, nodeElement, "TimeStep", this.timeStep);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.initialCondition = SceneSerializer.getAttributeValue(node, "InitialCondition");
        if (this.initialCondition == null || this.initialCondition.length() == 0) {
            this.initialCondition = "0.0";
        }
        this.timeStep = SceneSerializer.getAttributeValue(node, "TimeStep");
        if (this.timeStep == null || this.timeStep.length() == 0) {
            this.timeStep = "1000.0";
        }
    }
}

