/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class LimitNode
extends GenericNode {
    private String upperLimit = "0.0";
    private String lowerLimit = "0.0";
    public static final int LIMIT_ID = 13;

    public LimitNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.addressSpace = 4;
        this.blockType = CommonDefinitions.blockTypes.Limit;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "Limit");
        this.codici.add(1, "OUT_Limit");
        this.codici.add(2, "MinLimit");
        this.codici.add(3, "MaxLimit");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Limit");
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("OUT1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Lw";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Up";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).setSubType(this.getLowerLimit() + "-" + this.getUpperLimit());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.getUpperLimit());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.getLowerLimit());
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.setUpperLimit(((GenericBlockDialog)this.propertiesDialog).txtField2.getText());
            this.setLowerLimit(((GenericBlockDialog)this.propertiesDialog).txtField1.getText());
            ((AFONodeWidget)this.widget).setSubType(this.getLowerLimit() + "-" + this.getUpperLimit());
            if (this.kernelConnected) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + ((GenericBlockDialog)this.propertiesDialog).txtField1.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(3) + " " + ((GenericBlockDialog)this.propertiesDialog).txtField2.getText() + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Lower:");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.getLowerLimit());
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Upper:");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.getUpperLimit());
    }

    public String getUpperLimit() {
        return this.upperLimit;
    }

    public String getLowerLimit() {
        return this.lowerLimit;
    }

    public void setUpperLimit(String upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(String lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float lower = Float.parseFloat("" + this.lowerLimit);
        float upper = Float.parseFloat("" + this.upperLimit);
        retVal = retVal + "13 " + this.getCommonData() + " ";
        retVal = retVal + lower + " " + upper;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
            String newLabel = "";
            newLabel = cmd.getValue("IN2") + "-" + cmd.getValue("IN3");
            ((AFONodeWidget)this.widget).setSubType(newLabel);
        } else {
            if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
                ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(cmd.getValue("TOKEN3"));
                this.lowerLimit = cmd.getValue("TOKEN3");
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
                ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(cmd.getValue("TOKEN3"));
                this.upperLimit = cmd.getValue("TOKEN3");
            }
            ((AFONodeWidget)this.widget).setSubType(this.getLowerLimit() + "-" + this.getUpperLimit());
            this.propertiesDialog.invalidate();
        }
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }
}

