/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.ModbusDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class ModbusNode
extends DeviceNode {
    private String typeName;
    public static final int MODBUS_IO_ID = 23;
    private static final String TRANSFORM_FLOAT = "0.0";
    private static final String TRANSFORM_USER = "1.0";
    private String transformType;
    private int interfaceID;
    private String decimalPlaces;
    private String slaveAddress;
    private String registerAddress;
    private String minRawVal;
    private String minScaledVal;
    private String maxRawVal;
    private String maxScaledVal;
    private String registerDefaultVal;
    public BoardsTypesAndDescription.BoardType boardtypeproj;
    private BoardsTypesAndDescription.BoardType boardType;
    private static AppOptions options = new AppOptions();

    public ModbusNode(String id, String label, AFOGraphPinScene scene, Project proj) {
        block10: {
            block11: {
                block9: {
                    block8: {
                        super(id, label, "--", scene);
                        this.transformType = TRANSFORM_FLOAT;
                        this.interfaceID = 2;
                        this.decimalPlaces = TRANSFORM_USER;
                        this.slaveAddress = "254";
                        this.registerAddress = "100";
                        this.minRawVal = "0";
                        this.minScaledVal = "0";
                        this.maxRawVal = "65535";
                        this.maxScaledVal = "65535.0";
                        this.registerDefaultVal = TRANSFORM_FLOAT;
                        this.typeName = label;
                        if (this.typeName.equals(CommonDefinitions.blockTypes.ModbusIN.toString())) {
                            this.blockType = CommonDefinitions.blockTypes.ModbusIN;
                            this.numberOfInputs = 2;
                        } else if (this.typeName.equals(CommonDefinitions.blockTypes.ModbusOUT.toString())) {
                            this.blockType = CommonDefinitions.blockTypes.ModbusOUT;
                            this.numberOfInputs = 3;
                        }
                        this.CreateWidget();
                        this.CreatePropertiesDialog();
                        this.setConnectionStatus(false);
                        this.addressSpace = 13;
                        this.boardtypeproj = proj.getBoardType();
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1CO)) break block8;
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1HC)) break block8;
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2T)) break block8;
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TH)) break block8;
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2THR)) break block8;
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TR)) break block8;
                        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) break block8;
                        if (!this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH)) break block9;
                    }
                    ((ModbusDialog)this.propertiesDialog).comboPort.removeItemAt(1);
                    ((ModbusDialog)this.propertiesDialog).comboPort.setSelectedIndex(0);
                    break block10;
                }
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP)) break block11;
                if (!this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID4ST)) break block10;
            }
            ((ModbusDialog)this.propertiesDialog).comboPort.addItem("RS3");
        }
        this.codici = new ArrayList();
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.ModbusIN)) {
            this.codici.add(0, "ModbusIN");
        } else {
            this.codici.add(0, "ModbusOUT");
        }
        this.codici.add(1, "OUT");
        this.codici.add(2, "ModbusPort");
        this.codici.add(3, "Type");
        this.codici.add(4, "SlaveAddress");
        this.codici.add(5, "SlaveRegister");
        this.codici.add(6, "ScalingType");
        this.codici.add(7, "DecimalNumber");
        this.codici.add(8, "MinRawValue");
        this.codici.add(9, "MinScaleValue");
        this.codici.add(10, "MaxRawValue");
        this.codici.add(11, "MaxScaleValue");
        this.codici.add(12, "StartRegisterValue");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((ModbusDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new ModbusDialog(null, true, this);
        options.LoadOptions();
        this.currentLocale = new Locale(ModbusNode.options.language, ModbusNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((ModbusDialog)this.propertiesDialog).setTitle(this.message.getString("modprop"));
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        if (this.typeName.equals(CommonDefinitions.blockTypes.ModbusOUT.toString())) {
            String pinLabel = "OUT1";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
            pinLabel = "ID";
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN2");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
            pinLabel = "Address";
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN3");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else if (this.typeName.equals(CommonDefinitions.blockTypes.ModbusIN.toString())) {
            String pinLabel = "IN1";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
            pinLabel = "ID";
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
            pinLabel = "Address";
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN2");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void setDialogFields() {
        ModbusDialog dlg = (ModbusDialog)this.propertiesDialog;
        ((ModbusDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        dlg.comboPort.setSelectedIndex(this.interfaceID - 1);
        dlg.spnrSlaveAddr.setValue((int)Float.parseFloat(this.slaveAddress));
        dlg.txtRegAddress.setText(this.registerAddress);
        dlg.txtMinRaw.setText(this.minRawVal);
        dlg.txtMinScaled.setText(this.minScaledVal);
        dlg.txtMaxRaw.setText(this.maxRawVal);
        dlg.txtMaxScaled.setText(this.maxScaledVal);
        dlg.comboScalingType.setSelectedIndex((int)Float.parseFloat(this.transformType));
        dlg.spnrDecimalPlaces.setValue((int)Float.parseFloat(this.decimalPlaces));
        dlg.spnrRegDefaultVal.setValue((int)Float.parseFloat(this.registerDefaultVal));
    }

    private void getDialogFields() {
        ModbusDialog dlg = (ModbusDialog)this.propertiesDialog;
        this.interfaceID = dlg.comboPort.getSelectedIndex() + 1;
        this.slaveAddress = "" + dlg.spnrSlaveAddr.getValue();
        this.registerAddress = "" + dlg.txtRegAddress.getText();
        this.minRawVal = "" + dlg.txtMinRaw.getText();
        this.minScaledVal = "" + dlg.txtMinScaled.getText();
        this.maxRawVal = "" + dlg.txtMaxRaw.getText();
        this.maxScaledVal = "" + dlg.txtMaxScaled.getText();
        this.transformType = "" + (float)dlg.comboScalingType.getSelectedIndex();
        this.decimalPlaces = "" + (float)Integer.parseInt(dlg.spnrDecimalPlaces.getValue().toString());
        this.registerDefaultVal = "" + (float)Integer.parseInt(dlg.spnrRegDefaultVal.getValue().toString());
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        block7: {
            block6: {
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1CO)) break block6;
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1HC)) break block6;
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2T)) break block6;
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TH)) break block6;
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2THR)) break block6;
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TR)) break block6;
                if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) break block6;
                if (!this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH)) break block7;
            }
            int count = ((ModbusDialog)this.propertiesDialog).comboPort.getItemCount();
            this.interfaceID = 1;
        }
        this.requestData();
        this.setDialogFields();
        ((ModbusDialog)this.propertiesDialog).enableFields(!this.kernelConnected);
        ((ModbusDialog)this.propertiesDialog).fieldChanged = false;
        ((ModbusDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((ModbusDialog)this.propertiesDialog).getExitStatus() == 1) {
            if (!((ModbusDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.getDialogFields();
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        ModbusDialog dlg = (ModbusDialog)this.propertiesDialog;
        dlg.txtMaxRaw.setEnabled(!isConnected);
        dlg.txtMaxScaled.setEnabled(!isConnected);
        dlg.txtMinRaw.setEnabled(!isConnected);
        dlg.txtMinScaled.setEnabled(!isConnected);
        dlg.txtRegAddress.setEnabled(!isConnected);
        dlg.spnrDecimalPlaces.setEnabled(!isConnected);
        dlg.spnrRegDefaultVal.setEnabled(!isConnected);
        dlg.spnrSlaveAddr.setEnabled(!isConnected);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        this.interfaceID = Integer.parseInt(SceneSerializer.getAttributeValue(node, "InterfaceID"));
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1CO)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1HC)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2T)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TH)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2THR)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TR)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) ** GOTO lbl-1000
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH)) lbl-1000:
        // 8 sources

        {
            this.interfaceID = 1;
        } else if (!this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP)) {
            if (!this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID4ST) && this.interfaceID > 2) {
                this.interfaceID = 2;
            }
        }
        this.slaveAddress = SceneSerializer.getAttributeValue(node, "SlaveAddr");
        this.registerAddress = SceneSerializer.getAttributeValue(node, "RegisterAddr");
        this.transformType = SceneSerializer.getAttributeValue(node, "ScalingType");
        this.decimalPlaces = SceneSerializer.getAttributeValue(node, "NofDecimals");
        this.minRawVal = SceneSerializer.getAttributeValue(node, "MinRaw");
        this.minScaledVal = SceneSerializer.getAttributeValue(node, "MinScaled");
        this.maxRawVal = SceneSerializer.getAttributeValue(node, "MaxRaw");
        this.maxScaledVal = SceneSerializer.getAttributeValue(node, "MaxScaled");
        this.registerDefaultVal = SceneSerializer.getAttributeValue(node, "DefaultValue");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "InterfaceID", "" + this.interfaceID);
        SceneSerializer.setAttribute(document, nodeElement, "SlaveAddr", this.slaveAddress);
        SceneSerializer.setAttribute(document, nodeElement, "RegisterAddr", this.registerAddress);
        SceneSerializer.setAttribute(document, nodeElement, "ScalingType", this.transformType);
        SceneSerializer.setAttribute(document, nodeElement, "NofDecimals", this.decimalPlaces);
        SceneSerializer.setAttribute(document, nodeElement, "MinRaw", this.minRawVal);
        SceneSerializer.setAttribute(document, nodeElement, "MinScaled", this.minScaledVal);
        SceneSerializer.setAttribute(document, nodeElement, "MaxRaw", this.maxRawVal);
        SceneSerializer.setAttribute(document, nodeElement, "MaxScaled", this.maxScaledVal);
        SceneSerializer.setAttribute(document, nodeElement, "DefaultValue", this.registerDefaultVal);
        return nodeElement;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "23 " + this.getCommonData();
        retVal = retVal + this.interfaceID + " ";
        retVal = this.blockType.equals((Object)CommonDefinitions.blockTypes.ModbusIN) ? retVal + "1.0 " : retVal + "0.0 ";
        retVal = retVal + this.slaveAddress + " " + this.registerAddress + " " + this.transformType;
        retVal = retVal + " " + this.decimalPlaces + " " + this.minRawVal + " " + this.minScaledVal + " " + this.maxRawVal;
        retVal = retVal + " " + this.maxScaledVal + " " + this.registerDefaultVal;
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }
}

