/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.MonitorDialog;
import nodes.gui.MyComboBoxEditor;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MonitorNode
extends DeviceNode
implements ActionListener {
    private DefaultTableModel tableModel;
    private final String type;
    private String displayAddress = "1";
    private String displayPort = "2";
    public BoardsTypesAndDescription.BoardType boardtypeproj;
    private BoardsTypesAndDescription.BoardType boardType;
    public static final int Monitor_ID = 32;

    public MonitorNode(String id, String label, String UID, AFOGraphPinScene scene, Project proj) {
        super(id, label, "Monitor", scene);
        this.type = label;
        this.blockType = CommonDefinitions.blockTypes.Monitor;
        this.numberOfInputs = 0;
        this.tableModel = new DefaultTableModel((Object[][])new Object[0][][][][][], new String[]{"Stringa", "Indirizzo", "Edit", "Max", "Min", "Step"});
        this.createWidget();
        this.createPropertiesDialog();
        this.boardtypeproj = proj.getBoardType();
        this.addressSpace = 5;
        this.codici = new ArrayList();
        this.codici.add("Monitor");
        this.codici.add("ON_Monitor");
        this.codici.add("Summer_Monitor");
        this.codici.add("AUTOMATICO_Monitor");
        this.codici.add("Setpoint_Monitor");
        this.setList(this.codici);
        this.clearTableModel();
    }

    public String getAddress() {
        String newAddress = ((MonitorDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void setAddressSpace(int i) {
        this.addressSpace = i;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).setSubType(this.displayAddress);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.createPins();
        this.scene.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void createPropertiesDialog() {
        this.propertiesDialog = new MonitorDialog(null, true, this.type, this);
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5)});
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        MonitorDialog dlg = (MonitorDialog)this.propertiesDialog;
        dlg.btnGiu.setEnabled(!isConnected);
        dlg.btnSu.setEnabled(!isConnected);
        dlg.btnInsert.setEnabled(!isConnected);
        dlg.table.setEnabled(!isConnected);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        int i;
        ((MonitorDialog)this.propertiesDialog).disableListeners();
        ((MonitorDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((MonitorDialog)this.propertiesDialog).comboPort.setSelectedIndex(Integer.parseInt(this.displayPort) - 1);
        if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1CO) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID1HC) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2T) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TH) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2THR) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID2TR)) {
            ((MonitorDialog)this.propertiesDialog).comboPort.removeItemAt(1);
            ((MonitorDialog)this.propertiesDialog).comboPort.setSelectedIndex(0);
            this.displayPort = "1";
        } else {
            ((MonitorDialog)this.propertiesDialog).comboPort.setSelectedIndex(Integer.parseInt(this.displayPort) - 1);
        }
        ((MonitorDialog)this.propertiesDialog).txtDisplayAddress.setText(this.displayAddress);
        ((MonitorDialog)this.propertiesDialog).indexLabel.setVisible(false);
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new String[]{"Name", "Scale Factor", "Address", "MIN", "MAX", "STEP"});
        MonitorNode.tableCopy(dialogTable, this.tableModel);
        ((MonitorDialog)this.propertiesDialog).table.setModel(dialogTable);
        for (i = 0; i < ((MonitorDialog)this.propertiesDialog).table.getRowCount(); ++i) {
            String[] values = new String[]{"1", "10", "100"};
            int vColIndex = 1;
            TableColumn col = ((MonitorDialog)this.propertiesDialog).table.getColumnModel().getColumn(vColIndex);
            MyComboBoxEditor combo = new MyComboBoxEditor(values);
            col.setCellEditor(combo);
        }
        ((MonitorDialog)this.propertiesDialog).comboPort.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).txtDisplayAddress.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).table.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnDeleteRow.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnInsert.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnSu.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnGiu.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).showDialog();
        if (((MonitorDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((MonitorDialog)this.propertiesDialog).getDataChanged()) {
                return;
            }
            this.scene.sceneChanged();
            this.addressList.clear();
            for (i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.displayAddress = ((MonitorDialog)this.propertiesDialog).txtDisplayAddress.getText();
            ((AFONodeWidget)this.widget).setSubType(this.displayAddress);
            this.displayPort = "" + (((MonitorDialog)this.propertiesDialog).comboPort.getSelectedIndex() + 1);
            dialogTable = (DefaultTableModel)((MonitorDialog)this.propertiesDialog).table.getModel();
            boolean deleteEdges = true;
            if (this.tableModel.getRowCount() == dialogTable.getRowCount()) {
                deleteEdges = false;
                for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
                    if ((Integer.parseInt(this.tableModel.getValueAt(i2, 5).toString()) != 0 || Integer.parseInt(dialogTable.getValueAt(i2, 5).toString()) == 0) && (Integer.parseInt(this.tableModel.getValueAt(i2, 5).toString()) == 0 || Integer.parseInt(dialogTable.getValueAt(i2, 5).toString()) != 0)) continue;
                    deleteEdges = true;
                    break;
                }
            }
            MonitorNode.tableCopy(this.tableModel, dialogTable);
            if (deleteEdges) {
                this.createPins();
            } else {
                this.updatePins();
            }
        }
    }

    private void createPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        this.pinList.clear();
        this.addStandardPins();
        int nOfOut = 4;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 5) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 5).toString()) == 0.0) {
                ++this.numberOfInputs;
                this.addIOPin(true, this.tableModel.getValueAt(i, 0).toString(), this.numberOfInputs);
                continue;
            }
            this.addIOPin(false, this.tableModel.getValueAt(i, 0).toString(), ++nOfOut);
        }
        this.codici = new ArrayList();
        this.codici.add("Monitor");
        this.codici.add("ON_Monitor");
        this.codici.add("Summer_Monitor");
        this.codici.add("AUTOMATICO_Monitor");
        this.codici.add("Setpoint_Monitor");
        int numin = 0;
        int numout = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 5) == null || this.tableModel.getValueAt(i, 5).toString().equals("0")) {
                ++numin;
                continue;
            }
            ++numout;
            this.codici.add((String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.scene.revalidate();
    }

    private void clearTableModel() {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        DefaultTableModel model = (DefaultTableModel)((MonitorDialog)this.propertiesDialog).table.getModel();
        retVal = retVal + "32 " + this.getCommonData();
        retVal = retVal + ((AFONodeWidget)this.widget).getModuleOUTPinNames().getChildren().size();
        retVal = retVal + " " + this.displayAddress + " " + this.displayPort;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "MonitorID", this.displayAddress);
        SceneSerializer.setAttribute(document, nodeElement, "MonitorPort", this.displayPort);
        SceneSerializer.setAttribute(document, nodeElement, "NofRows", "" + this.tableModel.getRowCount());
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Element climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "Stringa", this.tableModel.getValueAt(i, 0).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Scala", this.tableModel.getValueAt(i, 1).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Indirizzo", this.tableModel.getValueAt(i, 2).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Min", this.tableModel.getValueAt(i, 3).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Max", this.tableModel.getValueAt(i, 4).toString());
            if (this.tableModel.getValueAt(i, 5) != null) {
                SceneSerializer.setAttribute(document, climaticElement, "Step", this.tableModel.getValueAt(i, 5).toString());
            } else {
                SceneSerializer.setAttribute(document, climaticElement, "Step", "0");
            }
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        int row = 0;
        this.clearTableModel();
        this.displayAddress = SceneSerializer.getAttributeValue(node, "MonitorID");
        this.displayPort = SceneSerializer.getAttributeValue(node, "MonitorPort");
        if (this.displayPort == null) {
            this.displayPort = "2";
        }
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("TableRow")) continue;
            String stringa = SceneSerializer.getAttributeValue(element, "Stringa");
            String scale = SceneSerializer.getAttributeValue(element, "Scala");
            String indirizzo = SceneSerializer.getAttributeValue(element, "Indirizzo");
            String min = SceneSerializer.getAttributeValue(element, "Min");
            String max = SceneSerializer.getAttributeValue(element, "Max");
            String step = SceneSerializer.getAttributeValue(element, "Step");
            this.tableModel.addRow((Object[])new Object[0][]);
            this.tableModel.setValueAt(stringa, row, 0);
            this.tableModel.setValueAt(scale, row, 1);
            this.tableModel.setValueAt(indirizzo, row, 2);
            this.tableModel.setValueAt(min, row, 3);
            this.tableModel.setValueAt(max, row, 4);
            this.tableModel.setValueAt(step, row, 5);
            ++row;
        }
        this.propertiesDialog.validate();
        this.createPins();
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    private void addStandardPins() {
        int pinCount = 1;
        String pinLabel = "On";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Auto";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.numberOfInputs = 0;
    }

    private AFOPin addIOPin(boolean isInput, String label, int number) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        return newPin;
    }

    public String getVarConfiguration() {
        String retVal = "";
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            retVal = retVal + "<BL mobDSP ";
            retVal = retVal + (Integer)this.addressList.get(0);
            retVal = retVal + " set " + (i + 1) + " ";
            String val = this.tableModel.getValueAt(i, 0).toString();
            val = val.replace(' ', '_');
            retVal = retVal + val + " ";
            int scale = Integer.parseInt(this.tableModel.getValueAt(i, 1).toString());
            double valFloat = 0.0;
            int valInt = 0;
            val = this.tableModel.getValueAt(i, 1).toString();
            retVal = retVal + val + " ";
            val = this.tableModel.getValueAt(i, 2).toString();
            retVal = retVal + val + " ";
            valInt = Integer.parseInt(this.tableModel.getValueAt(i, 3).toString());
            retVal = retVal + (valInt *= scale);
            retVal = retVal + " ";
            valInt = Integer.parseInt(this.tableModel.getValueAt(i, 4).toString());
            retVal = retVal + (valInt *= scale);
            retVal = retVal + " ";
            val = this.tableModel.getValueAt(i, 5).toString();
            retVal = retVal + val + " ";
            retVal = retVal + ">\r\n";
        }
        return retVal;
    }

    private void updatePins() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            AFOPin pin = this.getPinAt(i + 4);
            LabelWidget lblWdg = pin.getPinNameWidget();
            lblWdg.setLabel(this.tableModel.getValueAt(i, 0).toString());
        }
        this.scene.revalidate();
        int nOfOut = 0;
        this.codici = new ArrayList();
        this.codici.add(0, "Monitor");
        this.codici.add(1, "Monitor_1");
        this.codici.add(2, "ON_Monitor");
        this.codici.add(3, "Summer_Monitor");
        this.codici.add(4, "AUTOMATICO_Monitor");
        this.codici.add(5, "Setpoint_Monitor");
        int numin = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 3) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 3).toString()) == 0.0) {
                ++numin;
                continue;
            }
            ++nOfOut;
            this.codici.add(2 + i, (String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
    }
}

