/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.MonitorDialog_2;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MonitorNode_2
extends DeviceNode
implements ActionListener {
    private DefaultTableModel tableModel;
    private final String type;
    private Boolean manageStates = true;
    private Boolean usePassword = true;
    Integer password = 0;
    int nOfOut = 4;
    public static final int MAX_NUM_VAR = 48;
    public static final int Monitor_2_ID = 36;

    public MonitorNode_2(String id, String label, String UID, AFOGraphPinScene scene) {
        super(id, label, "Monitor_2", scene);
        this.type = label;
        this.blockType = CommonDefinitions.blockTypes.Monitor_2;
        this.numberOfInputs = 3;
        this.tableModel = new DefaultTableModel(new Object[]{"Nome", "Min", "Max", "Step", "Default", "Tipo"}, 0);
        this.createWidget();
        this.createPropertiesDialog();
        this.addressSpace = 50;
        this.codici = new ArrayList();
        this.codici.add(0, "Display");
        this.codici.add(1, "Display");
        this.codici.add(2, "ON_Display");
        this.codici.add(3, "Summer_Display");
        this.codici.add(4, "AUTOMATICO_Display");
        this.codici.add(5, "Setpoint_Display");
        this.setList(this.codici);
        System.out.print("nOfOut: " + this.nOfOut + "as " + this.addressSpace + " ");
        this.clearTableModel();
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), true).booleanValue()) {
            ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    public String getAddress() {
        String newAddress = ((MonitorDialog_2)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void addStandardPins() {
        int pinCount = 1;
        String pinLabel = "On";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Auto";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ch SP";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ch SP 2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ch SP 3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ch SP 4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinCount = 1;
        pinLabel = "L1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "On";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Auto";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Warning";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.numberOfInputs = pinCount - 1;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Display");
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.createPins();
        this.getScene().revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((MonitorDialog_2)this.propertiesDialog).btnOk)) {
            if (((MonitorDialog_2)this.propertiesDialog).indexLabel.isVisible()) {
                JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((MonitorDialog_2)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        }
    }

    private void createPropertiesDialog() {
        this.propertiesDialog = new MonitorDialog_2(null, true, this.type, this);
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode_2.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5)});
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        MonitorDialog_2 dlg = (MonitorDialog_2)this.propertiesDialog;
        dlg.btnGiu.setEnabled(!isConnected);
        dlg.btnSu.setEnabled(!isConnected);
        dlg.btnInsert.setEnabled(!isConnected);
        dlg.table.setEnabled(!isConnected);
    }

    void getNewPasswordFromDialog() {
        this.usePassword = ((MonitorDialog_2)this.propertiesDialog).chkUsePassword.isSelected();
        if (this.usePassword.booleanValue()) {
            Integer pass1 = 0;
            Integer pass2 = 0;
            Integer pass3 = 0;
            Integer pass4 = 0;
            Integer pass5 = 0;
            Integer pass6 = 0;
            pass1 = ((MonitorDialog_2)this.propertiesDialog).comboPwd1.getSelectedIndex();
            pass2 = ((MonitorDialog_2)this.propertiesDialog).comboPwd2.getSelectedIndex();
            pass3 = ((MonitorDialog_2)this.propertiesDialog).comboPwd3.getSelectedIndex();
            pass4 = ((MonitorDialog_2)this.propertiesDialog).comboPwd4.getSelectedIndex();
            pass5 = ((MonitorDialog_2)this.propertiesDialog).comboPwd5.getSelectedIndex();
            pass6 = ((MonitorDialog_2)this.propertiesDialog).comboPwd6.getSelectedIndex();
            this.password = 0;
            this.password = pass1 | pass2 << 2 | pass3 << 4 | pass4 << 6 | pass5 << 8 | pass6 << 10;
        }
    }

    void setComboPassword() {
        ((MonitorDialog_2)this.propertiesDialog).chkUsePassword.setSelected(this.usePassword);
        Integer pass1 = 0;
        Integer pass2 = 0;
        Integer pass3 = 0;
        Integer pass4 = 0;
        Integer pass5 = 0;
        Integer pass6 = 0;
        pass1 = (this.password & 3) >> 0;
        pass2 = (this.password & 0xC) >> 2;
        pass3 = (this.password & 0x30) >> 4;
        pass4 = (this.password & 0xC0) >> 6;
        pass5 = (this.password & 0x300) >> 8;
        pass6 = (this.password & 0xC00) >> 10;
        ((MonitorDialog_2)this.propertiesDialog).comboPwd1.setSelectedIndex(pass1);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd2.setSelectedIndex(pass2);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd3.setSelectedIndex(pass3);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd4.setSelectedIndex(pass4);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd5.setSelectedIndex(pass5);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd6.setSelectedIndex(pass6);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((MonitorDialog_2)this.propertiesDialog).disableListeners();
        ((MonitorDialog_2)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Nome", "Min", "Max", "Step", "Default", "Tipo"});
        MonitorNode_2.tableCopy(dialogTable, this.tableModel);
        ((MonitorDialog_2)this.propertiesDialog).table.setModel(dialogTable);
        for (int i = 0; i < ((MonitorDialog_2)this.propertiesDialog).table.getRowCount(); ++i) {
            JComboBox<String> typeCombo = new JComboBox<String>();
            typeCombo.addItem("Normal");
            typeCombo.addItem("Config");
            typeCombo.addItem("Reserved");
            TableColumn col = ((MonitorDialog_2)this.propertiesDialog).table.getColumnModel().getColumn(5);
            col.setCellEditor(new DefaultCellEditor(typeCombo));
        }
        ((MonitorDialog_2)this.propertiesDialog).chkUseStates.setEnabled(!this.kernelConnected);
        ((MonitorDialog_2)this.propertiesDialog).chkUseStates.setSelected(this.manageStates);
        ((MonitorDialog_2)this.propertiesDialog).chkUsePassword.setSelected(this.usePassword);
        this.setComboPassword();
        ((MonitorDialog_2)this.propertiesDialog).table.setEnabled(!this.kernelConnected);
        ((MonitorDialog_2)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(false);
        ((MonitorDialog_2)this.propertiesDialog).showDialog();
        if (((MonitorDialog_2)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((MonitorDialog_2)this.propertiesDialog).getDataChanged()) {
                return;
            }
            this.scene.sceneChanged();
            this.manageStates = ((MonitorDialog_2)this.propertiesDialog).chkUseStates.isSelected();
            this.getNewPasswordFromDialog();
            dialogTable = (DefaultTableModel)((MonitorDialog_2)this.propertiesDialog).table.getModel();
            boolean deleteEdges = false;
            boolean sortTable = false;
            if (this.tableModel.getRowCount() == dialogTable.getRowCount()) {
                deleteEdges = false;
                for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                    if (Double.parseDouble(this.tableModel.getValueAt(i, 3).toString()) == 0.0 && Double.parseDouble(dialogTable.getValueAt(i, 3).toString()) != 0.0 || Double.parseDouble(this.tableModel.getValueAt(i, 3).toString()) != 0.0 && Double.parseDouble(dialogTable.getValueAt(i, 3).toString()) == 0.0) {
                        sortTable = true;
                        deleteEdges = true;
                    } else {
                        if (this.tableModel.getValueAt(i, 5).toString().equals(dialogTable.getValueAt(i, 5).toString())) continue;
                        sortTable = true;
                    }
                    break;
                }
            } else {
                sortTable = true;
                deleteEdges = true;
            }
            MonitorNode_2.tableCopy(this.tableModel, dialogTable);
            if (sortTable) {
                this.sort();
                deleteEdges = true;
            }
            if (deleteEdges) {
                this.createPins();
            } else {
                this.updatePins();
            }
        }
    }

    private void createPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        this.pinList.clear();
        this.addStandardPins();
        this.nOfOut = ((AFONodeWidget)this.widget).getOutputs().getChildren().size();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 3) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 3).toString()) == 0.0) {
                ++this.numberOfInputs;
                this.addIOPin(true, this.tableModel.getValueAt(i, 0).toString(), this.numberOfInputs);
                continue;
            }
            ++this.nOfOut;
            this.addIOPin(false, this.tableModel.getValueAt(i, 0).toString(), this.nOfOut);
        }
        this.codici = new ArrayList();
        this.codici.add("Monitor");
        this.codici.add("Monitor_1");
        this.codici.add("ON_Monitor");
        this.codici.add("Summer_Monitor");
        this.codici.add("AUTOMATICO_Monitor");
        this.codici.add("Setpoint_Monitor");
        int numin = 0;
        int numout = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 3) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 3).toString()) == 0.0) {
                ++numin;
                continue;
            }
            ++numout;
            this.codici.add((String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.scene.revalidate();
    }

    private void updatePins() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            AFOPin pin = this.getPinAt(i + 14);
            LabelWidget lblWdg = pin.getPinNameWidget();
            lblWdg.setLabel(this.tableModel.getValueAt(i, 0).toString());
        }
        this.scene.revalidate();
        this.nOfOut = 0;
        this.codici = new ArrayList();
        this.codici.add(0, "Monitor");
        this.codici.add(1, "Monitor_1");
        this.codici.add(2, "ON_Monitor");
        this.codici.add(3, "Summer_Monitor");
        this.codici.add(4, "AUTOMATICO_Monitor");
        this.codici.add(5, "Setpoint_Monitor");
        int numin = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 3) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 3).toString()) == 0.0) {
                ++numin;
                continue;
            }
            ++this.nOfOut;
            this.codici.add((String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
    }

    private void setAddressSpace(int i) {
        this.addressSpace = i;
    }

    private void clearTableModel() {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        DefaultTableModel model = (DefaultTableModel)((MonitorDialog_2)this.propertiesDialog).table.getModel();
        retVal = retVal + "36 " + this.getCommonData();
        retVal = retVal + ((AFONodeWidget)this.widget).getModuleOUTPinNames().getChildren().size();
        retVal = this.manageStates != false ? retVal + " 1.0" : retVal + " 0.0";
        retVal = this.usePassword != false ? retVal + " 1.0" : retVal + " 0.0";
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "States", this.manageStates.toString());
        SceneSerializer.setAttribute(document, nodeElement, "UsePassword", this.usePassword.toString());
        SceneSerializer.setAttribute(document, nodeElement, "Password", this.password.toString());
        SceneSerializer.setAttribute(document, nodeElement, "NofRows", "" + this.tableModel.getRowCount());
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Element climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "Nome", this.tableModel.getValueAt(i, 0).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Min", this.tableModel.getValueAt(i, 1).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Max", this.tableModel.getValueAt(i, 2).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Default", this.tableModel.getValueAt(i, 4).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Type", this.tableModel.getValueAt(i, 5).toString());
            if (this.tableModel.getValueAt(i, 3) != null) {
                SceneSerializer.setAttribute(document, climaticElement, "Step", this.tableModel.getValueAt(i, 3).toString());
            } else {
                SceneSerializer.setAttribute(document, climaticElement, "Step", "0");
            }
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        int row = 0;
        this.clearTableModel();
        this.manageStates = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "States"));
        String passwordStr = SceneSerializer.getAttributeValue(node, "UsePassword");
        if (passwordStr != null) {
            this.usePassword = Boolean.parseBoolean(passwordStr);
        }
        if ((passwordStr = SceneSerializer.getAttributeValue(node, "Password")) != null) {
            try {
                this.password = Integer.parseInt(passwordStr);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        for (Node element : SceneSerializer.getChildNode(node)) {
            String varType;
            if (!element.getNodeName().equals("TableRow")) continue;
            String nome = SceneSerializer.getAttributeValue(element, "Nome");
            String min = SceneSerializer.getAttributeValue(element, "Min");
            String max = SceneSerializer.getAttributeValue(element, "Max");
            String step = SceneSerializer.getAttributeValue(element, "Step");
            String defVal = SceneSerializer.getAttributeValue(element, "Default");
            if (defVal == null) {
                defVal = min;
            }
            if ((varType = SceneSerializer.getAttributeValue(element, "Type")) == null) {
                varType = "Normal";
            }
            this.tableModel.addRow(new Object[]{nome, min, max, step, defVal, varType});
            ++row;
        }
        this.propertiesDialog.validate();
        this.createPins();
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    private AFOPin addIOPin(boolean isInput, String label, int pinIDNumber) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + pinIDNumber);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + pinIDNumber);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        return newPin;
    }

    protected void sort() {
        for (int i = 1; i < this.tableModel.getRowCount(); ++i) {
            for (int j = i; j > 0 && this.compare(j - 1, j) > 0; --j) {
                this.tableModel.moveRow(j, j, j - 1);
            }
        }
    }

    protected int compare(int i, int j) {
        String s1 = this.tableModel.getValueAt(i, 5).toString();
        if (s1.equals("Normal")) {
            s1 = "1";
        } else if (s1.equals("Config")) {
            s1 = "2";
        } else if (s1.equals("Reserved")) {
            s1 = "3";
        }
        String s2 = this.tableModel.getValueAt(j, 5).toString();
        if (s2.equals("Normal")) {
            s2 = "1";
        } else if (s2.equals("Config")) {
            s2 = "2";
        } else if (s2.equals("Reserved")) {
            s2 = "3";
        }
        return s1.compareTo(s2);
    }

    public String getVarConfiguration() {
        String retVal = "";
        Integer nOfinChannel = 7;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            retVal = retVal + "<BL set ";
            retVal = retVal + this.addressList.get(0) + " ";
            String val = this.tableModel.getValueAt(i, 0).toString();
            val = val.replace(' ', '_');
            retVal = retVal + val + " ";
            for (int j = 1; j < 5; ++j) {
                val = this.tableModel.getValueAt(i, j).toString();
                Integer num = (int)(Double.parseDouble(val) * 10.0);
                retVal = retVal + num.toString() + " ";
            }
            String varType = this.tableModel.getValueAt(i, 5).toString();
            if (varType.equals("Normal")) {
                retVal = retVal + "0 ";
            } else if (varType.equals("Config")) {
                retVal = retVal + "1 ";
            } else if (varType.equals("Reserved")) {
                retVal = retVal + "2 ";
            }
            if (Double.parseDouble(this.tableModel.getValueAt(i, 3).toString()) == 0.0) {
                Integer n = nOfinChannel;
                Integer n2 = nOfinChannel = Integer.valueOf(nOfinChannel + 1);
                retVal = retVal + nOfinChannel.toString() + " ";
            } else {
                retVal = retVal + "-1 ";
            }
            retVal = retVal + ">\r\n";
        }
        if (this.usePassword.booleanValue()) {
            retVal = retVal + "<BL set ";
            retVal = retVal + ((Integer)this.addressList.get(0) + 49) + " ";
            retVal = retVal + this.password;
            retVal = retVal + ">\r\n";
        }
        return retVal;
    }
}

