/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.NewMuxDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MuxNode
extends GenericNode {
    private DefaultTableModel tableModel;
    public boolean propertyChanged = false;
    private static AppOptions options = new AppOptions();
    public static final int MUX_ID = 17;

    public MuxNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.Mux;
        this.numberOfInputs = 3;
        this.addressSpace = 4;
        this.codici = new ArrayList();
        this.tableModel = new DefaultTableModel(new Object[][]{{"0", "0"}, {"0", "0"}}, new String[]{"IN", "Value"});
        options.LoadOptions();
        this.currentLocale = new Locale(MuxNode.options.language, MuxNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        this.codici.add("MuxNode");
        this.codici.add("IO_MuxNode");
        this.codici.add("NofPoints_MuxNode");
        this.codici.add("In1");
        this.codici.add("In2");
        this.setList(this.codici);
        this.CreateWidget();
        this.CreatePropertiesDialog();
        ((NewMuxDialog)this.propertiesDialog).clearTable();
        MuxNode.tableClear(this.tableModel);
        for (int i = 0; i < this.numberOfInputs - 1; ++i) {
            this.tableModel.addRow(new Object[]{i, 0});
        }
    }

    public String getAddress() {
        String newAddress = ((NewMuxDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Mux");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        this.createInputPins();
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void updateDialogTable() {
        DefaultTableModel dialogTable = (DefaultTableModel)((NewMuxDialog)this.propertiesDialog).table.getModel();
        MuxNode.tableCopy(dialogTable, this.tableModel);
        ((NewMuxDialog)this.propertiesDialog).table.setModel(dialogTable);
        ((NewMuxDialog)this.propertiesDialog).validate();
    }

    private void updateInternalTable() {
        DefaultTableModel dialogTable = (DefaultTableModel)((NewMuxDialog)this.propertiesDialog).table.getModel();
        MuxNode.tableCopy(this.tableModel, dialogTable);
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MuxNode.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1)});
        }
    }

    private void createInputPins() {
        int i;
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            ArrayList edgeList = (ArrayList)this.scene.findPinEdges(pin, false, true);
            for (AFOEdge edge : edgeList) {
                this.scene.removeEdge(edge);
            }
        }
        ((AFONodeWidget)this.widget).clearInputPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        for (i = 0; i < this.pinList.size(); ++i) {
            if (!((AFOPin)this.pinList.get(i)).getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            this.pinList.remove(i);
            --i;
        }
        this.numberOfInputs = this.tableModel.getRowCount() + 1;
        this.addressSpace = 2 + this.tableModel.getRowCount();
        if (this.addressList != null && !this.addressList.isEmpty()) {
            this.regenerateAddressList((Integer)this.addressList.get(0));
        }
        this.codici.clear();
        this.codici.add("MuxNode");
        this.codici.add("IO_MuxNode");
        this.codici.add("NofPoints_MuxNode");
        for (i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.codici.add("IN" + i);
        }
        String pinLabel = "Sel";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        for (int i2 = 1; i2 < this.numberOfInputs; ++i2) {
            pinLabel = "IN" + (i2 - 1);
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setPinIDString("IN" + (i2 + 1));
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.resetPinValues();
        this.scene.validate();
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        DefaultTableModel model = this.tableModel;
        retVal = retVal + "17 " + this.getCommonData() + (this.numberOfInputs - 1) + " ";
        for (int i = 0; i < model.getRowCount(); ++i) {
            retVal = retVal + Float.parseFloat("" + Float.parseFloat("" + model.getValueAt(i, 1))) + " ";
        }
        return retVal;
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new NewMuxDialog(null, true, this);
        ((NewMuxDialog)this.propertiesDialog).spnrNumIn.setVisible(true);
        for (int i = 0; i < 2; ++i) {
            this.tableModel.addRow(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)});
            this.tableModel.setValueAt(this.tableModel.getRowCount() - 1, i, i);
        }
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((NewMuxDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((NewMuxDialog)this.propertiesDialog).txtAddress.setEditable(!this.kernelConnected);
        ((NewMuxDialog)this.propertiesDialog).spnrNumIn.setValue(this.tableModel.getRowCount());
        ((NewMuxDialog)this.propertiesDialog).spnrNumIn.setEnabled(!this.kernelConnected);
        this.updateDialogTable();
        this.requestData();
        this.propertiesDialog.setModal(true);
        ((NewMuxDialog)this.propertiesDialog).fieldChanged = false;
        this.propertiesDialog.setVisible(true);
        if (((NewMuxDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((NewMuxDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.regenerateAddressList(Integer.parseInt(((NewMuxDialog)this.propertiesDialog).txtAddress.getText()));
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            if (((NewMuxDialog)this.propertiesDialog).table.getRowCount() != this.tableModel.getRowCount()) {
                this.updateInternalTable();
                this.createInputPins();
            } else {
                this.updateInternalTable();
            }
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 3;
                    for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                        String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.tableModel.getValueAt(i, 1) + " >";
                        this.commandQueue.add(msg);
                    }
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    private void clearTableModel() {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            int addr = msgAddress - (Integer)this.addressList.get(0) - 2;
            if (addr < 0) {
                return true;
            }
            switch (addr) {
                case 0: {
                    break;
                }
                default: {
                    int row = addr - 1;
                    if (row >= this.tableModel.getRowCount()) {
                        return true;
                    }
                    float fval = Float.parseFloat(value);
                    this.tableModel.setValueAt(Float.valueOf(fval), row, 1);
                }
            }
            this.updateDialogTable();
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "NOfInputs", "" + (this.tableModel.getRowCount() + 1));
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Element climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "In", this.tableModel.getValueAt(i, 0).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Val", this.tableModel.getValueAt(i, 1).toString());
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        String importedSubType;
        String nOfInputs = SceneSerializer.getAttributeValue(node, "NOfInputs");
        this.numberOfInputs = nOfInputs == null ? ((importedSubType = SceneSerializer.getAttributeValue(node, "subType")) == null || importedSubType.equals(CommonDefinitions.subBlockTypes.MUX_2.toString()) ? 3 : (importedSubType.equals(CommonDefinitions.subBlockTypes.MUX_4.toString()) ? 5 : (importedSubType.equals(CommonDefinitions.subBlockTypes.MUX_8.toString()) ? 9 : 3))) : Integer.parseInt(nOfInputs);
        try {
            boolean row = false;
            this.clearTableModel();
            for (int i = 1; i < this.numberOfInputs; ++i) {
                this.tableModel.addRow((Object[])new Object[0][]);
                this.tableModel.setValueAt(i - 1, i - 1, 0);
                this.tableModel.setValueAt(0, i - 1, 1);
            }
            for (Node element : SceneSerializer.getChildNode(node)) {
                if (!element.getNodeName().equals("TableRow")) continue;
                int in = Integer.parseInt(SceneSerializer.getAttributeValue(element, "In"));
                String value = SceneSerializer.getAttributeValue(element, "Val");
                this.tableModel.setValueAt(value, in, 1);
            }
        }
        catch (Exception ex) {
            this.clearTableModel();
            for (int i = 1; i < this.numberOfInputs; ++i) {
                this.tableModel.addRow((Object[])new Object[0][]);
                this.tableModel.setValueAt(i - 1, i - 1, 0);
                this.tableModel.setValueAt(0, i - 1, 1);
            }
        }
        this.createInputPins();
        this.propertiesDialog.validate();
    }
}

