/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class NTCNode
extends DeviceNode
implements ActionListener {
    private String type;
    public static final int NTC_ID = 29;

    public NTCNode(String id, String label, String analogID, AFOGraphPinScene scene) {
        super(id, label, analogID, scene);
        this.type = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        this.blockType = CommonDefinitions.blockTypes.NTC;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "NTC");
        this.codici.add(1, "NTC");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        String pinLabel = "T";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).btnOk.addActionListener(this);
        ((SimplePropertiesDlg)this.propertiesDialog).btnCancel.addActionListener(this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1) {
            this.propertiesDialog.setVisible(false);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "29 " + this.getCommonData();
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((SimplePropertiesDlg)this.propertiesDialog).btnOk)) {
            if (((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
            }
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((SimplePropertiesDlg)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
    }
}

