/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.XMLCommands.UtilXML;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class Pt100Node
extends DeviceNode {
    private String type;
    public static final int Pt100_ID = 25;
    private String compensation = "0.0";

    public Pt100Node(String id, String label, String deviceID, AFOGraphPinScene scene) {
        super(id, label, deviceID, scene);
        this.type = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(true);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(true);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setText("Compensation :");
        this.blockType = CommonDefinitions.blockTypes.Pt100;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 3;
        this.codici = new ArrayList();
        this.codici.add(0, "Pt100");
        this.codici.add(1, "Pt100");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        if (this.type.equals(CommonDefinitions.blockTypes.Pt100.toString())) {
            String pinLabel = "T";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        Double fw = 0.0;
        if (this.kernel != null && (fw = this.kernel.getFirmwareVersionDouble()) >= 24.0) {
            this.requestData();
        }
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setText(this.compensation);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1 && ((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.compensation = ((SimplePropertiesDlg)this.propertiesDialog).txtValue.getText();
            if (fw < 24.0) {
                return;
            }
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + 2) + " " + this.compensation + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        int num = Integer.parseInt(this.deviceID.substring(6)) - 1;
        retVal = retVal + "25 " + this.getCommonData() + num;
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        if (UtilXML.cmpCmdValue(com, "ADDRESS", (Integer)this.addressList.get(0))) {
            AFOPin pin = (AFOPin)this.pinList.get(0);
            if (this.blockType == CommonDefinitions.blockTypes.Pt100) {
                String tempVal = com.getValue("Pt100");
                pin.getPinNameWidget().setLabel("(" + tempVal + ")" + "IN Pt100");
            }
            this.getScene().validate();
            return true;
        }
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Compensation", this.compensation);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        this.compensation = SceneSerializer.getAttributeValue(node, "Compensation");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        if (this.compensation == null) {
            this.compensation = "0.0";
        }
    }
}

