/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class PumpCtrlNode
extends GenericNode
implements ItemListener {
    private String swapTime = "10.0";
    private Boolean timeIsIndays = true;
    boolean dialogChanged = false;
    public static final int PUMPCTRL_ID = 35;

    public PumpCtrlNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.PumpControl;
        this.addressSpace = 5;
        this.numberOfInputs = 6;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "Pump");
        this.codici.add(1, "CMD1_Pump");
        this.codici.add(2, "CMD2_Pump");
        this.codici.add(3, "SwapTime");
        this.codici.add(4, "FlagTime(Days)");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Pump Ctrl");
        this.getScene().addNode(this);
        String pinLabel = "CMD1";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "CMD2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "AL1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "ST1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN2");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "AL2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN3");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "ST2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setPinIDString("IN4");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Time";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setPinIDString("IN5");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "EN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setPinIDString("IN6");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        this.propertiesDialog.setResizable(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.removeAllItems();
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText(this.message.getString("swap"));
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText("10");
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setText(this.message.getString("tempogiorni"));
        ((GenericBlockDialog)this.propertiesDialog).chk1.addItemListener(this);
        ((GenericBlockDialog)this.propertiesDialog).validate();
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "35 " + this.getCommonData();
        retVal = retVal + this.swapTime + " ";
        retVal = this.timeIsIndays != false ? retVal + "1.0" : retVal + "0.0";
        return retVal;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.swapTime);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.timeIsIndays);
        this.dialogChanged = false;
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged && !this.dialogChanged) {
                return;
            }
            if (this.dialogChanged || ((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                this.scene.sceneChanged();
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.commandQueue.clear();
                this.swapTime = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
                this.timeIsIndays = ((GenericBlockDialog)this.propertiesDialog).chk1.isSelected();
                if (this.kernel != null && this.kernelConnected) {
                    String msg = "<BL set " + this.addressList.get(3) + " " + this.swapTime + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + this.addressList.get(4) + " ";
                    msg = this.timeIsIndays != false ? msg + "1.0 >" : msg + "0.0 >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "SwapTime", this.swapTime);
        SceneSerializer.setAttribute(document, nodeElement, "TimeInDays", this.timeIsIndays.toString());
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.swapTime = SceneSerializer.getAttributeValue(node, "SwapTime");
        this.timeIsIndays = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "TimeInDays"));
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 3) {
                case 0: {
                    ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(value);
                    this.swapTime = value;
                    break;
                }
                case 1: {
                    this.timeIsIndays = (double)Float.parseFloat(value) == 0.0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.timeIsIndays);
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.dialogChanged = !this.dialogChanged;
    }
}

