/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class RitNode
extends DeviceNode {
    private String typeName;
    public static final int Rit_ID = 30;
    private int interfaceID = 2;
    private String type;
    private String minValue = "0.0";
    private String maxValue = "10.0";

    public RitNode(String id, String label, String UID, AFOGraphPinScene scene) {
        super(id, label, UID, scene);
        this.typeName = label;
        this.blockType = CommonDefinitions.blockTypes.Rit;
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.addressSpace = 4;
        this.codici = new ArrayList();
        this.codici.add(0, "Rit");
        this.codici.add(1, "Val_Rit");
        this.codici.add(2, "Min_Rit");
        this.codici.add(3, "Max_Rit");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Lower:");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.minValue);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Upper:");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.maxValue);
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        String pinLabel = "Rit1";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.maxValue);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.minValue);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.scene.sceneChanged();
            this.maxValue = ((GenericBlockDialog)this.propertiesDialog).txtField2.getText();
            this.minValue = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            ((AFONodeWidget)this.widget).setSubType(this.minValue + "-" + this.maxValue);
            if (this.kernelConnected) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(3) + " " + ((GenericBlockDialog)this.propertiesDialog).txtField1.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(2) + " " + ((GenericBlockDialog)this.propertiesDialog).txtField2.getText() + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        this.minValue = SceneSerializer.getAttributeValue(node, "minValue");
        this.maxValue = SceneSerializer.getAttributeValue(node, "maxValue");
        if (this.minValue == null) {
            this.minValue = "0.0";
        }
        if (this.maxValue == null) {
            this.maxValue = "10.0";
        }
        ((AFONodeWidget)this.widget).setSubType(this.minValue + "-" + this.maxValue);
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        if (this.minValue == null) {
            this.minValue = "0.0";
        }
        if (this.maxValue == null) {
            this.maxValue = "10.0";
        }
        SceneSerializer.setAttribute(document, nodeElement, "minValue", this.minValue);
        SceneSerializer.setAttribute(document, nodeElement, "maxValue", this.maxValue);
        return nodeElement;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float lower = Float.parseFloat("" + this.minValue);
        float upper = Float.parseFloat("" + this.maxValue);
        retVal = retVal + "30 " + this.getCommonData() + " ";
        retVal = retVal + upper + " " + lower;
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 2) {
                case 1: {
                    this.minValue = value;
                    break;
                }
                case 0: {
                    this.maxValue = value;
                }
            }
            ((GenericBlockDialog)this.propertiesDialog).txtField2.setText(this.maxValue);
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.minValue);
        }
        return true;
    }
}

