/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.SerialKernel;
import connection.XMLCommands.UtilXML;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class TemperatureNode
extends DeviceNode {
    private String type;
    public static final int Temp_ID = 3;

    public TemperatureNode(String id, String label, String analogID, AFOGraphPinScene scene) {
        super(id, label, analogID, scene);
        this.type = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        this.blockType = CommonDefinitions.blockTypes.Temp;
        this.numberOfInputs = 1;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 1;
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        if (this.type.equals(CommonDefinitions.blockTypes.Temp.toString())) {
            String pinLabel = "Temp";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("Temp1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1) {
            if (((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.propertiesDialog.setVisible(false);
            }
            this.deviceID = (String)((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.getSelectedItem();
            ((AFONodeWidget)this.widget).setSubType(this.deviceID);
            this.addressList.set(0, Integer.parseInt(((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText()));
            if (this.kernel != null && this.kernel instanceof SerialKernel) {
                int num = Integer.parseInt(this.deviceID.substring(2));
                double valInt = 0.0;
                String msg = "<Temp " + num + " ";
                String val = ((SimplePropertiesDlg)this.propertiesDialog).txtValue.getText();
                valInt = Float.parseFloat(val);
                if (valInt < 0.0) {
                    valInt = 0.0;
                    msg = msg + valInt;
                } else if (valInt > 10.0) {
                    valInt = 10.0;
                    msg = msg + valInt;
                } else {
                    msg = msg + val;
                }
                msg = msg + " >";
                this.kernel.sendCommand(msg);
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        int num = Integer.parseInt(this.deviceID.substring(2)) - 1;
        retVal = retVal + "3 " + this.getCommonData() + " " + num;
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        if (UtilXML.cmpCmdValue(com, "ADDRESS", (Integer)this.addressList.get(0))) {
            AFOPin pin = (AFOPin)this.pinList.get(0);
            if (this.blockType == CommonDefinitions.blockTypes.Temp) {
                String tempVal = com.getValue("Temp");
                pin.getPinNameWidget().setLabel("(" + tempVal + ")" + "IN Temp");
            }
            this.getScene().validate();
            return true;
        }
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
    }
}

