/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class TriggerNode
extends GenericNode {
    public static final int TRIGGER_ID = 20;

    public TriggerNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.subType = CommonDefinitions.subBlockTypes.RISE;
        for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
            if (!mytype.toString().equals(label)) continue;
            this.subType = mytype;
            break;
        }
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Trigger;
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "Trigger");
        this.codici.add(1, "OUT_Trigger");
        this.setList(this.codici);
        this.numberOfInputs = 2;
        this.CreatePropertiesDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Trigger");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Reset";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        for (CommonDefinitions.triggerTypes myType : CommonDefinitions.triggerTypes.values()) {
            ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem(CommonDefinitions.triggerStrings[myType.ordinal()]);
        }
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(((AFONodeWidget)this.widget).getSubType());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(!this.kernelConnected);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.scene.sceneChanged();
            String newType = ((GenericBlockDialog)this.propertiesDialog).comboSubType.getSelectedItem().toString();
            for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
                if (!CommonDefinitions.subBlockStrings[mytype.ordinal()].equals(newType)) continue;
                this.subType = mytype;
                break;
            }
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.getSubType().ordinal()]);
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + ((double)(this.subType.ordinal() - CommonDefinitions.subBlockTypes.RISE.ordinal()) + 1.0));
        retVal = retVal + "20 " + this.getCommonData() + type;
        return retVal;
    }
}

