/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.UniversalInputDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class UniversalInputNode
extends DeviceNode {
    private Project prj;
    private String inputType = "Not Used";
    private String minVal = "0.0";
    private String maxVal = "10.0";
    private String txtbetavalue = "3900";
    private String compensation = "0.0";
    public static final String[] universalInputTypes = new String[]{"Not Used", "PT100", "NTC", "Digital", "Current 0-20 mA", "Current 4-20 mA", "Analog 0-10 V", "Analog 2-10 V", "PT1000", "KTY81", "Ritaratore"};
    public static final String UNIVERSAL_IN_ID = "5";

    public UniversalInputNode(String id, String label, String UID, AFOGraphPinScene scene) {
        super(id, label, UID, scene);
        this.blockType = CommonDefinitions.blockTypes.UniversalIN;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.createPropertiesDialog();
        this.addressSpace = 6;
        this.setType(this.inputType);
    }

    public String getAddress() {
        String newAddress = ((UniversalInputDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Universal IN");
        this.getScene().addNode(this);
        String pinLabel = "IN";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType("U" + this.deviceID.substring(2));
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void createPropertiesDialog() {
        this.propertiesDialog = new UniversalInputDialog(null, true, this);
        if (((UniversalInputDialog)this.propertiesDialog).comboInType.getSelectedIndex() > 3) {
            ((UniversalInputDialog)this.propertiesDialog).txtMaxOut.setEnabled(true);
            ((UniversalInputDialog)this.propertiesDialog).txtMinOut.setEnabled(true);
            ((UniversalInputDialog)this.propertiesDialog).txtbetavalue.setEnabled(true);
        } else {
            ((UniversalInputDialog)this.propertiesDialog).txtMaxOut.setEnabled(false);
            ((UniversalInputDialog)this.propertiesDialog).txtMinOut.setEnabled(false);
            ((UniversalInputDialog)this.propertiesDialog).txtbetavalue.setEnabled(false);
        }
        ((UniversalInputDialog)this.propertiesDialog).comboChannel.removeAllItems();
        ((UniversalInputDialog)this.propertiesDialog).comboChannel.addItem(this.deviceID);
        ((UniversalInputDialog)this.propertiesDialog).comboInType.removeAllItems();
        for (String st : universalInputTypes) {
            ((UniversalInputDialog)this.propertiesDialog).comboInType.addItem(st);
        }
    }

    private void enableDialogChange(boolean enable) {
        ((UniversalInputDialog)this.propertiesDialog).txtAddress.setEnabled(enable);
        ((UniversalInputDialog)this.propertiesDialog).comboInType.setEnabled(enable);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        Double version = 10.0;
        if (this.kernel != null && (version = this.kernel.getFirmwareVersionDouble()) >= 24.0) {
            this.requestData();
        }
        ((UniversalInputDialog)this.propertiesDialog).comboInType.setSelectedItem(this.inputType);
        ((UniversalInputDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((UniversalInputDialog)this.propertiesDialog).txtMinOut.setText(this.minVal);
        ((UniversalInputDialog)this.propertiesDialog).txtMaxOut.setText(this.maxVal);
        ((UniversalInputDialog)this.propertiesDialog).txtbetavalue.setText(this.txtbetavalue);
        ((UniversalInputDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((UniversalInputDialog)this.propertiesDialog).txtCompensation.setText(this.compensation);
        this.enableDialogChange(!this.kernelConnected);
        ((UniversalInputDialog)this.propertiesDialog).fieldChanged = false;
        this.propertiesDialog.setVisible(true);
        if (((UniversalInputDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((UniversalInputDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.scene.sceneChanged();
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.inputType = ((UniversalInputDialog)this.propertiesDialog).comboInType.getSelectedItem().toString();
            ((AFONodeWidget)this.widget).setSubType(this.deviceID + " - " + this.getType());
            this.minVal = ((UniversalInputDialog)this.propertiesDialog).txtMinOut.getText();
            this.maxVal = ((UniversalInputDialog)this.propertiesDialog).txtMaxOut.getText();
            this.txtbetavalue = ((UniversalInputDialog)this.propertiesDialog).txtbetavalue.getText();
            this.compensation = ((UniversalInputDialog)this.propertiesDialog).txtCompensation.getText();
            if (version >= 24.0 && this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.minVal + " >";
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.maxVal + " >";
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.txtbetavalue + " >";
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.compensation + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    public String getType() {
        return this.inputType;
    }

    public void setType(String type) {
        this.inputType = type;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "inputType", this.getType());
        SceneSerializer.setAttribute(document, nodeElement, "minVal", this.minVal);
        SceneSerializer.setAttribute(document, nodeElement, "maxVal", this.maxVal);
        SceneSerializer.setAttribute(document, nodeElement, "txtbetavalue", this.txtbetavalue);
        SceneSerializer.setAttribute(document, nodeElement, "compensation", this.compensation);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        this.inputType = SceneSerializer.getAttributeValue(node, "inputType");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID + " - " + this.getType());
        this.createPropertiesDialog();
        ((UniversalInputDialog)this.propertiesDialog).comboInType.setSelectedItem(this.inputType);
        this.minVal = SceneSerializer.getAttributeValue(node, "minVal");
        this.maxVal = SceneSerializer.getAttributeValue(node, "maxVal");
        this.txtbetavalue = SceneSerializer.getAttributeValue(node, "txtbetavalue");
        this.compensation = SceneSerializer.getAttributeValue(node, "compensation");
        if (this.compensation == null) {
            this.compensation = "0.0";
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float num = Float.parseFloat(this.deviceID.substring(2)) - 1.0f;
        float uiType = Float.parseFloat("" + ((UniversalInputDialog)this.propertiesDialog).comboInType.getSelectedIndex());
        retVal = retVal + "5 " + this.getCommonData() + num + " " + uiType + " " + this.minVal + " " + this.maxVal + " " + this.txtbetavalue + " " + this.compensation;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            String value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 1) {
                case 0: {
                    break;
                }
                case 1: {
                    ((UniversalInputDialog)this.propertiesDialog).txtMinOut.setText(value);
                    this.minVal = value;
                    break;
                }
                case 2: {
                    ((UniversalInputDialog)this.propertiesDialog).txtMaxOut.setText(value);
                    this.maxVal = value;
                    break;
                }
                case 3: {
                    ((UniversalInputDialog)this.propertiesDialog).txtbetavalue.setText(value);
                    this.txtbetavalue = value;
                    break;
                }
                case 4: {
                    ((UniversalInputDialog)this.propertiesDialog).txtCompensation.setText(value);
                    this.compensation = value;
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }
}

