/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import java.awt.BasicStroke;
import java.awt.EventQueue;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nodes.AfoDBDao;
import nodes.DeviceData;
import nodes.Project;
import nodes.ProjectTreeRenderer;
import nodes.SingleValDataEntry;
import nodes.devices.GenericNode;
import nodes.gui.ChartDBProgressFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RefineryUtilities;
import sceneManager.AFOPin;

public class ManageDBFrame
extends JFrame
implements ActionListener,
PropertyChangeListener {
    private AfoDBDao db;
    private boolean disconnectOnExit = false;
    private final float CHART_LINE_WIDTH = 2.0f;
    private ChartDBProgressFrame pf;
    private JFreeChart myChart;
    private int[] selectedRows;
    private ArrayList<DeviceData> selectedNodes;
    private Project prj;
    TreeChartTask tct;
    private JButton LoadDBBtn;
    private JButton btnErrors;
    private JButton chartBtn;
    private JButton closeBtn;
    private JComboBox cmbChartInterval;
    private JButton eraseDBBtn;
    private JButton exportBtn;
    private JLabel jLabel1;
    private JButton rgenerateDBBtn;
    private JScrollPane scrollPaneTree;
    private JTree treeProject;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("progress")) {
            this.pf.prgBarProgBar.setValue((Integer)evt.getNewValue());
            this.pf.validate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pf.btnCancel) {
            this.tct.cancel(true);
        }
    }

    private ArrayList<SingleValDataEntry> getDeviceDataFromDB(DeviceData dd) {
        int address = dd.getAddress();
        String ioID = dd.getPinID();
        int tableIndex = 0;
        tableIndex = ioID.contains("IN") ? 2 : 3;
        AfoDBDao.TimeDiscretization timeDiscretization = AfoDBDao.TimeDiscretization.SECOND;
        switch (this.cmbChartInterval.getSelectedIndex()) {
            case 0: {
                timeDiscretization = AfoDBDao.TimeDiscretization.SECOND;
                break;
            }
            case 1: {
                timeDiscretization = AfoDBDao.TimeDiscretization.MINUTE;
                break;
            }
            case 2: {
                timeDiscretization = AfoDBDao.TimeDiscretization.HOUR;
                break;
            }
            case 3: {
                timeDiscretization = AfoDBDao.TimeDiscretization.DAY;
            }
        }
        ArrayList list = (ArrayList)this.db.getTableDataByAddressLabelAndTime(address, ioID, tableIndex, timeDiscretization);
        this.pf.lblMessageLabel.setText("Valori trovati per dispositivo " + address + " : " + list.size());
        return list;
    }

    public ManageDBFrame(Project prj) {
        this.initComponents();
        this.db = prj.getProjectDB();
        this.pf = new ChartDBProgressFrame();
        this.pf.btnCancel.addActionListener(this);
        this.prj = prj;
        this.btnErrors.setVisible(false);
        this.setResizable(false);
        this.treeProject.setCellRenderer(new ProjectTreeRenderer());
    }

    private void initComponents() {
        this.closeBtn = new JButton();
        this.LoadDBBtn = new JButton();
        this.eraseDBBtn = new JButton();
        this.chartBtn = new JButton();
        this.exportBtn = new JButton();
        this.rgenerateDBBtn = new JButton();
        this.btnErrors = new JButton();
        this.cmbChartInterval = new JComboBox();
        this.jLabel1 = new JLabel();
        this.scrollPaneTree = new JScrollPane();
        this.treeProject = new JTree();
        this.setDefaultCloseOperation(2);
        this.setTitle("Manage Database");
        this.closeBtn.setIcon(new ImageIcon(this.getClass().getResource("/VisiProg/resources/icons_big/exit.png")));
        this.closeBtn.setText("Chiudi");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.closeBtnActionPerformed(evt);
            }
        });
        this.LoadDBBtn.setText("ReLoad DB");
        this.LoadDBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.LoadDBBtnActionPerformed(evt);
            }
        });
        this.eraseDBBtn.setText("Clean DB");
        this.eraseDBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.eraseDBBtnActionPerformed(evt);
            }
        });
        this.chartBtn.setText("Chart");
        this.chartBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.chartBtnActionPerformed(evt);
            }
        });
        this.exportBtn.setText("Export");
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.exportBtnActionPerformed(evt);
            }
        });
        this.rgenerateDBBtn.setText("Regen DB");
        this.rgenerateDBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.rgenerateDBBtnActionPerformed(evt);
            }
        });
        this.btnErrors.setText("Errors");
        this.btnErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageDBFrame.this.btnErrorsActionPerformed(evt);
            }
        });
        this.cmbChartInterval.setModel(new DefaultComboBoxModel<String>(new String[]{"Secondi", "Minuti", "Ore", "Giorni"}));
        this.cmbChartInterval.setSelectedIndex(1);
        this.jLabel1.setText("Intervallo Dati :");
        this.scrollPaneTree.setViewportView(this.treeProject);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaneTree, -2, 243, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeBtn, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.eraseDBBtn, GroupLayout.Alignment.TRAILING, -1, 87, Short.MAX_VALUE).addComponent(this.rgenerateDBBtn, GroupLayout.Alignment.TRAILING, -1, 87, Short.MAX_VALUE).addComponent(this.LoadDBBtn, GroupLayout.Alignment.TRAILING, -1, 87, Short.MAX_VALUE).addComponent(this.exportBtn, GroupLayout.Alignment.TRAILING, -1, 87, Short.MAX_VALUE).addComponent(this.btnErrors, GroupLayout.Alignment.TRAILING, -1, 87, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.chartBtn, GroupLayout.Alignment.TRAILING, -1, 87, Short.MAX_VALUE).addComponent(this.cmbChartInterval, GroupLayout.Alignment.TRAILING, 0, 87, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.LoadDBBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnErrors).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chartBtn).addGap(9, 9, 9).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbChartInterval, -2, -1, -2).addGap(113, 113, 113).addComponent(this.rgenerateDBBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eraseDBBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 52, Short.MAX_VALUE).addComponent(this.closeBtn)).addComponent(this.scrollPaneTree, -1, 427, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void closeBtnActionPerformed(ActionEvent evt) {
        if (this.disconnectOnExit && this.db.isConnected()) {
            this.db.disconnect();
        }
        this.setVisible(false);
    }

    public void loadDB() {
        try {
            if (!this.db.isConnected()) {
                this.db.connect();
                this.disconnectOnExit = true;
            }
            DefaultTreeModel model = (DefaultTreeModel)this.treeProject.getModel();
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)model.getRoot();
            top.setUserObject(this.prj.getProjectName().substring(0, this.prj.getProjectName().indexOf(46)));
            top.removeAllChildren();
            model.reload();
            this.prj.getProjectTree(top, this.prj.getMainSystem());
            model.reload();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Errore in accesso al DB:\n" + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    private void getSelectedNodes() {
        TreePath[] paths = this.treeProject.getSelectionPaths();
        this.selectedNodes = new ArrayList(paths.length);
        if (paths.length == 0) {
            JOptionPane.showMessageDialog(this, "Nessun dispositivo selezionato!!");
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            TreePath temp = paths[i];
            Object tempObj = temp.getLastPathComponent();
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)tempObj;
            if (!treeNode.isLeaf()) continue;
            AFOPin pin = (AFOPin)treeNode.getUserObject();
            int address = ((GenericNode)pin.getParentNode()).getAddressList().get(0);
            DeviceData dd = new DeviceData(0, address, null, pin.getPinIDString(), null);
            dd.setDeviceComment(pin.getParentNode().getComment() + "-" + pin.getLabel());
            this.selectedNodes.add(dd);
            this.treeProject.removeSelectionPath(temp);
        }
    }

    private void generateCsvFile(File sFileName) {
        this.getSelectedNodes();
        if (this.selectedNodes.isEmpty()) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(sFileName);
            for (DeviceData dd : this.selectedNodes) {
                ArrayList<SingleValDataEntry> list = this.getDeviceDataFromDB(dd);
                if (list == null || list.isEmpty()) continue;
                for (int i = 0; i < list.size(); ++i) {
                    SingleValDataEntry data = list.get(i);
                    writer.append(Integer.toString(data.getAddress()) + ";");
                    writer.append(dd.getDeviceComment() + ";");
                    writer.append(data.getTimestamp().toString() + ";");
                    writer.append(Float.toString(data.getValue()) + "\r\n");
                }
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void LoadDBBtnActionPerformed(ActionEvent evt) {
        this.loadDB();
    }

    private void eraseDBBtnActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Attenzione l'operazione canceller\u00e0 i dati contenuti nel DB.\nContinuare ?", "Informazione", 2) != 0) {
            return;
        }
        try {
            if (!this.db.isConnected()) {
                this.db.connect();
                this.disconnectOnExit = true;
            }
            if (this.db.cleanDBData()) {
                this.loadDB();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Errore!! Oggetto DB vuoto\n" + e.getMessage());
            return;
        }
    }

    private void chartTreeData() {
        this.getSelectedNodes();
        if (this.selectedNodes.size() == 0) {
            return;
        }
        this.myChart = ChartFactory.createTimeSeriesChart((String)"Data Chart", (String)"Time", (String)"", null, (boolean)true, (boolean)true, (boolean)false);
        RefineryUtilities.centerFrameOnScreen((Window)this.pf);
        this.tct = new TreeChartTask();
        this.tct.addPropertyChangeListener(this);
        this.tct.execute();
        ChartFrame myChartFrame = new ChartFrame("Data Chart", this.myChart);
        myChartFrame.pack();
        RefineryUtilities.centerFrameOnScreen((Window)myChartFrame);
        myChartFrame.setVisible(true);
        this.pf.setVisible(true);
    }

    private void chartBtnActionPerformed(ActionEvent evt) {
        this.myChart = ChartFactory.createTimeSeriesChart((String)"Data Chart", (String)"Time", (String)"", null, (boolean)true, (boolean)true, (boolean)false);
        this.chartTreeData();
    }

    private void rgenerateDBBtnActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Attenzione l'operazione canceller\u00e0 il database, compresi i dispositivi.\nContinuare ?", "Informazione", 2) != 0) {
            return;
        }
        try {
            String dbPath;
            File dbDir;
            if (this.db.isConnected()) {
                this.db.disconnect();
            }
            if (Project.deleteDirectory(dbDir = new File(dbPath = this.db.getDatabaseLocation()))) {
                this.db = new AfoDBDao();
            }
            this.db.connect();
            this.loadDB();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.generateCsvFile(fc.getSelectedFile());
        }
    }

    private void btnErrorsActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ManageDBFrame(null).setVisible(true);
            }
        });
    }

    class TreeChartTask
    extends SwingWorker<Void, Void> {
        int progress = 0;

        TreeChartTask() {
        }

        @Override
        public Void doInBackground() {
            this.setProgress(0);
            this.taskChartData();
            return null;
        }

        private void taskChartData() {
            int nOfDataset = 0;
            int valueDataSetNumber = -1;
            TimeSeriesCollection valueDataSet = new TimeSeriesCollection();
            StandardXYItemRenderer valueRenderer = new StandardXYItemRenderer();
            XYPlot plot = ManageDBFrame.this.myChart.getXYPlot();
            NumberAxis axis = null;
            for (DeviceData dd : ManageDBFrame.this.selectedNodes) {
                ArrayList list;
                TimeSeries graphSeries = null;
                if (valueDataSetNumber < 0) {
                    valueDataSetNumber = nOfDataset++;
                    plot.setDataset(valueDataSetNumber, (XYDataset)valueDataSet);
                    axis = new NumberAxis("Value");
                    plot.setRangeAxis(valueDataSetNumber, (ValueAxis)axis);
                    plot.mapDatasetToRangeAxis(valueDataSetNumber, valueDataSetNumber);
                    axis.setAutoRange(false);
                    axis.setRange(0.0, 35.0);
                    plot.setRenderer(valueDataSetNumber, (XYItemRenderer)valueRenderer);
                }
                if ((list = ManageDBFrame.this.getDeviceDataFromDB(dd)) == null || list.size() == 0) {
                    return;
                }
                graphSeries = new TimeSeries((Comparable)((Object)dd.getDeviceComment()));
                valueDataSet.addSeries(graphSeries);
                valueRenderer.setSeriesStroke(valueDataSet.getSeries().size() - 1, (Stroke)new BasicStroke(2.0f));
                this.taskDrawData(list, graphSeries);
            }
        }

        @Override
        public void done() {
            ManageDBFrame.this.pf.setVisible(false);
        }

        private void taskDrawData(ArrayList<SingleValDataEntry> list, TimeSeries graphSeries) {
            int numTot = list.size();
            for (int i = 0; i < numTot; ++i) {
                if (i % 10 == 0) {
                    ((ManageDBFrame)ManageDBFrame.this).pf.lblMessageLabel.setText("Dato " + i + " su " + numTot);
                    this.progress = (int)((double)i / (double)numTot * 100.0);
                    this.setProgress(this.progress);
                }
                Timestamp ts = list.get(i).getTimestamp();
                Second now = Second.parseSecond((String)ts.toString());
                float val = list.get(i).getValue();
                graphSeries.addOrUpdate((RegularTimePeriod)now, (double)val);
            }
        }
    }
}

