/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.devices.GenericNode;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class MonitorDialog_2
extends JDialog
implements TableModelListener {
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    private static final int MAX_NUM_ROWS = 38;
    private int returnStatus;
    private final String device_ID;
    Locale currentLocale;
    private AppOptions options = new AppOptions();
    ResourceBundle message;
    boolean dataChanged = false;
    GenericNode parentNode;
    FieldChangeListener fcl = new FieldChangeListener();
    public JButton btnCancel;
    public JButton btnDeleteRow;
    public JButton btnGiu;
    public JButton btnInsert;
    public JButton btnOk;
    public JButton btnSu;
    public JCheckBox chkUsePassword;
    public JCheckBox chkUseStates;
    public JComboBox comboPwd1;
    public JComboBox comboPwd2;
    public JComboBox comboPwd3;
    public JComboBox comboPwd4;
    public JComboBox comboPwd5;
    public JComboBox comboPwd6;
    public JLabel indexLabel;
    public JLabel jLabel10;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;
    public JTable table;
    public JTextField txtAddress;

    public MonitorDialog_2(Frame parent, boolean modal, String device_ID, GenericNode parentNode) {
        super(parent, modal);
        this.device_ID = device_ID;
        this.initComponents();
        this.center();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.btnInsert.setText(this.message.getString("ins"));
        this.btnDeleteRow.setText(this.message.getString("el"));
        JComboBox<String> typeCombo = new JComboBox<String>();
        typeCombo.addItem("Normal");
        typeCombo.addItem("Config");
        typeCombo.addItem("Reserved");
        TableColumn col = this.table.getColumnModel().getColumn(5);
        col.setCellEditor(new DefaultCellEditor(typeCombo));
        this.parentNode = parentNode;
        this.addComponentListener(new ComponentAdapter());
    }

    private void initComponents() {
        this.btnSu = new JButton();
        this.btnGiu = new JButton();
        this.jLabel10 = new JLabel();
        this.txtAddress = new JTextField();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.btnInsert = new JButton();
        this.btnDeleteRow = new JButton();
        this.chkUseStates = new JCheckBox();
        this.indexLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.chkUsePassword = new JCheckBox();
        this.comboPwd1 = new JComboBox();
        this.comboPwd2 = new JComboBox();
        this.comboPwd3 = new JComboBox();
        this.comboPwd4 = new JComboBox();
        this.comboPwd5 = new JComboBox();
        this.comboPwd6 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(MonitorDialog_2.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.btnSu.setText(resourceMap.getString("btnSu.text", new Object[0]));
        this.btnSu.setName("btnSu");
        this.btnSu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.btnSuActionPerformed(evt);
            }
        });
        this.btnGiu.setText(resourceMap.getString("btnGiu.text", new Object[0]));
        this.btnGiu.setName("btnGiu");
        this.btnGiu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.btnGiuActionPerformed(evt);
            }
        });
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.txtAddress.setColumns(5);
        this.txtAddress.setHorizontalAlignment(11);
        this.txtAddress.setText(resourceMap.getString("txtAddress.text", new Object[0]));
        this.txtAddress.setName("txtAddress");
        this.btnOk.setIcon(resourceMap.getIcon("btnOk.icon"));
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setIcon(resourceMap.getIcon("btnCancel.icon"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnInsert.setText(resourceMap.getString("btnInsert.text", new Object[0]));
        this.btnInsert.setName("btnInsert");
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.btnInsertActionPerformed(evt);
            }
        });
        this.btnDeleteRow.setText(resourceMap.getString("btnDeleteRow.text", new Object[0]));
        this.btnDeleteRow.setToolTipText(resourceMap.getString("btnDeleteRow.toolTipText", new Object[0]));
        this.btnDeleteRow.setName("btnDeleteRow");
        this.btnDeleteRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.btnDeleteRowActionPerformed(evt);
            }
        });
        this.chkUseStates.setText(resourceMap.getString("chkUseStates.text", new Object[0]));
        this.chkUseStates.setName("chkUseStates");
        this.chkUseStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog_2.this.chkUseStatesActionPerformed(evt);
            }
        });
        this.indexLabel.setFont(resourceMap.getFont("indexLabel.font"));
        this.indexLabel.setForeground(resourceMap.getColor("indexLabel.foreground"));
        this.indexLabel.setText(resourceMap.getString("indexLabel.text", new Object[0]));
        this.indexLabel.setName("indexLabel");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.chkUsePassword.setText(resourceMap.getString("chkUsePassword.text", new Object[0]));
        this.chkUsePassword.setName("chkUsePassword");
        this.chkUsePassword.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.chkUsePasswordItemStateChanged(evt);
            }
        });
        this.comboPwd1.setModel(new DefaultComboBoxModel<String>(new String[]{"Menu", "Up", "Cancel", "Down"}));
        this.comboPwd1.setName("comboPwd1");
        this.comboPwd1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.comboPwd1ItemStateChanged(evt);
            }
        });
        this.comboPwd2.setModel(new DefaultComboBoxModel<String>(new String[]{"Menu", "Up", "Cancel", "Down"}));
        this.comboPwd2.setName("comboPwd2");
        this.comboPwd2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.comboPwd2ItemStateChanged(evt);
            }
        });
        this.comboPwd3.setModel(new DefaultComboBoxModel<String>(new String[]{"Menu", "Up", "Cancel", "Down"}));
        this.comboPwd3.setName("comboPwd3");
        this.comboPwd3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.comboPwd3ItemStateChanged(evt);
            }
        });
        this.comboPwd4.setModel(new DefaultComboBoxModel<String>(new String[]{"Menu", "Up", "Cancel", "Down"}));
        this.comboPwd4.setName("comboPwd4");
        this.comboPwd4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.comboPwd4ItemStateChanged(evt);
            }
        });
        this.comboPwd5.setModel(new DefaultComboBoxModel<String>(new String[]{"Menu", "Up", "Cancel", "Down"}));
        this.comboPwd5.setName("comboPwd5");
        this.comboPwd5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.comboPwd5ItemStateChanged(evt);
            }
        });
        this.comboPwd6.setModel(new DefaultComboBoxModel<String>(new String[]{"Menu", "Up", "Cancel", "Down"}));
        this.comboPwd6.setName("comboPwd6");
        this.comboPwd6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog_2.this.comboPwd6ItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUsePassword).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboPwd1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.comboPwd2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.comboPwd3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.comboPwd4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.comboPwd5, -2, -1, -2).addGap(18, 18, 18).addComponent(this.comboPwd6, -2, -1, -2))).addContainerGap(26, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.chkUsePassword).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboPwd1, -2, -1, -2).addComponent(this.comboPwd2, -2, -1, -2).addComponent(this.comboPwd3, -2, -1, -2).addComponent(this.comboPwd4, -2, -1, -2).addComponent(this.comboPwd5, -2, -1, -2).addComponent(this.comboPwd6, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{"None", new Float(0.0), new Float(0.0), new Float(0.0), new Float(0.0), null}}, new String[]{"Nome", "MIN", "MAX", "STEP", "Default", "Type"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Float.class, Float.class, Float.class, Float.class, Object.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setName("table");
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.chkUseStates).addGap(18, 18, 18).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAddress, -2, -1, -2).addGap(18, 18, 18).addComponent(this.indexLabel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOk).addGap(18, 18, 18).addComponent(this.btnCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 470, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnSu, -1, -1, Short.MAX_VALUE).addComponent(this.btnGiu, -1, -1, Short.MAX_VALUE).addComponent(this.btnDeleteRow, -1, -1, Short.MAX_VALUE).addComponent(this.btnInsert, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.chkUseStates).addComponent(this.txtAddress, -2, -1, -2).addComponent(this.indexLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1, -2, 273, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnSu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGiu, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnDeleteRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnInsert))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void btnSuActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedRows().length > 1) {
            JOptionPane.showMessageDialog(null, this.message.getString("seluna"));
        }
        if (this.table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("sel"));
        }
        if (this.table.getSelectedRows().length == 1) {
            int selectedRowIndex = this.table.getSelectedRow();
            if (selectedRowIndex == 0) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(selectedRowIndex, selectedRowIndex, selectedRowIndex - 1);
            this.table.setRowSelectionInterval(selectedRowIndex - 1, selectedRowIndex - 1);
        }
    }

    public boolean getDataChanged() {
        return this.dataChanged;
    }

    public void disableListeners() {
        this.table.getModel().removeTableModelListener(this);
    }

    public void showDialog() {
        this.table.getModel().addTableModelListener(this);
        this.dataChanged = false;
        this.setVisible(true);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void btnGiuActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedRows().length > 1) {
            JOptionPane.showMessageDialog(null, this.message.getString("seluna"));
        }
        if (this.table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("sel"));
        }
        if (this.table.getSelectedRows().length == 1) {
            int selectedRowIndex = this.table.getSelectedRow();
            if (selectedRowIndex == this.table.getRowCount()) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(selectedRowIndex, selectedRowIndex, selectedRowIndex + 1);
            this.table.setRowSelectionInterval(selectedRowIndex + 1, selectedRowIndex + 1);
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        int i;
        this.returnStatus = 1;
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        for (i = 0; i < model.getRowCount(); ++i) {
            String label = model.getValueAt(i, 0).toString();
            if (label.length() <= 15) continue;
            String errore = this.message.getString("labelTooLong") + (i + 1);
            JOptionPane.showMessageDialog(null, errore, "Error", 0);
            return;
        }
        for (i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                if (model.getValueAt(i, j) != null) continue;
                model.setValueAt(0, i, j);
            }
        }
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    private void btnInsertActionPerformed(ActionEvent evt) {
        if (this.table.getRowCount() == 38) {
            JOptionPane.showMessageDialog(null, this.message.getString("maxrow"), this.message.getString("er"), 2);
            return;
        }
        JComboBox<String> typeCombo = new JComboBox<String>();
        typeCombo.addItem("Normal");
        typeCombo.addItem("Config");
        typeCombo.addItem("Reserved");
        typeCombo.setSelectedIndex(0);
        if (this.table.getSelectedRow() >= 0) {
            ((DefaultTableModel)this.table.getModel()).insertRow(this.table.getSelectedRow(), new Object[]{"", "0.0", "0.0", "0.0", "0.0", "Normal"});
        } else if (this.table.getRowCount() == 0) {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"", "0.0", "0.0", "0.0", "0.0", "Normal"});
        } else {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"", "0.0", "0.0", "0.0", "0.0", "Normal"});
        }
        TableColumn col = this.table.getColumnModel().getColumn(5);
        col.setCellEditor(new DefaultCellEditor(typeCombo));
    }

    private void btnDeleteRowActionPerformed(ActionEvent evt) {
        Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
        if (JOptionPane.showOptionDialog(null, this.message.getString("sicuro"), this.message.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 1) {
            return;
        }
        boolean finish = false;
        while (!finish) {
            int[] selRows = this.table.getSelectedRows();
            if (selRows.length > 0) {
                ((DefaultTableModel)this.table.getModel()).removeRow(selRows[0]);
                continue;
            }
            finish = true;
        }
    }

    private void chkUseStatesActionPerformed(ActionEvent evt) {
        this.dataChanged = true;
    }

    private void chkUsePasswordItemStateChanged(ItemEvent evt) {
        this.comboPwd1.setEnabled(this.chkUsePassword.isSelected());
        this.comboPwd2.setEnabled(this.chkUsePassword.isSelected());
        this.comboPwd3.setEnabled(this.chkUsePassword.isSelected());
        this.comboPwd4.setEnabled(this.chkUsePassword.isSelected());
        this.comboPwd5.setEnabled(this.chkUsePassword.isSelected());
        this.comboPwd6.setEnabled(this.chkUsePassword.isSelected());
        this.dataChanged = true;
    }

    private void comboPwd1ItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    private void comboPwd2ItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    private void comboPwd3ItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    private void comboPwd4ItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    private void comboPwd5ItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    private void comboPwd6ItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MonitorDialog_2 dialog = new MonitorDialog_2((Frame)new JFrame(), true, "ds18s20", null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private void setupTableColumns(JTable table) {
        TableColumn levelColumn = table.getColumnModel().getColumn(2);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setAlignmentX(0.5f);
        levelColumn.setCellEditor(new DefaultCellEditor(checkBox));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.dataChanged = true;
    }

    class ComponentAdapter
    implements ComponentListener {
        ComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            MonitorDialog_2.this.txtAddress.setEnabled(!MonitorDialog_2.this.parentNode.kernelConnected);
            MonitorDialog_2.this.txtAddress.getDocument().addDocumentListener(MonitorDialog_2.this.fcl);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            MonitorDialog_2.this.txtAddress.getDocument().removeDocumentListener(MonitorDialog_2.this.fcl);
        }
    }

    class FieldChangeListener
    implements DocumentListener {
        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MonitorDialog_2.this.dataChanged = true;
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MonitorDialog_2.this.dataChanged = true;
            this.control();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MonitorDialog_2.this.dataChanged = true;
            this.control();
        }

        public void control() {
            if (MonitorDialog_2.this.txtAddress.getText().equals("")) {
                MonitorDialog_2.this.indexLabel.setVisible(true);
            }
            if (MonitorDialog_2.this.parentNode.controlAddress(MonitorDialog_2.this.txtAddress.getText(), false).booleanValue()) {
                MonitorDialog_2.this.indexLabel.setVisible(true);
            } else {
                MonitorDialog_2.this.indexLabel.setVisible(false);
            }
        }
    }
}

