/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import VisiProg.AppOptions;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.SerialKernel;
import connection.gui.CRC16;
import connection.gui.InfoDialog;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nodes.BoardsTypesAndDescription;
import nodes.ComPort;
import nodes.Project;
import org.openide.util.Exceptions;

public class ProjectDialog
extends JPanel
implements ActionListener,
IKernelEventListener {
    private BoardsTypesAndDescription.BoardType boardType;
    private JDialog dialog;
    private ComPort[] portList;
    private Project proj;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();
    InfoDialog idlg;
    public JButton btnClose;
    public JButton btnConfigurePorts;
    public JButton btnRescan;
    public JButton btnResetToNTH;
    public JComboBox comboPort;
    public JComboBox comboPortSpeed;
    public JCheckBox jCheckBox1;
    public JCheckBox jCheckBox2;
    public JCheckBox jCheckBox3;
    public JLabel jLabel1;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JPanel jPanel1;
    public JPanel jPanel3;
    public JSeparator jSeparator1;
    public JLabel lblIPAddress;
    public JLabel lblIPPort;
    public JLabel lblPortSpeed;
    public JSpinner spnNewBoardAddress;
    public JTextField txtIPAddress;
    public JTextField txtIPPort;

    public ProjectDialog(Project proj, ComPort[] list) {
        this.initComponents();
        this.SetupButtons();
        this.populatePortCombo();
        this.invalidate();
        this.portList = list;
        this.btnConfigurePorts.setVisible(false);
        this.proj = proj;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jCheckBox3 = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.btnConfigurePorts = new JButton();
        this.jLabel3 = new JLabel();
        this.spnNewBoardAddress = new JSpinner();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.comboPort = new JComboBox();
        this.lblIPAddress = new JLabel();
        this.txtIPAddress = new JTextField();
        this.lblIPPort = new JLabel();
        this.txtIPPort = new JTextField();
        this.lblPortSpeed = new JLabel();
        this.comboPortSpeed = new JComboBox();
        this.btnRescan = new JButton();
        this.btnResetToNTH = new JButton();
        this.btnClose = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(800, 600));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("System"));
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/VisiProg/resources/browser.png")));
        this.jCheckBox1.setBackground(new Color(255, 255, 255));
        this.jCheckBox1.setText("Enable Web Server");
        this.jCheckBox1.setContentAreaFilled(false);
        this.jCheckBox1.setEnabled(false);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/VisiProg/resources/USB.jpg")));
        this.jLabel4.setText("sss");
        this.jCheckBox2.setBackground(new Color(255, 255, 255));
        this.jCheckBox2.setText("USB Support");
        this.jCheckBox2.setContentAreaFilled(false);
        this.jCheckBox2.setEnabled(false);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/VisiProg/resources/sd_mmc_mount.png")));
        this.jCheckBox3.setText("SD File System");
        this.jCheckBox3.setContentAreaFilled(false);
        this.jCheckBox3.setEnabled(false);
        this.btnConfigurePorts.setText("Configure Ports");
        this.btnConfigurePorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDialog.this.btnConfigurePortsActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Board Address :");
        this.spnNewBoardAddress.setModel(new SpinnerNumberModel(1, 1, 65535, 1));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBox1).addGap(18, 18, 18).addComponent(this.jCheckBox2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(61, 61, 61).addComponent(this.jLabel6)).addGroup(jPanel3Layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.jCheckBox3)))).addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jSeparator1, -1, 738, Short.MAX_VALUE)).addComponent(this.btnConfigurePorts).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnNewBoardAddress, -2, -1, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spnNewBoardAddress, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.btnConfigurePorts).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel6, 0, 0, Short.MAX_VALUE).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2).addComponent(this.jCheckBox3)).addContainerGap()));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Upload Port"));
        this.jLabel1.setText("Port :");
        this.comboPort.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDialog.this.comboPortActionPerformed(evt);
            }
        });
        this.lblIPAddress.setText("IP Address:");
        this.txtIPAddress.setColumns(9);
        this.txtIPAddress.setHorizontalAlignment(11);
        this.txtIPAddress.setText("192.168.1.67");
        this.txtIPAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDialog.this.txtIPAddressActionPerformed(evt);
            }
        });
        this.lblIPPort.setText("IP Port :");
        this.txtIPPort.setColumns(5);
        this.txtIPPort.setHorizontalAlignment(11);
        this.txtIPPort.setText("23");
        this.lblPortSpeed.setText("Speed :");
        this.comboPortSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"115200", "57600", "38400", "19200", "9600"}));
        this.btnRescan.setText("Rescan");
        this.btnRescan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDialog.this.btnRescanActionPerformed(evt);
            }
        });
        this.btnResetToNTH.setText("Reset RS1");
        this.btnResetToNTH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDialog.this.btnResetToNTHActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblIPAddress).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboPort, -2, -1, -2).addComponent(this.txtIPAddress, -2, -1, -2)).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblIPPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtIPPort, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblPortSpeed).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboPortSpeed, -2, -1, -2).addGap(18, 18, 18).addComponent(this.btnRescan).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 302, Short.MAX_VALUE).addComponent(this.btnResetToNTH))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboPort, -2, -1, -2).addComponent(this.lblPortSpeed).addComponent(this.comboPortSpeed, -2, -1, -2).addComponent(this.btnRescan).addComponent(this.btnResetToNTH)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblIPAddress).addComponent(this.lblIPPort).addComponent(this.txtIPPort, -2, -1, -2).addComponent(this.txtIPAddress, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/VisiProg/resources/icons_big/exit.png")));
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDialog.this.btnCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.btnClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.btnClose).addContainerGap(195, Short.MAX_VALUE)));
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (this.comboPort.getSelectedIndex() == 0) {
            this.proj.getPortList()[2].ipAddress = this.txtIPAddress.getText();
        }
        if (this.comboPort.getSelectedIndex() != 0) {
            int i = this.comboPortSpeed.getSelectedIndex();
            String a = null;
            if (i == 0) {
                a = "115200";
            } else if (i == 1) {
                a = "57600";
            } else if (i == 2) {
                a = "38400";
            } else if (i == 3) {
                a = "19200";
            } else if (i == 4) {
                a = "9600";
            }
            this.proj.getPortList()[0].serSpeed = a;
        }
        this.dialog.setVisible(false);
    }

    private void comboPortActionPerformed(ActionEvent evt) {
        if (this.comboPort.getSelectedIndex() == 0) {
            this.displayEthernetParams(true);
        } else {
            this.displayEthernetParams(false);
        }
    }

    private void btnConfigurePortsActionPerformed(ActionEvent evt) {
    }

    private void txtIPAddressActionPerformed(ActionEvent evt) {
    }

    private void btnRescanActionPerformed(ActionEvent evt) {
        this.comboPort.removeAllItems();
        this.populatePortCombo();
    }

    private void btnResetToNTHActionPerformed(ActionEvent evt) {
        try {
            this.proj.createKernel();
            ((SerialKernel)this.proj.getKernel()).removeKernelEventListener(this.proj);
            ((SerialKernel)this.proj.getKernel()).addKernelEventListener(this);
            ((SerialKernel)this.proj.getKernel()).connectAndStop(true);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void centerDialog() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.dialog.getBounds();
        this.dialog.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private void SetupButtons() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void showDialog(JFrame f) {
        if (this.dialog == null || this.dialog.getOwner() != f) {
            this.dialog = new JDialog((Frame)f, true);
            this.dialog.getContentPane().add(this);
        }
        this.spnNewBoardAddress.setValue(Integer.parseInt(this.proj.getBoardAddress()));
        switch (Integer.parseInt(this.proj.getPortList()[0].serSpeed)) {
            case 115200: {
                this.comboPortSpeed.setSelectedIndex(0);
                break;
            }
            case 57600: {
                this.comboPortSpeed.setSelectedIndex(1);
                break;
            }
            case 38400: {
                this.comboPortSpeed.setSelectedIndex(2);
                break;
            }
            case 19200: {
                this.comboPortSpeed.setSelectedIndex(3);
                break;
            }
            case 9600: {
                this.comboPortSpeed.setSelectedIndex(4);
            }
        }
        this.txtIPAddress.setText(this.proj.getPortList()[2].ipAddress);
        this.dialog.setSize(new Dimension(570, 600));
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.message.getString("carpro"));
        this.centerDialog();
        this.dialog.setVisible(true);
    }

    public static HashSet<CommPortIdentifier> getAvailableSerialPorts() {
        HashSet<CommPortIdentifier> h = new HashSet<CommPortIdentifier>();
        try {
            Enumeration thePorts = CommPortIdentifier.getPortIdentifiers();
            while (thePorts.hasMoreElements()) {
                CommPortIdentifier com = (CommPortIdentifier)thePorts.nextElement();
                switch (com.getPortType()) {
                    case 1: {
                        try {
                            CommPort thePort = com.open("CommUtil", 50);
                            thePort.close();
                            h.add(com);
                            break;
                        }
                        catch (PortInUseException e) {
                            System.out.println("Port, " + com.getName() + ", is in use.");
                            break;
                        }
                        catch (Exception e) {
                            System.err.println("Failed to open port " + com.getName());
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return h;
    }

    private void populatePortCombo() {
        this.comboPort.removeAllItems();
        this.comboPort.addItem("Ethernet");
        this.displayEthernetParams(true);
        HashSet<CommPortIdentifier> portsList = ProjectDialog.getAvailableSerialPorts();
        for (CommPortIdentifier ci : portsList) {
            if (ci.getPortType() != 1) continue;
            this.comboPort.addItem(ci.getName());
        }
        this.validate();
    }

    private void displayEthernetParams(boolean display) {
        this.lblIPAddress.setVisible(display);
        this.txtIPAddress.setVisible(display);
        this.lblIPPort.setVisible(display);
        this.txtIPPort.setVisible(display);
        this.comboPortSpeed.setVisible(!display);
        this.lblPortSpeed.setVisible(!display);
        this.btnResetToNTH.setVisible(!display);
        this.invalidate();
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Kernel Connected")) {
            byte[] msg = new byte[32];
            msg[0] = Byte.parseByte(this.proj.getBoardAddress());
            msg[1] = 6;
            msg[2] = 0;
            msg[3] = 100;
            msg[4] = 0;
            msg[5] = 1;
            int crcInt = CRC16.doCRC16(msg, 0, 6);
            byte[] crc = CRC16.intToByteArray(crcInt);
            msg[6] = crc[3];
            msg[7] = crc[2];
            SerialKernel kernel = (SerialKernel)this.proj.getKernel();
            kernel.writeOutBinaryMessge(msg, 8);
            this.proj.disconnect();
            this.idlg = new InfoDialog(null, false);
            this.idlg.label.setText("Attendere ...");
            this.dialog.setModal(false);
            this.idlg.setModal(true);
            this.idlg.toFront();
            this.idlg.showTimedDialog(10);
        } else if (!evt.getEventType().equals("Timeout on command") && !evt.getEventType().equals("Command Not Executed") && evt.getEventType().equals("Kernel Disconnected")) {
            this.dialog.setModal(true);
            this.comboPortSpeed.setSelectedItem("115200");
            this.invalidate();
        }
    }

    public void enableControls(boolean enable) {
        this.comboPort.setEnabled(enable);
        this.comboPortSpeed.setEnabled(enable);
        this.btnResetToNTH.setEnabled(enable);
        this.spnNewBoardAddress.setEnabled(enable);
        this.btnRescan.setEnabled(enable);
    }
}

