/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import nodes.AFONodeWidget;
import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;

public class AFOCollisionCollector
implements CollisionsCollector {
    private AFOGraphPinScene scene;
    ConnectionWidget connWidget;

    public AFOCollisionCollector(AFOGraphPinScene scene, ConnectionWidget cw) {
        this.scene = scene;
        this.connWidget = cw;
    }

    public void collectCollisions(List<Rectangle> verticalCollisions, List<Rectangle> horizontalCollisions) {
        try {
            Point point = new Point();
            Widget nodeWidget = this.connWidget.getSourceAnchor().getRelatedWidget().getParentWidget();
            Widget moduleWidget = nodeWidget.getParentWidget();
            for (AFONode afoNode : this.scene.getNodes()) {
                try {
                    Widget tempWdg = ((AFONodeWidget)afoNode.getWidget()).getOutputs();
                    if (!tempWdg.equals((Object)nodeWidget)) continue;
                    nodeWidget = afoNode.getWidget();
                    moduleWidget = afoNode.getOverallWidget();
                }
                catch (ClassCastException ex) {}
            }
            point.x = nodeWidget.getLocation().x + moduleWidget.getLocation().x;
            point.y = nodeWidget.getLocation().y + moduleWidget.getLocation().y;
            Dimension dim = new Dimension(moduleWidget.getBounds().width, moduleWidget.getBounds().height);
            Rectangle rec = new Rectangle(point, dim);
            verticalCollisions.clear();
            horizontalCollisions.clear();
            horizontalCollisions.add(rec);
            verticalCollisions.add(rec);
            nodeWidget = this.connWidget.getTargetAnchor().getRelatedWidget().getParentWidget();
            moduleWidget = nodeWidget.getParentWidget();
            for (AFONode afoNode : this.scene.getNodes()) {
                try {
                    Widget tempWdg = ((AFONodeWidget)afoNode.getWidget()).getInputs();
                    if (!tempWdg.equals((Object)nodeWidget)) continue;
                    nodeWidget = afoNode.getWidget();
                    moduleWidget = afoNode.getOverallWidget();
                }
                catch (ClassCastException ex) {}
            }
            point.x = nodeWidget.getLocation().x + moduleWidget.getLocation().x;
            point.y = nodeWidget.getLocation().y + moduleWidget.getLocation().y;
            dim = new Dimension(moduleWidget.getBounds().width, moduleWidget.getBounds().height);
            rec = new Rectangle(point, dim);
            horizontalCollisions.add(rec);
            verticalCollisions.add(rec);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

