/*
 * Decompiled with CFR 0.152.
 */
package sceneManager;

import java.awt.Point;
import java.util.ConcurrentModificationException;
import nodes.CommonDefinitions;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;
import sceneManager.AFOPin;
import sceneManager.AFOPinWidget;

class AfoConnectProvider
implements ConnectProvider {
    private AFOGraphPinScene scene;
    private LayerWidget connectionLayer;
    private int edgeTest = 0;
    private boolean enableConnect = true;

    public AfoConnectProvider(AFOGraphPinScene aThis, LayerWidget connectionLayer) {
        this.scene = aThis;
        this.connectionLayer = connectionLayer;
    }

    public boolean isSourceWidget(Widget sourceWidget) {
        if (sourceWidget instanceof AFOPinWidget) {
            return !((AFOPinWidget)sourceWidget).getInputState();
        }
        return false;
    }

    public ConnectorState isTargetWidget(Widget sourceWidget, Widget targetWidget) {
        if (targetWidget instanceof AFOPinWidget) {
            if (targetWidget != sourceWidget) {
                if (((AFOPinWidget)targetWidget).getInputState()) {
                    AFOPin sourcePin = (AFOPin)this.scene.findObject(sourceWidget);
                    AFONode sourceNode = sourcePin.getParentNode();
                    int sourceOrdinal = sourceNode.blockType.ordinal();
                    AFOPin targetPin = (AFOPin)this.scene.findObject(targetWidget);
                    AFONode targetNode = targetPin.getParentNode();
                    int targetOrdinal = targetNode.blockType.ordinal();
                    if (sourceOrdinal <= CommonDefinitions.blockTypes.ModbusOUT.ordinal() && targetOrdinal <= CommonDefinitions.blockTypes.ModbusOUT.ordinal()) {
                        return ConnectorState.ACCEPT;
                    }
                    if (((AFOPin)this.scene.findObject((Widget)sourceWidget)).getParentNode().blockType == CommonDefinitions.blockTypes.IN && ((AFOPin)this.scene.findObject((Widget)targetWidget)).getParentNode().blockType == CommonDefinitions.blockTypes.OUT) {
                        return ConnectorState.REJECT;
                    }
                    return ConnectorState.ACCEPT;
                }
                return ConnectorState.REJECT;
            }
            return ConnectorState.REJECT;
        }
        return ConnectorState.REJECT_AND_STOP;
    }

    public boolean hasCustomTargetWidgetResolver(Scene arg0) {
        return false;
    }

    public Widget resolveTargetWidget(Scene arg0, Point arg1) {
        return null;
    }

    public void createConnection(Widget sourceWidget, Widget targetWidget) {
        if (!this.enableConnect) {
            return;
        }
        AFOPin srcPin = (AFOPin)this.scene.findObject(sourceWidget);
        AFOPin trgPin = (AFOPin)this.scene.findObject(targetWidget);
        String edgeID = "edge";
        if (this.scene.findPinEdges(trgPin, false, true).size() > 0) {
            return;
        }
        edgeID = edgeID + ++this.scene.edgeIDcounter;
        AFOEdge newEdge = new AFOEdge(edgeID, edgeID, null);
        newEdge.setColor(this.scene.getEdgeColor());
        this.scene.addEdge(newEdge);
        this.scene.setEdgeSource(newEdge, srcPin);
        this.scene.setEdgeTarget(newEdge, trgPin);
        try {
            this.scene.validate();
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
    }

    void enableConnect(boolean enable) {
        this.enableConnect = enable;
    }
}

